/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.lttng2.control.ui.swtbot.tests;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.swtbot.swt.finder.SWTBot;
import org.eclipse.swtbot.swt.finder.junit.SWTBotJunit4ClassRunner;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotMenu;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotShell;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotText;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTree;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTreeItem;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.TraceSessionState;
import org.eclipse.tracecompass.lttng2.control.ui.swtbot.tests.ControlViewTest;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.ConditionHelpers;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.SWTBotUtils;
import org.eclipse.tracecompass.tmf.ui.tests.shared.WaitUtils;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=SWTBotJunit4ClassRunner.class)
public class ControlViewSpecificEventTest
extends ControlViewTest {
    private static final String TEST_STREAM = "CreateSessionTestLTTng2_8.cfg";
    private static final String CREATE_SESSION_SPECIFIC_KERNEL_EVENT_SCENARIO_NAME = "CreateSessionSpecificKernelEvent";
    private static final String SESSION_NAME = "mysession";

    @Override
    protected String getTestStream() {
        return TEST_STREAM;
    }

    @Override
    protected String getSessionName() {
        return SESSION_NAME;
    }

    @Override
    @Test
    public void testTraceSessionTree() {
        this.fProxy.setTestFile(this.fTestFile);
        this.fProxy.setScenario("Initialize");
        this.testConnectToNode();
        this.fProxy.setScenario(CREATE_SESSION_SPECIFIC_KERNEL_EVENT_SCENARIO_NAME);
        this.testCreateSession();
        this.testEnableSpecificKernelEvent(Arrays.asList("sched_switch"), false, true);
        this.testEnableSpecificKernelEvent(Arrays.asList("sched_wakeup", "sched_process_wait"), false, true);
        this.testEnableSpecificKernelEvent(Arrays.asList("sched_process_fork"), true, true);
        this.testEnableSpecificKernelEvent(Arrays.asList("sched_process_exec"), true, false);
        this.testEnableSpecificKernelEvent(Arrays.asList("All"), true, true);
        this.testStartStopTracing(TraceSessionState.ACTIVE);
        this.testStartStopTracing(TraceSessionState.INACTIVE);
        this.testDestroySession();
        this.testDisconnectFromNode();
    }

    private void testEnableSpecificKernelEvent(List<String> events, boolean selectInTree, boolean useNameField) {
        SWTBotTreeItem sessionItem = SWTBotUtils.getTreeItem((SWTBot)fBot, (SWTBotTree)this.fTree, (String[])new String[]{this.getNodeName(), "Sessions", this.getSessionName()});
        sessionItem.select();
        SWTBotMenu menuBot = sessionItem.contextMenu("Enable Event (default channel)...");
        menuBot.click();
        SWTBotShell shell = fBot.shell("Enable Events").activate();
        shell.bot().radioInGroup("Select", "Tracepoint Events").click();
        if (selectInTree) {
            SWTBotTree tracepointsTree = shell.bot().tree();
            for (String event : events) {
                SWTBotTreeItem treeItem;
                if (event.equals("All")) {
                    treeItem = tracepointsTree.getTreeItem("All");
                    treeItem.check();
                    break;
                }
                tracepointsTree.expandNode(new String[]{"All"});
                treeItem = SWTBotUtils.getTreeItem((SWTBot)fBot, (SWTBotTree)tracepointsTree, (String[])new String[]{"All", event});
                treeItem.check();
            }
        }
        if (useNameField) {
            SWTBotText specificEventText = shell.bot().textInGroup("Specific event");
            String suffix = "";
            StringBuffer buffer = new StringBuffer();
            for (String event : events) {
                buffer.append(suffix).append(event);
                suffix = ", ";
            }
            specificEventText.setText(buffer.toString());
        }
        shell.bot().button("Ok").click();
        WaitUtils.waitForJobs();
        fBot.waitUntil(ConditionHelpers.isTreeChildNodeAvailable((String)"Kernel", (SWTBotTreeItem)sessionItem));
        SWTBotTreeItem channelItem = SWTBotUtils.getTreeItem((SWTBot)fBot, (SWTBotTree)this.fTree, (String[])new String[]{this.getNodeName(), "Sessions", this.getSessionName(), "Kernel", "channel0"});
        Assert.assertEquals((Object)"channel0", (Object)channelItem.getText());
        channelItem.expand();
        Iterator<String> iterator = events.iterator();
        while (iterator.hasNext()) {
            String event;
            String eventName = event = iterator.next();
            if (event.equals("All")) {
                eventName = "*";
            }
            fBot.waitUntil(ConditionHelpers.isTreeChildNodeAvailable((String)eventName, (SWTBotTreeItem)channelItem));
            SWTBotTreeItem eventItem = SWTBotUtils.getTreeItem((SWTBot)fBot, (SWTBotTree)this.fTree, (String[])new String[]{this.getNodeName(), "Sessions", this.getSessionName(), "Kernel", "channel0", eventName});
            Assert.assertEquals((Object)eventName, (Object)eventItem.getText());
        }
    }
}

