/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.datastore.core.interval;

import java.util.Objects;
import java.util.StringJoiner;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.datastore.core.encoding.HTVarInt;
import org.eclipse.tracecompass.datastore.core.interval.IHTInterval;
import org.eclipse.tracecompass.datastore.core.interval.IHTIntervalReader;
import org.eclipse.tracecompass.datastore.core.serialization.ISafeByteBufferWriter;

public class HTInterval
implements IHTInterval {
    private final long fStart;
    private final long fDuration;
    public static final IHTIntervalReader<HTInterval> INTERVAL_READER = buffer -> {
        long start = buffer.getLong();
        return new HTInterval(start, start + HTVarInt.readLong(buffer));
    };

    public HTInterval(long start, long end) {
        if (end < start) {
            throw new IllegalArgumentException();
        }
        this.fStart = start;
        this.fDuration = end - start;
    }

    @Override
    public long getStart() {
        return this.fStart;
    }

    @Override
    public long getEnd() {
        return this.fStart + this.fDuration;
    }

    public String toString() {
        return new StringJoiner(", ", "[", "]").add(String.valueOf(this.fStart)).add(String.valueOf(this.fStart + this.fDuration)).toString();
    }

    @Override
    public int getSizeOnDisk() {
        return 8 + HTVarInt.getEncodedLengthLong(this.fDuration);
    }

    @Override
    public void writeSegment(@NonNull ISafeByteBufferWriter buffer) {
        buffer.putLong(this.fStart);
        HTVarInt.writeLong(buffer, this.fDuration);
    }

    public int hashCode() {
        return Objects.hash(this.fStart, this.fStart + this.fDuration);
    }

    public boolean equals(@Nullable Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        HTInterval other = (HTInterval)obj;
        return this.fStart == other.fStart && this.fDuration == other.fDuration;
    }
}

