/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.settings.model;

import org.eclipse.cdt.core.settings.model.ICStorageElement;
import org.eclipse.core.runtime.CoreException;

public class SynchronizedStorageElement
implements ICStorageElement {
    private final Object fLock;
    private final ICStorageElement fEl;

    private SynchronizedStorageElement(ICStorageElement el, Object lock) {
        this.fEl = el;
        this.fLock = lock;
    }

    private SynchronizedStorageElement(ICStorageElement el) {
        this.fEl = el;
        this.fLock = this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ICStorageElement getOriginalElement() {
        Object object = this.fLock;
        synchronized (object) {
            return this.fEl;
        }
    }

    public static SynchronizedStorageElement synchronizedElement(ICStorageElement el) {
        return new SynchronizedStorageElement(el);
    }

    public static SynchronizedStorageElement synchronizedElement(ICStorageElement el, Object lock) {
        return new SynchronizedStorageElement(el, lock);
    }

    public Object lock() {
        return this.fLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Object object = this.fLock;
        synchronized (object) {
            this.fEl.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ICStorageElement createChild(String name) {
        Object object = this.fLock;
        synchronized (object) {
            return new SynchronizedStorageElement(this.fEl.createChild(name), this.fLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ICStorageElement createCopy() throws UnsupportedOperationException, CoreException {
        Object object = this.fLock;
        synchronized (object) {
            return SynchronizedStorageElement.synchronizedElement(this.fEl.createCopy());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean equals(ICStorageElement other) {
        Object object = this.fLock;
        synchronized (object) {
            if (other instanceof SynchronizedStorageElement) {
                other = ((SynchronizedStorageElement)other).fEl;
            }
            return this.fEl.equals(other);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getAttribute(String name) {
        Object object = this.fLock;
        synchronized (object) {
            return this.fEl.getAttribute(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getAttributeNames() {
        Object object = this.fLock;
        synchronized (object) {
            return this.fEl.getAttributeNames();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ICStorageElement[] getChildren() {
        Object object = this.fLock;
        synchronized (object) {
            return this.createSynchronizedChildren(this.fEl.getChildren());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ICStorageElement[] getChildrenByName(String name) {
        Object object = this.fLock;
        synchronized (object) {
            return this.createSynchronizedChildren(this.fEl.getChildrenByName(name));
        }
    }

    private ICStorageElement[] createSynchronizedChildren(ICStorageElement[] children) {
        ICStorageElement[] synchChildren = new ICStorageElement[children.length];
        int i = 0;
        while (i < children.length) {
            synchChildren[i] = new SynchronizedStorageElement(children[i], this.fLock);
            ++i;
        }
        return synchChildren;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getName() {
        Object object = this.fLock;
        synchronized (object) {
            return this.fEl.getName();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ICStorageElement getParent() {
        Object object = this.fLock;
        synchronized (object) {
            if (this.fEl.getParent() == null || this.fEl.getParent() instanceof SynchronizedStorageElement) {
                return this.fEl.getParent();
            }
            return new SynchronizedStorageElement(this.fEl.getParent(), this.fLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getValue() {
        Object object = this.fLock;
        synchronized (object) {
            return this.fEl.getValue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasAttribute(String name) {
        Object object = this.fLock;
        synchronized (object) {
            return this.fEl.hasAttribute(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasChildren() {
        Object object = this.fLock;
        synchronized (object) {
            return this.fEl.hasChildren();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ICStorageElement importChild(ICStorageElement el) throws UnsupportedOperationException {
        Object object = this.fLock;
        synchronized (object) {
            return new SynchronizedStorageElement(el.importChild(el), this.fLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAttribute(String name) {
        Object object = this.fLock;
        synchronized (object) {
            this.fEl.removeAttribute(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeChild(ICStorageElement el) {
        Object object = this.fLock;
        synchronized (object) {
            if (el instanceof SynchronizedStorageElement) {
                el = ((SynchronizedStorageElement)el).fEl;
            }
            this.fEl.removeChild(el);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAttribute(String name, String value) {
        Object object = this.fLock;
        synchronized (object) {
            this.fEl.setAttribute(name, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setValue(String value) {
        Object object = this.fLock;
        synchronized (object) {
            this.fEl.setValue(value);
        }
    }
}

