/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.c;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTBinaryExpression;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTInitializerClause;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IArrayType;
import org.eclipse.cdt.core.dom.ast.IBasicType;
import org.eclipse.cdt.core.dom.ast.IPointerType;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.c.ICArrayType;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.cdt.internal.core.dom.parser.IASTAmbiguityParent;
import org.eclipse.cdt.internal.core.dom.parser.c.CArithmeticConversion;
import org.eclipse.cdt.internal.core.dom.parser.c.CBasicType;
import org.eclipse.cdt.internal.core.dom.parser.c.CVisitor;
import org.eclipse.cdt.internal.core.dom.parser.c.Conversions;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPSemantics;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.ExpressionTypes;

public class CASTBinaryExpression
extends ASTNode
implements IASTBinaryExpression,
IASTAmbiguityParent {
    private int op;
    private IASTExpression operand1;
    private IASTExpression operand2;

    public CASTBinaryExpression() {
    }

    public CASTBinaryExpression(int op, IASTExpression operand1, IASTExpression operand2) {
        this.op = op;
        this.setOperand1(operand1);
        this.setOperand2(operand2);
    }

    @Override
    public CASTBinaryExpression copy() {
        return this.copy(IASTNode.CopyStyle.withoutLocations);
    }

    @Override
    public CASTBinaryExpression copy(IASTNode.CopyStyle style) {
        CASTBinaryExpression copy = new CASTBinaryExpression();
        copy.op = this.op;
        copy.setOperand1(this.operand1 == null ? null : this.operand1.copy(style));
        copy.setOperand2(this.operand2 == null ? null : this.operand2.copy(style));
        return this.copy(copy, style);
    }

    @Override
    public int getOperator() {
        return this.op;
    }

    @Override
    public IASTExpression getOperand1() {
        return this.operand1;
    }

    @Override
    public IASTExpression getOperand2() {
        return this.operand2;
    }

    @Override
    public IASTInitializerClause getInitOperand2() {
        return this.operand2;
    }

    @Override
    public void setOperator(int op) {
        this.assertNotFrozen();
        this.op = op;
    }

    @Override
    public void setOperand1(IASTExpression expression) {
        this.assertNotFrozen();
        this.operand1 = expression;
        if (expression != null) {
            expression.setParent(this);
            expression.setPropertyInParent(OPERAND_ONE);
        }
    }

    @Override
    public void setOperand2(IASTExpression expression) {
        this.assertNotFrozen();
        this.operand2 = expression;
        if (expression != null) {
            expression.setParent(this);
            expression.setPropertyInParent(OPERAND_TWO);
        }
    }

    @Override
    public boolean accept(ASTVisitor action) {
        if (this.operand1 instanceof IASTBinaryExpression || this.operand2 instanceof IASTBinaryExpression) {
            return CASTBinaryExpression.acceptWithoutRecursion(this, action);
        }
        if (action.shouldVisitExpressions) {
            switch (action.visit(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        if (this.operand1 != null && !this.operand1.accept(action)) {
            return false;
        }
        if (this.operand2 != null && !this.operand2.accept(action)) {
            return false;
        }
        return !action.shouldVisitExpressions || action.leave(this) != 2;
    }

    /*
     * Unable to fully structure code
     */
    public static boolean acceptWithoutRecursion(IASTBinaryExpression bexpr, ASTVisitor action) {
        stack = new N(bexpr);
        block4: while (stack != null) {
            block10: {
                expr = stack.fExpression;
                if (stack.fState != 0) break block10;
                if (!action.shouldVisitExpressions) ** GOTO lbl-1000
                switch (action.visit(expr)) {
                    case 2: {
                        return false;
                    }
                    case 1: {
                        stack = stack.fNext;
                        continue block4;
                    }
                    default: lbl-1000:
                    // 2 sources

                    {
                        stack.fState = 1;
                        op1 = expr.getOperand1();
                        if (op1 instanceof IASTBinaryExpression) {
                            n = new N((IASTBinaryExpression)op1);
                            n.fNext = stack;
                            stack = n;
                            continue block4;
                        }
                        if (op1 == null || op1.accept(action)) break;
                        return false;
                    }
                }
            }
            if (stack.fState == 1) {
                stack.fState = 2;
                op2 = expr.getOperand2();
                if (op2 instanceof IASTBinaryExpression) {
                    n = new N((IASTBinaryExpression)op2);
                    n.fNext = stack;
                    stack = n;
                    continue;
                }
                if (op2 != null && !op2.accept(action)) {
                    return false;
                }
            }
            if (action.shouldVisitExpressions && action.leave(expr) == 2) {
                return false;
            }
            stack = stack.fNext;
        }
        return true;
    }

    @Override
    public void replace(IASTNode child, IASTNode other) {
        if (child == this.operand1) {
            other.setPropertyInParent(child.getPropertyInParent());
            other.setParent(child.getParent());
            this.operand1 = (IASTExpression)other;
        }
        if (child == this.operand2) {
            other.setPropertyInParent(child.getPropertyInParent());
            other.setParent(child.getParent());
            this.operand2 = (IASTExpression)other;
        }
    }

    @Override
    public IType getExpressionType() {
        CPPSemantics.pushLookupPoint(this);
        try {
            IType iType = this.getExpressionTypeImpl();
            return iType;
        }
        finally {
            CPPSemantics.popLookupPoint();
        }
    }

    private IType getExpressionTypeImpl() {
        IType type2;
        int op = this.getOperator();
        IType originalType1 = this.getOperand1().getExpressionType();
        IType originalType2 = this.getOperand2().getExpressionType();
        IType type1 = CVisitor.unwrapTypedefs(originalType1);
        IType type = CArithmeticConversion.convertCOperandTypes(op, type1, type2 = CVisitor.unwrapTypedefs(originalType2));
        if (type != null) {
            return ExpressionTypes.restoreTypedefs(type, originalType1, originalType2);
        }
        switch (op) {
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 15: 
            case 16: 
            case 28: 
            case 29: {
                return new CBasicType(IBasicType.Kind.eInt, 0, this);
            }
            case 35: {
                break;
            }
            case 4: {
                if (type1 instanceof IArrayType) {
                    return Conversions.arrayTypeToPointerType((ICArrayType)type1);
                }
                if (type2 instanceof IPointerType) {
                    return ExpressionTypes.restoreTypedefs(type2, originalType2);
                }
                if (!(type2 instanceof IArrayType)) break;
                return Conversions.arrayTypeToPointerType((ICArrayType)type2);
            }
            case 5: {
                if (!(type2 instanceof IPointerType) && !(type2 instanceof IArrayType)) break;
                if (type1 instanceof IPointerType || type1 instanceof IArrayType) {
                    return CVisitor.getPtrDiffType(this);
                }
                return ExpressionTypes.restoreTypedefs(type1, originalType1);
            }
        }
        return ExpressionTypes.restoreTypedefs(type1, originalType1);
    }

    @Override
    public boolean isLValue() {
        switch (this.getOperator()) {
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                return true;
            }
        }
        return false;
    }

    @Override
    public final IASTExpression.ValueCategory getValueCategory() {
        return this.isLValue() ? IASTExpression.ValueCategory.LVALUE : IASTExpression.ValueCategory.PRVALUE;
    }

    private static class N {
        final IASTBinaryExpression fExpression;
        int fState;
        N fNext;

        N(IASTBinaryExpression expr) {
            this.fExpression = expr;
        }
    }
}

