/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.lttng2.kernel.core.tests.perf.analysis.tid;

import java.io.File;
import java.util.List;
import java.util.Random;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.test.performance.Dimension;
import org.eclipse.test.performance.Performance;
import org.eclipse.test.performance.PerformanceMeter;
import org.eclipse.tracecompass.analysis.os.linux.core.tid.TidAnalysisModule;
import org.eclipse.tracecompass.lttng2.kernel.core.trace.LttngKernelTrace;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.testtraces.ctf.CtfTestTrace;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisModule;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfAnalysisException;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfTraceException;
import org.eclipse.tracecompass.tmf.core.tests.shared.TmfTestHelper;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.ctf.core.event.CtfTmfEvent;
import org.eclipse.tracecompass.tmf.ctf.core.tests.shared.CtfTmfTestTraceUtils;
import org.junit.Assert;
import org.junit.Test;

public class TidAnalysisUsageBenchmark {
    private static final String TEST_GET_RUNNING_THREAD = "TID: Threads On CPU";
    private static final int LOOP_COUNT = 25;
    private static final long SEED = 65423897234L;
    private static final int NUM_CPU_QUERIES = 20000;

    @Test
    public void testTrace2() {
        TidAnalysisUsageBenchmark.runTest(CtfTestTrace.TRACE2, "Trace2");
    }

    @Test
    public void testManyThreads() {
        TidAnalysisUsageBenchmark.runTest(CtfTestTrace.MANY_THREADS, "ManyThreads");
    }

    @Test
    public void testDjangoHttpd() {
        TidAnalysisUsageBenchmark.runTest(CtfTestTrace.DJANGO_HTTPD, "Django httpd");
    }

    private static TidAnalysisModule getModule(@NonNull CtfTestTrace testTrace, @NonNull LttngKernelTrace trace) {
        TidAnalysisModule module = null;
        String path = CtfTmfTestTraceUtils.getTrace((CtfTestTrace)testTrace).getPath();
        try {
            module = new TidAnalysisModule();
            module.setId("test");
            trace.initTrace(null, path, CtfTmfEvent.class);
            module.setTrace((ITmfTrace)trace);
            TmfTestHelper.executeAnalysis((IAnalysisModule)module);
        }
        catch (TmfAnalysisException | TmfTraceException e) {
            Assert.fail((String)e.getMessage());
        }
        return module;
    }

    private static void deleteSupplementaryFiles(ITmfTrace trace) {
        File suppDir = new File(TmfTraceManager.getSupplementaryFileDir((ITmfTrace)trace));
        File[] fileArray = suppDir.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            file.delete();
            ++n2;
        }
    }

    private static void runTest(@NonNull CtfTestTrace testTrace, String testName) {
        LttngKernelTrace trace = new LttngKernelTrace();
        TidAnalysisUsageBenchmark.deleteSupplementaryFiles((ITmfTrace)trace);
        TidAnalysisModule module = TidAnalysisUsageBenchmark.getModule(testTrace, trace);
        TidAnalysisUsageBenchmark.benchmarkGetThreadOnCpu(testName, module);
        TidAnalysisUsageBenchmark.deleteSupplementaryFiles((ITmfTrace)trace);
        module.dispose();
        trace.dispose();
        CtfTmfTestTraceUtils.dispose((CtfTestTrace)testTrace);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private static void benchmarkGetThreadOnCpu(String testName, TidAnalysisModule module) {
        Integer threadOnCpu;
        Performance perf = Performance.getDefault();
        PerformanceMeter pmRunningThread = perf.createPerformanceMeter("org.eclipse.linuxtools#LTTng kernel analysis#" + testName + ": TID: Threads On CPU");
        perf.tagAsSummary(pmRunningThread, "TID: Threads On CPU(" + testName + ")", Dimension.CPU_TIME);
        @Nullable ITmfStateSystem ss = module.getStateSystem();
        if (ss == null) {
            Assert.fail((String)"The state system is null");
            return;
        }
        int cpuCount = -1;
        @NonNull @NonNull List cpus = ss.getSubAttributes(-1, false);
        cpuCount = cpus.size();
        if (cpuCount < 1) {
            Assert.fail((String)"Impossible to get the number of CPUs");
        }
        long startTime = ss.getStartTime();
        long endTime = ss.getCurrentEndTime();
        long step = Math.floorDiv(endTime - startTime, 20000);
        if (step < 1L) {
            Assert.fail((String)"Trace is too short to run the get thread on CPU benchmark");
        }
        if ((threadOnCpu = module.getThreadOnCpuAtTime(0, endTime)) == null) {
            Assert.fail((String)"null thread on CPU at the end of the trace. Something is not right with the state system");
        }
        int i = 0;
        while (i < 25) {
            Random randomGenerator = new Random(65423897234L);
            pmRunningThread.start();
            long nextTime = startTime;
            while (nextTime < endTime) {
                int cpu = Math.abs(randomGenerator.nextInt()) % cpuCount;
                module.getThreadOnCpuAtTime(cpu, nextTime);
                nextTime += step;
            }
            pmRunningThread.stop();
            ++i;
        }
        pmRunningThread.commit();
    }
}

