/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp.semantics;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPParameter;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPEvaluation;

public class ActivationRecord {
    private final Map<IBinding, ICPPEvaluation> vars = new HashMap<IBinding, ICPPEvaluation>();
    private final ICPPParameter[] params;
    private final ICPPEvaluation[] args;
    private final ICPPEvaluation implicitThis;

    public ActivationRecord(ICPPParameter[] params, ICPPEvaluation implicitThis) {
        this.params = params;
        this.args = new ICPPEvaluation[params.length];
        this.implicitThis = implicitThis;
    }

    public ActivationRecord() {
        this(new ICPPParameter[0], null);
    }

    public void update(IBinding binding, ICPPEvaluation value) {
        int paramPos = this.getParameterPosition(binding);
        if (paramPos == -1) {
            this.vars.put(binding, value);
        } else {
            this.args[paramPos] = value;
        }
    }

    public ICPPEvaluation getVariable(IBinding binding) {
        int paramPos = this.getParameterPosition(binding);
        if (paramPos == -1) {
            return this.vars.get(binding);
        }
        return this.args[paramPos];
    }

    private int getParameterPosition(IBinding binding) {
        if (binding instanceof ICPPParameter) {
            int i = 0;
            while (i < this.params.length) {
                ICPPParameter param = this.params[i];
                if (param.getName().equals(binding.getName())) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    public ICPPEvaluation getImplicitThis() {
        return this.implicitThis;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Local variables: [\n");
        int i = 0;
        for (Map.Entry<IBinding, ICPPEvaluation> entry : this.vars.entrySet()) {
            builder.append("\t\t");
            builder.append(entry.getKey().toString());
            builder.append("=");
            builder.append(entry.getValue().toString());
            if (i < this.vars.entrySet().size() - 1) {
                builder.append(", ");
            }
            ++i;
            builder.append("\n");
        }
        builder.append("]\n");
        builder.append("Implicit this: ");
        if (this.implicitThis != null) {
            builder.append(this.implicitThis.toString());
        } else {
            builder.append("<null>");
        }
        builder.append("\n");
        return builder.toString();
    }
}

