/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.tests.segment;

import java.util.Comparator;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.segmentstore.core.BasicSegment;
import org.eclipse.tracecompass.segmentstore.core.ISegment;
import org.eclipse.tracecompass.tmf.core.segment.ISegmentAspect;
import org.eclipse.tracecompass.tmf.core.segment.SegmentDurationAspect;
import org.eclipse.tracecompass.tmf.core.segment.SegmentEndTimeAspect;
import org.eclipse.tracecompass.tmf.core.segment.SegmentStartTimeAspect;
import org.junit.Assert;
import org.junit.Test;

public class SegmentAspectTest {
    private static final ISegmentAspect START_ASPECT = SegmentStartTimeAspect.SEGMENT_START_TIME_ASPECT;
    private static final ISegmentAspect END_ASPECT = SegmentEndTimeAspect.SEGMENT_END_TIME_ASPECT;
    private static final ISegmentAspect DURATION_ASPECT = SegmentDurationAspect.SEGMENT_DURATION_ASPECT;
    private static final ISegmentAspect ASPECT_STUB = SegmentAspectStub.SEGMENT_ASPECT_STUB;

    @Test
    public void aspectTypeTest() {
        Assert.assertEquals((Object)ISegmentAspect.SegmentType.CATEGORICAL, (Object)ASPECT_STUB.getType());
        Assert.assertEquals((Object)ISegmentAspect.SegmentType.CONTINUOUS, (Object)START_ASPECT.getType());
        Assert.assertEquals((Object)ISegmentAspect.SegmentType.CONTINUOUS, (Object)END_ASPECT.getType());
        Assert.assertEquals((Object)ISegmentAspect.SegmentType.CONTINUOUS, (Object)DURATION_ASPECT.getType());
    }

    @Test
    public void aspectResolveTest() {
        long start = 1L;
        long end = 3L;
        BasicSegment segment = new BasicSegment(start, end);
        Assert.assertEquals((Object)0L, (Object)ASPECT_STUB.resolve((ISegment)segment));
        Assert.assertEquals((Object)start, (Object)START_ASPECT.resolve((ISegment)segment));
        Assert.assertEquals((Object)end, (Object)END_ASPECT.resolve((ISegment)segment));
        Assert.assertEquals((Object)(end - start), (Object)DURATION_ASPECT.resolve((ISegment)segment));
    }

    private static class SegmentAspectStub
    implements ISegmentAspect {
        public static final ISegmentAspect SEGMENT_ASPECT_STUB = new SegmentAspectStub();

        private SegmentAspectStub() {
        }

        public @NonNull String getName() {
            return "Stub Aspect";
        }

        public @NonNull String getHelpText() {
            return "Stub Aspect text";
        }

        public @Nullable Comparator<?> getComparator() {
            return null;
        }

        public @Nullable Long resolve(@NonNull ISegment segment) {
            return 0L;
        }
    }
}

