/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.profiling.core.tests.stubs2;

import org.eclipse.tracecompass.analysis.os.linux.core.model.ProcessStatus;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystemBuilder;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.statesystem.AbstractTmfStateProvider;
import org.eclipse.tracecompass.tmf.core.statesystem.ITmfStateProvider;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;

public class KernelStateProviderStub
extends AbstractTmfStateProvider {
    private static final String ENTRY = "entry";

    public KernelStateProviderStub(ITmfTrace trace) {
        super(trace, "org.eclipse.tracecompass.analysis.profiling.core.tests.kernelanalysis.stub");
    }

    public int getVersion() {
        return 0;
    }

    public ITmfStateProvider getNewInstance() {
        return new KernelStateProviderStub(this.getTrace());
    }

    protected void eventHandle(ITmfEvent event) {
        ITmfStateSystemBuilder ssb = this.getStateSystemBuilder();
        if (ssb == null) {
            return;
        }
        int threadQuark = ssb.getQuarkAbsoluteAndAdd(new String[]{"Threads", (String)event.getContent().getFieldValue(String.class, new String[]{"tid"})});
        boolean isEntry = event.getName().equals(ENTRY);
        long timestamp = event.getTimestamp().getValue();
        if (isEntry) {
            if (event.getName().equals("op4")) {
                int systemCallQuark = ssb.getQuarkRelativeAndAdd(threadQuark, new String[]{"System_call"});
                ssb.modifyAttribute(timestamp, (Object)"openat", systemCallQuark);
                ssb.modifyAttribute(timestamp, ProcessStatus.RUN_SYTEMCALL.getStateValue().unboxValue(), threadQuark);
            } else {
                ssb.modifyAttribute(timestamp, ProcessStatus.RUN.getStateValue().unboxValue(), threadQuark);
            }
        } else {
            ssb.modifyAttribute(timestamp, ProcessStatus.WAIT_CPU.getStateValue().unboxValue(), threadQuark);
        }
    }
}

