/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.lttng2.common.core.trace;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.regex.Pattern;
import org.eclipse.tracecompass.analysis.counters.core.aspects.CounterAspect;
import org.eclipse.tracecompass.analysis.counters.core.aspects.ITmfCounterAspect;
import org.eclipse.tracecompass.analysis.os.linux.core.event.aspect.LinuxTidAspect;
import org.eclipse.tracecompass.tmf.core.event.ITmfEventType;
import org.eclipse.tracecompass.tmf.core.event.aspect.TmfCpuAspect;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTraceWithPreDefinedEvents;

public interface ILttngTrace {
    public static final String CONTEXT_PERF_PREFIX = "context._perf.";
    public static final Pattern CONTEXT_PERF_UNKNOWN = Pattern.compile("^context\\._perf.+$");
    public static final Pattern CONTEXT_PERF_CPU = Pattern.compile("^context\\._perf.cpu.+$");
    public static final Pattern CONTEXT_PERF_THREAD = Pattern.compile("^context\\._perf.thread.+$");

    default public Collection<ITmfCounterAspect> createCounterAspects(ITmfTraceWithPreDefinedEvents trace) {
        ImmutableSet.Builder perfBuilder = new ImmutableSet.Builder();
        for (ITmfEventType eventType : trace.getContainedEventTypes()) {
            for (String fieldName : eventType.getFieldNames()) {
                if (fieldName == null) continue;
                if (CONTEXT_PERF_CPU.matcher(fieldName).matches()) {
                    perfBuilder.add((Object)new CounterAspect(fieldName, fieldName.substring(CONTEXT_PERF_PREFIX.length()), new Class[]{TmfCpuAspect.class}));
                    continue;
                }
                if (CONTEXT_PERF_THREAD.matcher(fieldName).matches()) {
                    perfBuilder.add((Object)new CounterAspect(fieldName, fieldName.substring(CONTEXT_PERF_PREFIX.length()), new Class[]{LinuxTidAspect.class}));
                    continue;
                }
                if (!CONTEXT_PERF_UNKNOWN.matcher(fieldName).matches()) continue;
                perfBuilder.add((Object)new CounterAspect(fieldName, fieldName.substring(CONTEXT_PERF_PREFIX.length()), new Class[0]));
            }
        }
        return perfBuilder.build();
    }
}

