/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xsd;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum XSDVariety implements Enumerator
{
    ATOMIC_LITERAL(0, "atomic", "atomic"),
    LIST_LITERAL(1, "list", "list"),
    UNION_LITERAL(2, "union", "union");

    public static final int ATOMIC = 0;
    public static final int LIST = 1;
    public static final int UNION = 2;
    private static final XSDVariety[] VALUES_ARRAY;
    public static final List<XSDVariety> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new XSDVariety[]{ATOMIC_LITERAL, LIST_LITERAL, UNION_LITERAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static XSDVariety get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            XSDVariety result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static XSDVariety getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            XSDVariety result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static XSDVariety get(int value) {
        switch (value) {
            case 0: {
                return ATOMIC_LITERAL;
            }
            case 1: {
                return LIST_LITERAL;
            }
            case 2: {
                return UNION_LITERAL;
            }
        }
        return null;
    }

    private XSDVariety(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

