/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.timing.core.segmentstore;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.StreamSupport;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.timing.core.segmentstore.IGroupingSegmentAspect;
import org.eclipse.tracecompass.analysis.timing.core.segmentstore.ISegmentStoreProvider;
import org.eclipse.tracecompass.internal.analysis.timing.core.segmentstore.Messages;
import org.eclipse.tracecompass.internal.tmf.core.model.TmfXyResponseFactory;
import org.eclipse.tracecompass.internal.tmf.core.model.filters.FetchParametersUtils;
import org.eclipse.tracecompass.segmentstore.core.ISegment;
import org.eclipse.tracecompass.segmentstore.core.ISegmentStore;
import org.eclipse.tracecompass.segmentstore.core.SegmentComparators;
import org.eclipse.tracecompass.segmentstore.core.segment.interfaces.INamedSegment;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisModule;
import org.eclipse.tracecompass.tmf.core.dataprovider.DataType;
import org.eclipse.tracecompass.tmf.core.model.AbstractTmfTraceDataProvider;
import org.eclipse.tracecompass.tmf.core.model.CommonStatusMessage;
import org.eclipse.tracecompass.tmf.core.model.ISampling;
import org.eclipse.tracecompass.tmf.core.model.YModel;
import org.eclipse.tracecompass.tmf.core.model.filters.SelectionTimeQueryFilter;
import org.eclipse.tracecompass.tmf.core.model.filters.TimeQueryFilter;
import org.eclipse.tracecompass.tmf.core.model.tree.ITmfTreeDataModel;
import org.eclipse.tracecompass.tmf.core.model.tree.ITmfTreeDataProvider;
import org.eclipse.tracecompass.tmf.core.model.tree.TmfTreeDataModel;
import org.eclipse.tracecompass.tmf.core.model.tree.TmfTreeModel;
import org.eclipse.tracecompass.tmf.core.model.xy.ISeriesModel;
import org.eclipse.tracecompass.tmf.core.model.xy.ITmfTreeXYDataProvider;
import org.eclipse.tracecompass.tmf.core.model.xy.ITmfXyModel;
import org.eclipse.tracecompass.tmf.core.model.xy.IYModel;
import org.eclipse.tracecompass.tmf.core.model.xy.TmfXYAxisDescription;
import org.eclipse.tracecompass.tmf.core.response.ITmfResponse;
import org.eclipse.tracecompass.tmf.core.response.TmfModelResponse;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;
import org.eclipse.tracecompass.tmf.core.util.Pair;

public class SegmentStoreDensityDataProvider
extends AbstractTmfTraceDataProvider
implements ITmfTreeXYDataProvider<TmfTreeDataModel> {
    public static final String ID = "org.eclipse.tracecompass.internal.analysis.timing.core.segmentstore.SegmentStoreDensityDataProvider";
    private static final AtomicLong TRACE_IDS = new AtomicLong();
    private static final String GROUP_PREFIX = "group";
    private final String fID;
    private final ISegmentStoreProvider fProvider;
    private final long fTotalId = TRACE_IDS.getAndIncrement();
    private final long fTraceId = TRACE_IDS.getAndIncrement();
    private Iterable<IGroupingSegmentAspect> fGroupingAspects;
    private final BiMap<Long, String> fIdToType = HashBiMap.create();

    public SegmentStoreDensityDataProvider(ITmfTrace trace, ISegmentStoreProvider provider, String id) {
        super(trace);
        this.fProvider = provider;
        this.fGroupingAspects = Iterables.filter(provider.getSegmentAspects(), IGroupingSegmentAspect.class);
        this.fID = "org.eclipse.tracecompass.internal.analysis.timing.core.segmentstore.SegmentStoreDensityDataProvider:" + id;
    }

    public TmfModelResponse<ITmfXyModel> fetchXY(Map<String, Object> fetchParameters, @Nullable IProgressMonitor monitor) {
        Pair<ISampling, Collection<IYModel>> pair;
        IAnalysisModule module;
        SelectionTimeQueryFilter filter = FetchParametersUtils.createSelectionTimeQueryWithSamples(fetchParameters);
        if (filter == null) {
            return TmfXyResponseFactory.createFailedResponse((String)CommonStatusMessage.INCORRECT_QUERY_PARAMETERS);
        }
        IAnalysisModule iAnalysisModule = module = this.fProvider instanceof IAnalysisModule ? (IAnalysisModule)this.fProvider : null;
        if (module != null) {
            if (monitor != null) {
                module.waitForCompletion(monitor);
            }
            if (monitor != null && monitor.isCanceled()) {
                return TmfXyResponseFactory.createCancelledResponse((String)CommonStatusMessage.TASK_CANCELLED);
            }
        }
        if ((pair = this.getXAxisAndYSeriesModels(fetchParameters, monitor)) == null) {
            return TmfXyResponseFactory.createCancelledResponse((String)CommonStatusMessage.TASK_CANCELLED);
        }
        boolean complete = module == null || module.isQueryable(filter.getEnd());
        return TmfXyResponseFactory.create((String)SegmentStoreDensityDataProvider.getTitle(), (ISampling)((ISampling)pair.getFirst()), (Collection)ImmutableList.copyOf((Collection)((Collection)pair.getSecond())), (ISeriesModel.DisplayType)SegmentStoreDensityDataProvider.getDisplayType(), (TmfXYAxisDescription)this.getXAxisDescription(), (boolean)complete);
    }

    public TmfModelResponse<TmfTreeModel<TmfTreeDataModel>> fetchTree(Map<String, Object> fetchParameters, @Nullable IProgressMonitor monitor) {
        ISegmentStore<ISegment> segStore;
        ISegmentStoreProvider provider = this.fProvider;
        boolean waitResult = true;
        if (provider instanceof IAnalysisModule) {
            IAnalysisModule module = (IAnalysisModule)provider;
            IProgressMonitor mon = monitor != null ? monitor : new NullProgressMonitor();
            waitResult = module.waitForCompletion(mon);
            if (mon.isCanceled()) {
                return new TmfModelResponse(null, ITmfResponse.Status.CANCELLED, CommonStatusMessage.TASK_CANCELLED);
            }
        }
        if ((segStore = provider.getSegmentStore()) == null) {
            if (!waitResult) {
                return new TmfModelResponse(null, ITmfResponse.Status.FAILED, CommonStatusMessage.ANALYSIS_INITIALIZATION_FAILED);
            }
            return new TmfModelResponse((Object)new TmfTreeModel(Collections.emptyList(), Collections.emptyList()), ITmfResponse.Status.COMPLETED, CommonStatusMessage.COMPLETED);
        }
        TimeQueryFilter filter = FetchParametersUtils.createTimeQuery(fetchParameters);
        if (filter == null) {
            return new TmfModelResponse(null, ITmfResponse.Status.FAILED, CommonStatusMessage.INCORRECT_QUERY_PARAMETERS);
        }
        long start = filter.getStart();
        long end = filter.getEnd();
        Iterable intersectingElements = Iterables.filter((Iterable)segStore.getIntersectingElements(start, end), s -> s.getStart() >= start);
        HashMap<String, INamedSegment> segmentTypes = new HashMap<String, INamedSegment>();
        IAnalysisModule module = provider instanceof IAnalysisModule ? (IAnalysisModule)provider : null;
        boolean complete = module == null || module.isQueryable(filter.getEnd());
        for (INamedSegment segment : Iterables.filter((Iterable)intersectingElements, INamedSegment.class)) {
            if (monitor != null && monitor.isCanceled()) {
                return new TmfModelResponse(null, ITmfResponse.Status.CANCELLED, CommonStatusMessage.TASK_CANCELLED);
            }
            segmentTypes.put(segment.getName(), segment);
        }
        ImmutableList.Builder nodes = new ImmutableList.Builder();
        nodes.add((Object)new TmfTreeDataModel(this.fTraceId, -1L, Collections.singletonList(String.valueOf(this.getTrace().getName()))));
        HashMap names = new HashMap();
        for (Map.Entry series : segmentTypes.entrySet()) {
            long parentId = this.fTraceId;
            for (IGroupingSegmentAspect aspect : this.fGroupingAspects) {
                names.putIfAbsent(aspect, new HashMap());
                Map map = (Map)names.get(aspect);
                if (map == null) break;
                String name = String.valueOf(aspect.resolve((ISegment)series.getValue()));
                String key = GROUP_PREFIX + name;
                Long uniqueId = (Long)map.get(key);
                if (uniqueId == null) {
                    uniqueId = this.getUniqueId(key);
                    map.put(key, uniqueId);
                    nodes.add((Object)new TmfTreeDataModel(uniqueId.longValue(), parentId, name));
                }
                parentId = uniqueId;
            }
            long seriesId = this.getUniqueId((String)series.getKey());
            nodes.add((Object)new TmfTreeDataModel(seriesId, parentId, (String)series.getKey()));
        }
        return new TmfModelResponse((Object)new TmfTreeModel(Collections.emptyList(), (List)nodes.build()), complete ? ITmfResponse.Status.COMPLETED : ITmfResponse.Status.RUNNING, complete ? CommonStatusMessage.COMPLETED : CommonStatusMessage.RUNNING);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getUniqueId(String name) {
        BiMap<Long, String> biMap = this.fIdToType;
        synchronized (biMap) {
            return (Long)this.fIdToType.inverse().computeIfAbsent((Object)name, n -> TRACE_IDS.getAndIncrement());
        }
    }

    public TmfXYAxisDescription getXAxisDescription() {
        return new TmfXYAxisDescription("Duration", "ns", DataType.DURATION);
    }

    private static String getTitle() {
        return Objects.requireNonNull(Messages.SegmentStoreDensityDataProvider_title);
    }

    private static ISeriesModel.DisplayType getDisplayType() {
        return ISeriesModel.DisplayType.BAR;
    }

    private @Nullable Pair<@NonNull ISampling, @NonNull Collection<@NonNull IYModel>> getXAxisAndYSeriesModels(@NonNull Map<@NonNull String, @NonNull Object> fetchParameters, @Nullable IProgressMonitor monitor) {
        SelectionTimeQueryFilter filter = FetchParametersUtils.createSelectionTimeQueryWithSamples(fetchParameters);
        if (filter == null) {
            return null;
        }
        ISegmentStore<ISegment> segStore = this.fProvider.getSegmentStore();
        if (segStore == null) {
            return null;
        }
        Iterable segments = segStore.getIntersectingElements(filter.getStart(), filter.getEnd());
        long maxLength = this.getMaxDuration();
        if (maxLength <= 0L) {
            maxLength = 1L;
        }
        int nbSamples = filter.getNumberOfSamples();
        long sampleStart = 0L;
        long sampleEnd = maxLength;
        Map<@NonNull Long, @NonNull Integer> selectedEntries = SegmentStoreDensityDataProvider.getSelectedEntries(filter);
        ISampling.Ranges sampling = SegmentStoreDensityDataProvider.createEvenlyDistributedRanges(sampleStart, sampleEnd, nbSamples);
        if (sampling == null) {
            return null;
        }
        HashMap<Long, double[]> entryToBins = new HashMap<Long, double[]>();
        for (Long entryId : selectedEntries.keySet()) {
            entryToBins.put(entryId, new double[nbSamples]);
        }
        long totalSpan = sampleEnd - sampleStart + 1L;
        long step = totalSpan / (long)nbSamples;
        for (ISegment segment : segments) {
            double[] bins;
            String segmentType;
            Long entryId;
            if (monitor != null && monitor.isCanceled()) {
                return null;
            }
            long duration = segment.getLength();
            if (step <= 0L || duration < sampleStart || duration > sampleEnd) continue;
            int index = (int)((duration - sampleStart) / step);
            if (index >= nbSamples) {
                index = nbSamples - 1;
            }
            if ((entryId = this.getEntryIdForSegmentType(segmentType = SegmentStoreDensityDataProvider.getSegmentType(segment))) == null || (bins = (double[])entryToBins.get(entryId)) == null) continue;
            int n = index;
            bins[n] = bins[n] + 1.0;
        }
        ArrayList<@NonNull YModel> yModels = new ArrayList<YModel>();
        TmfXYAxisDescription yAxisDescription = new TmfXYAxisDescription("Count", "", DataType.NUMBER);
        for (Map.Entry entry : entryToBins.entrySet()) {
            Long entryId = (Long)entry.getKey();
            double[] bins = (double[])entry.getValue();
            String name = this.getNameForEntryId(entryId);
            yModels.add(new YModel(entryId.longValue(), name, bins, yAxisDescription));
        }
        return new Pair((Object)sampling, yModels);
    }

    private static String getSegmentType(ISegment segment) {
        if (segment instanceof INamedSegment) {
            return ((INamedSegment)segment).getName();
        }
        return "Total";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private @Nullable Long getEntryIdForSegmentType(String segmentType) {
        BiMap<Long, String> biMap = this.fIdToType;
        synchronized (biMap) {
            return (Long)this.fIdToType.inverse().get((Object)segmentType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getNameForEntryId(Long entryId) {
        if (entryId.equals(this.fTotalId)) {
            return Objects.requireNonNull(Messages.SegmentStoreDensity_TotalLabel);
        }
        BiMap<Long, String> biMap = this.fIdToType;
        synchronized (biMap) {
            String name = (String)this.fIdToType.get((Object)entryId);
            return name != null ? name : "Unknown";
        }
    }

    private static Map<@NonNull Long, @NonNull Integer> getSelectedEntries(SelectionTimeQueryFilter filter) {
        HashMap<@NonNull Long, @NonNull Integer> selectedEntries = new HashMap<Long, Integer>();
        Collection selectedItems = filter.getSelectedItems();
        int index = 0;
        for (Long item : selectedItems) {
            selectedEntries.put(item, index++);
        }
        return selectedEntries;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private static // Could not load outer class - annotation placement on inner may be incorrect
    @Nullable ISampling.Ranges createEvenlyDistributedRanges(long start, long end, int samples) {
        if (samples <= 0 || start >= end) {
            return null;
        }
        ArrayList<// Could not load outer class - annotation placement on inner may be incorrect
        @NonNull @NonNull ISampling.Range> ranges = new ArrayList<ISampling.Range>(samples);
        long totalSpan = end - start;
        long step = totalSpan / (long)samples;
        long remainder = totalSpan % (long)samples;
        long current = start;
        int i = 0;
        while (i < samples) {
            long rangeStart = current;
            long rangeEnd = current + step - 1L;
            if (remainder > 0L) {
                ++rangeEnd;
                --remainder;
            }
            if (rangeEnd >= end || i == samples - 1) {
                rangeEnd = end;
            }
            ranges.add(new ISampling.Range((Comparable)Long.valueOf(rangeStart), (Comparable)Long.valueOf(rangeEnd)));
            current = rangeEnd + 1L;
            ++i;
        }
        return new ISampling.Ranges(ranges);
    }

    private long getMaxDuration() {
        ISegmentStore<ISegment> segStore = this.fProvider.getSegmentStore();
        if (segStore == null) {
            return -1L;
        }
        Optional<ISegment> maxSegment = StreamSupport.stream(segStore.spliterator(), false).max(SegmentComparators.INTERVAL_LENGTH_COMPARATOR);
        return maxSegment.map(ISegment::getLength).orElse(1L);
    }

    public String getId() {
        return this.fID;
    }

    public static @Nullable ITmfTreeDataProvider<? extends ITmfTreeDataModel> create(ITmfTrace trace, String secondaryId) {
        Iterable modules = TmfTraceUtils.getAnalysisModulesOfClass((ITmfTrace)trace, ISegmentStoreProvider.class);
        Iterable filteredModules = Iterables.filter((Iterable)modules, m -> ((IAnalysisModule)m).getId().equals(secondaryId));
        Iterator iterator = filteredModules.iterator();
        if (iterator.hasNext()) {
            ISegmentStoreProvider module = (ISegmentStoreProvider)iterator.next();
            if (iterator.hasNext()) {
                return null;
            }
            ((IAnalysisModule)module).schedule();
            return new SegmentStoreDensityDataProvider(trace, module, secondaryId);
        }
        return null;
    }
}

