/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.utils.envvar;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.settings.model.ICStorageElement;
import org.eclipse.cdt.internal.core.XmlProcessorFactoryCdt;
import org.eclipse.cdt.internal.core.settings.model.xml.XmlStorageElement;
import org.eclipse.cdt.utils.envvar.PrefsStorableEnvironment;
import org.eclipse.cdt.utils.envvar.StorableEnvironment;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public abstract class StorableEnvironmentLoader {
    public StorableEnvironment cloneEnvironmentWithContext(Object context, StorableEnvironment base, boolean isReadOnly) {
        PrefsStorableEnvironment env = new PrefsStorableEnvironment(base, this.getSerializeInfo(context), isReadOnly);
        return env;
    }

    protected abstract ISerializeInfo getSerializeInfo(Object var1);

    protected StorableEnvironment loadEnvironment(Object context, boolean readOnly) {
        ISerializeInfo serializeInfo = this.getSerializeInfo(context);
        if (serializeInfo == null) {
            return null;
        }
        return new PrefsStorableEnvironment(serializeInfo, readOnly);
    }

    protected void storeEnvironment(StorableEnvironment env, Object context, boolean force, boolean flush) throws CoreException {
        if (!env.isDirty() && !force) {
            return;
        }
        ISerializeInfo serializeInfo = this.getSerializeInfo(context);
        if (serializeInfo == null) {
            return;
        }
        if (env instanceof PrefsStorableEnvironment) {
            ((PrefsStorableEnvironment)env).serialize();
        } else {
            ByteArrayOutputStream stream = this.storeEnvironmentToStream(env);
            if (stream == null) {
                return;
            }
            this.storeOutputStream(stream, serializeInfo.getNode(), serializeInfo.getPrefName(), flush);
            env.setDirty(false);
        }
    }

    static ICStorageElement environmentStorageFromString(String env) {
        XmlStorageElement rootElement;
        block6: {
            if (env == null) {
                return null;
            }
            DocumentBuilder parser = XmlProcessorFactoryCdt.createDocumentBuilderWithErrorOnDOCTYPE();
            InputSource inputSource = new InputSource(new ByteArrayInputStream(env.getBytes()));
            Document document = parser.parse(inputSource);
            Element el = document.getDocumentElement();
            rootElement = new XmlStorageElement(el);
            if ("environment".equals(rootElement.getName())) break block6;
            return null;
        }
        try {
            return rootElement;
        }
        catch (ParserConfigurationException e) {
            CCorePlugin.log(e);
        }
        catch (SAXException e) {
            CCorePlugin.log(e);
        }
        catch (IOException e) {
            CCorePlugin.log(e);
        }
        return null;
    }

    private ByteArrayOutputStream storeEnvironmentToStream(StorableEnvironment env) throws CoreException {
        try {
            DocumentBuilder builder = XmlProcessorFactoryCdt.createDocumentBuilderWithErrorOnDOCTYPE();
            Document document = builder.newDocument();
            Element el = document.createElement("environment");
            document.appendChild(el);
            XmlStorageElement rootElement = new XmlStorageElement(el);
            env.serialize(rootElement);
            Transformer transformer = XmlProcessorFactoryCdt.createTransformerFactoryWithErrorOnDOCTYPE().newTransformer();
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("indent", "yes");
            DOMSource source = new DOMSource(document);
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            StreamResult result = new StreamResult(stream);
            transformer.transform(source, result);
            return stream;
        }
        catch (ParserConfigurationException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.cdt.core", -1, e.getMessage(), (Throwable)e));
        }
        catch (TransformerConfigurationException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.cdt.core", -1, e.getMessage(), (Throwable)e));
        }
        catch (TransformerException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.cdt.core", -1, e.getMessage(), (Throwable)e));
        }
    }

    static String loadPreferenceNode(ISerializeInfo serializeInfo) {
        if (serializeInfo == null) {
            return null;
        }
        return StorableEnvironmentLoader.loadPreferenceNode(serializeInfo.getNode(), serializeInfo.getPrefName());
    }

    static String loadPreferenceNode(Preferences node, String key) {
        if (node == null || key == null) {
            return null;
        }
        String value = node.get(key, null);
        if (value == null || value.length() == 0) {
            return null;
        }
        return value;
    }

    private void storeOutputStream(ByteArrayOutputStream stream, Preferences node, String key, boolean flush) throws CoreException {
        if (stream == null || node == null || key == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.cdt.core", -1, "StorableEnvironmentLoader.storeOutputStream.wrong.arguments", null));
        }
        byte[] bytes = stream.toByteArray();
        String val = null;
        try {
            val = new String(bytes, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            val = new String(bytes);
        }
        node.put(key, val);
        if (flush) {
            try {
                node.flush();
            }
            catch (BackingStoreException e) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.cdt.core", -1, e.getMessage(), (Throwable)e));
            }
        }
    }

    public static interface ISerializeInfo {
        public Preferences getNode();

        public String getPrefName();
    }
}

