/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.ftrace.core.binary.header;

public class BinaryFTraceHeaderEvent {
    private static final int CUSTOM_LENGTH_EVENT = 0;
    private final int fTypeLen;
    private final int fTimeDelta;
    private final int fDataMaxTypeLen;
    private final int fPaddingTypeLen;
    private final int fTimeExtendedTypeLen;
    private final int fTimeStampTypeLen;

    public BinaryFTraceHeaderEvent(BinaryFTraceHeaderEventBuilder builder) {
        this.fTypeLen = builder.fBuilderTypeLen;
        this.fTimeDelta = builder.fBuilderTimeDelta;
        this.fDataMaxTypeLen = builder.fBuilderDataMaxTypeLen;
        this.fPaddingTypeLen = builder.fBuilderPaddingTypeLen;
        this.fTimeExtendedTypeLen = builder.fBuilderTimeExtendedTypeLen;
        this.fTimeStampTypeLen = builder.fBuilderTimeStampTypeLen;
    }

    public int getTypeLen() {
        return this.fTypeLen;
    }

    public int getTimeDelta() {
        return this.fTimeDelta;
    }

    public int getDataMaxTypeLen() {
        return this.fDataMaxTypeLen;
    }

    public int getPaddingTypeLen() {
        return this.fPaddingTypeLen;
    }

    public int getTimeExtendedTypeLen() {
        return this.fTimeExtendedTypeLen;
    }

    public int getTimeStampTypeLen() {
        return this.fTimeStampTypeLen;
    }

    public int getCustomLengthEventTypeLen() {
        return 0;
    }

    public String toString() {
        StringBuilder strBuilder = new StringBuilder();
        strBuilder.append("Number of bits for event type: ").append(this.fTypeLen).append('\n');
        strBuilder.append("Number of bits for time delta: ").append(this.fTimeDelta).append('\n');
        strBuilder.append("Maximum value of data event type: ").append(this.fDataMaxTypeLen).append('\n');
        strBuilder.append("If the event is a padding event, then the type value will be: ").append(this.fPaddingTypeLen).append('\n');
        strBuilder.append("If the event is a time extended event, then the type value will be: ").append(this.fTimeExtendedTypeLen).append('\n');
        strBuilder.append("If the event is a time stamp event, then the type value will be: ").append(this.fTimeStampTypeLen).append('\n');
        return strBuilder.toString();
    }

    public static class BinaryFTraceHeaderEventBuilder {
        private int fBuilderTypeLen = -1;
        private int fBuilderTimeDelta = -1;
        private int fBuilderDataMaxTypeLen = -1;
        private int fBuilderPaddingTypeLen = -1;
        private int fBuilderTimeExtendedTypeLen = -1;
        private int fBuilderTimeStampTypeLen = -1;

        public BinaryFTraceHeaderEventBuilder typeLen(int builderTypeLen) {
            this.fBuilderTypeLen = builderTypeLen;
            return this;
        }

        public BinaryFTraceHeaderEventBuilder timeDelta(int builderTimeDelta) {
            this.fBuilderTimeDelta = builderTimeDelta;
            return this;
        }

        public BinaryFTraceHeaderEventBuilder dataMaxTypeLen(int builderDataMaxTypeLen) {
            this.fBuilderDataMaxTypeLen = builderDataMaxTypeLen;
            return this;
        }

        public BinaryFTraceHeaderEventBuilder paddingTypeLen(int builderPaddingTypeLen) {
            this.fBuilderPaddingTypeLen = builderPaddingTypeLen;
            return this;
        }

        public BinaryFTraceHeaderEventBuilder timeExtendedTypeLen(int builderTimeExtendedTypeLen) {
            this.fBuilderTimeExtendedTypeLen = builderTimeExtendedTypeLen;
            return this;
        }

        public BinaryFTraceHeaderEventBuilder timeStampTypeLen(int builderTimeStampTypeLen) {
            this.fBuilderTimeStampTypeLen = builderTimeStampTypeLen;
            return this;
        }

        public BinaryFTraceHeaderEvent build() {
            return new BinaryFTraceHeaderEvent(this);
        }
    }
}

