/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.timestamp;

import java.util.TimeZone;
import org.eclipse.tracecompass.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestamp;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestampFormat;

public class TmfTimestampDelta
extends TmfTimestamp {
    private final long fValue;
    private final int fScale;

    public TmfTimestampDelta() {
        this(0L, 0);
    }

    public TmfTimestampDelta(long value) {
        this(value, 0);
    }

    public TmfTimestampDelta(long value, int scale) {
        this.fValue = value;
        this.fScale = scale;
    }

    public TmfTimestampDelta(ITmfTimestamp timestamp) {
        this(timestamp.getValue(), timestamp.getScale());
    }

    @Override
    public long getValue() {
        return this.fValue;
    }

    @Override
    public int getScale() {
        return this.fScale;
    }

    @Override
    public ITmfTimestamp normalize(long offset, int scale) {
        ITmfTimestamp nts = super.normalize(offset, scale);
        return new TmfTimestampDelta(nts.getValue(), nts.getScale());
    }

    @Override
    public String toString() {
        return this.toString(TmfTimestampFormat.getDefaulIntervalFormat());
    }

    @Override
    public String toString(TmfTimestampFormat format) {
        if (this.getValue() < 0L && !this.equals(BIG_BANG)) {
            TmfTimestampDelta tmpTs = new TmfTimestampDelta(-this.getValue(), this.getScale());
            return "-" + tmpTs.toString(format);
        }
        TmfTimestampFormat deltaFormat = new TmfTimestampFormat(format.toPattern());
        deltaFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        return super.toString(deltaFormat);
    }
}

