/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.trace.server.jersey.rest.core.model;

import io.swagger.v3.oas.annotations.media.Schema;
import org.eclipse.tracecompass.incubator.internal.trace.server.jersey.rest.core.model.Configuration;
import org.eclipse.tracecompass.incubator.internal.trace.server.jersey.rest.core.model.OutputCapabilities;

public interface DataProvider {
    @Schema(description="The human readable name", requiredMode=Schema.RequiredMode.REQUIRED)
    public String getName();

    @Schema(description="The output provider's ID", requiredMode=Schema.RequiredMode.REQUIRED)
    public String getId();

    @Schema(description="Type of data returned by this output. Serves as a hint to determine what kind of view should be used for this output (ex. XY, Time Graph, Table, Gantt chart, etc..). Providers of type TREE_TIME_XY and TIME_GRAPH can be grouped under the same time axis. Providers of type DATA_TREE only provide a tree with columns and don't have any XY nor time graph data associated with it. Providers of type GANTT_CHART use the same endpoint as TIME_GRAPH, but have a different x-axis (duration, page faults, etc.), with their own separate ranges. Providers of type TREE_GENERIC_XY supports XY view with non-time x-axis. Providers of type NONE have no data to visualize. Can be used for grouping purposes and/or as data provider configurator.", requiredMode=Schema.RequiredMode.REQUIRED)
    public ProviderType getType();

    @Schema(description="Describes the output provider's features", requiredMode=Schema.RequiredMode.REQUIRED)
    public String getDescription();

    @Schema(description="Optional parent Id for grouping purposes for example of derived data providers.")
    public String getParentId();

    @Schema(description="Optional input configuration used to create this derived data provider.")
    public Configuration getConfiguration();

    @Schema(description="Optional output capabilities, such as 'canCreate' and 'canDelete'. If absent, all capabilities are 'false'.")
    public OutputCapabilities getCapabilities();

    public static enum ProviderType {
        TABLE,
        TREE_TIME_XY,
        TIME_GRAPH,
        DATA_TREE,
        NONE,
        GANTT_CHART,
        TREE_GENERIC_XY;

    }
}

