/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.util;

import org.eclipse.cdt.core.parser.IParserLogService;
import org.eclipse.cdt.core.parser.IProblem;

public class TraceUtil {
    public static void outputTrace(IParserLogService log, String preface, IProblem problem, String first, String second, String third) {
        if (log.isTracing()) {
            StringBuilder buffer = new StringBuilder();
            if (preface != null) {
                buffer.append(preface);
            }
            if (problem != null) {
                buffer.append(problem.getMessageWithLocation());
            }
            if (first != null) {
                buffer.append(first);
            }
            if (second != null) {
                buffer.append(second);
            }
            if (third != null) {
                buffer.append(third);
            }
            log.traceLog(buffer.toString());
        }
    }

    public static void outputTrace(IParserLogService log, String preface, IProblem problem) {
        if (log.isTracing()) {
            StringBuilder buffer = new StringBuilder();
            if (preface != null) {
                buffer.append(preface);
            }
            if (problem != null) {
                buffer.append(problem.getMessageWithLocation());
            }
            log.traceLog(buffer.toString());
        }
    }

    public static void outputTrace(IParserLogService log, String preface, IProblem problem, char[] first, String second, String third) {
        if (log.isTracing()) {
            StringBuilder buffer = new StringBuilder();
            if (preface != null) {
                buffer.append(preface);
            }
            if (problem != null) {
                buffer.append(problem.getMessageWithLocation());
            }
            if (first != null) {
                buffer.append(first);
            }
            if (second != null) {
                buffer.append(second);
            }
            if (third != null) {
                buffer.append(third);
            }
            log.traceLog(buffer.toString());
        }
    }

    public static void outputTrace(IParserLogService log, String preface, IProblem problem, int first, String second, int third) {
        if (log.isTracing()) {
            TraceUtil.outputTrace(log, preface, problem, Integer.toString(first), second, Integer.toString(third));
        }
    }

    public static void outputTrace(IParserLogService log, String preface, String first, String second, String third) {
        TraceUtil.outputTrace(log, preface, null, first, second, third);
    }

    public static void outputTrace(IParserLogService log, String preface) {
        if (log.isTracing() && preface != null) {
            log.traceLog(preface);
        }
    }

    public static void outputTrace(IParserLogService logService, String preface, String data) {
        if (logService.isTracing()) {
            StringBuilder buffer = new StringBuilder();
            if (preface != null) {
                buffer.append(preface);
            }
            if (data != null) {
                buffer.append(data);
            }
            logService.traceLog(buffer.toString());
        }
    }
}

