/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.eval;

import java.util.HashMap;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.compiler.CategorizedProblem;
import org.eclipse.jdt.core.eval.ICodeSnippetRequestor;
import org.eclipse.jdt.internal.compiler.ClassFile;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.eval.IRequestor;

public class RequestorWrapper
implements IRequestor {
    ICodeSnippetRequestor requestor;

    public RequestorWrapper(ICodeSnippetRequestor requestor) {
        this.requestor = requestor;
    }

    @Override
    public boolean acceptClassFiles(ClassFile[] classFiles, char[] codeSnippetClassName) {
        int length = classFiles.length;
        byte[][] classFileBytes = new byte[length][];
        String[][] compoundNames = new String[length][];
        int i = 0;
        while (i < length) {
            ClassFile classFile = classFiles[i];
            classFileBytes[i] = classFile.getBytes();
            char[][] classFileCompundName = classFile.getCompoundName();
            int length2 = classFileCompundName.length;
            String[] compoundName = new String[length2];
            int j = 0;
            while (j < length2) {
                compoundName[j] = new String(classFileCompundName[j]);
                ++j;
            }
            compoundNames[i] = compoundName;
            ++i;
        }
        return this.requestor.acceptClassFiles(classFileBytes, compoundNames, codeSnippetClassName == null ? null : new String(codeSnippetClassName));
    }

    @Override
    public void acceptProblem(CategorizedProblem problem, char[] fragmentSource, int fragmentKind) {
        block2: {
            try {
                HashMap<String, Object> attributes = new HashMap<String, Object>();
                attributes.put("id", problem.getID());
                attributes.put("charStart", problem.getSourceStart());
                attributes.put("charEnd", problem.getSourceEnd() + 1);
                attributes.put("lineNumber", problem.getSourceLineNumber());
                attributes.put("message", problem.getMessage());
                attributes.put("severity", problem.isError() ? 2 : (problem.isWarning() ? 1 : 0));
                attributes.put("sourceId", "JDT");
                IMarker marker = ResourcesPlugin.getWorkspace().getRoot().createMarker("org.eclipse.jdt.core.transient_problem", attributes);
                this.requestor.acceptProblem(marker, new String(fragmentSource), fragmentKind);
            }
            catch (CoreException e) {
                if (!JavaModelManager.VERBOSE) break block2;
                JavaModelManager.trace("", (Exception)((Object)e));
            }
        }
    }
}

