/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.ui.internal.quickoutline;

import java.util.ArrayList;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.wst.xml.core.internal.contentmodel.CMAttributeDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMElementDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNamedNodeMap;
import org.eclipse.wst.xml.core.internal.contentmodel.modelquery.ModelQuery;
import org.eclipse.wst.xml.core.internal.modelquery.ModelQueryUtil;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.ui.internal.contentoutline.JFaceNodeLabelProvider;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class XMLContentLabelProvider
extends JFaceNodeLabelProvider
implements DelegatingStyledCellLabelProvider.IStyledLabelProvider {
    static final String ATTR_NAME = "name";
    static final String ATTR_ID = "id";
    private boolean fShowAttributes;
    static final int MAX_ELEMENTTEXT_LENGTH = 72;

    @Override
    public boolean isLabelProperty(Object element, String property) {
        return true;
    }

    protected String firstLine(String s, boolean handleEllipses) {
        String truncated = s;
        int n = 0;
        boolean needsEllipses = false;
        n = truncated.indexOf(13);
        if (n >= 0) {
            truncated = truncated.substring(0, n);
            needsEllipses = true;
        }
        if ((n = truncated.indexOf(10)) >= 0) {
            truncated = truncated.substring(0, n);
            needsEllipses = true;
        }
        if (truncated.length() > 72) {
            truncated = truncated.substring(0, 69).concat("...");
        } else if (handleEllipses && needsEllipses) {
            return truncated.concat("...");
        }
        return truncated;
    }

    public Node getAttributeToShow(Element element) {
        NamedNodeMap attributes = element.getAttributes();
        Node idTypedAttribute = null;
        Node requiredAttribute = null;
        boolean hasId = false;
        boolean hasName = false;
        Node shownAttribute = null;
        CMElementDeclaration elementDecl = null;
        ModelQuery mq = ModelQueryUtil.getModelQuery((Document)element.getOwnerDocument());
        if (mq != null) {
            elementDecl = mq.getCMElementDeclaration(element);
        }
        if (elementDecl != null) {
            CMNamedNodeMap attributeDeclarationMap = elementDecl.getAttributes();
            int i = 0;
            while (i < attributes.getLength() && idTypedAttribute == null) {
                Node attr = attributes.item(i);
                String attrName = attr.getNodeName();
                CMAttributeDeclaration attrDecl = (CMAttributeDeclaration)attributeDeclarationMap.getNamedItem(attrName);
                if (attrDecl != null) {
                    if (attrDecl.getAttrType() != null && "ID".equals(attrDecl.getAttrType().getDataTypeName())) {
                        idTypedAttribute = attr;
                    } else if (attrDecl.getUsage() == 2 && requiredAttribute == null) {
                        requiredAttribute = attr;
                    } else {
                        hasId = hasId || attrName.equals(ATTR_ID);
                        hasName = hasName || attrName.equals(ATTR_NAME);
                    }
                }
                ++i;
            }
        }
        if (idTypedAttribute != null) {
            shownAttribute = idTypedAttribute;
        } else if (hasId) {
            shownAttribute = attributes.getNamedItem(ATTR_ID);
        } else if (hasName) {
            shownAttribute = attributes.getNamedItem(ATTR_NAME);
        } else if (requiredAttribute != null) {
            shownAttribute = requiredAttribute;
        }
        if (shownAttribute == null) {
            shownAttribute = attributes.item(0);
        }
        return shownAttribute;
    }

    public Node[] getAttributesToShow(Element element) {
        NamedNodeMap attributes = element.getAttributes();
        Node idTypedAttribute = null;
        Node requiredAttribute = null;
        boolean hasId = false;
        boolean hasName = false;
        ArrayList<Node> shownAttributes = new ArrayList<Node>();
        CMElementDeclaration elementDecl = null;
        ModelQuery mq = ModelQueryUtil.getModelQuery((Document)element.getOwnerDocument());
        if (mq != null) {
            elementDecl = mq.getCMElementDeclaration(element);
        }
        if (elementDecl != null) {
            CMNamedNodeMap attributeDeclarationMap = elementDecl.getAttributes();
            int i = 0;
            while (i < attributes.getLength()) {
                Node attr = attributes.item(i);
                String attrName = attr.getNodeName();
                CMAttributeDeclaration attrDecl = (CMAttributeDeclaration)attributeDeclarationMap.getNamedItem(attrName);
                if (attrDecl != null) {
                    if (attrDecl.getAttrType() != null && "ID".equals(attrDecl.getAttrType().getDataTypeName())) {
                        idTypedAttribute = attr;
                    } else if (attrDecl.getUsage() == 2 && requiredAttribute == null) {
                        requiredAttribute = attr;
                    } else {
                        hasId = hasId || attrName.equals(ATTR_ID);
                        hasName = hasName || attrName.equals(ATTR_NAME);
                    }
                }
                ++i;
            }
        }
        Node item = null;
        if (idTypedAttribute != null) {
            shownAttributes.add(idTypedAttribute);
        }
        if (hasId && (item = attributes.getNamedItem(ATTR_ID)) != null && !shownAttributes.contains(item)) {
            shownAttributes.add(item);
        }
        if (hasName && (item = attributes.getNamedItem(ATTR_NAME)) != null && !shownAttributes.contains(item)) {
            shownAttributes.add(item);
        }
        if (requiredAttribute != null && !shownAttributes.contains(requiredAttribute)) {
            shownAttributes.add(requiredAttribute);
        }
        if (shownAttributes.isEmpty()) {
            shownAttributes.add(attributes.item(0));
        }
        return shownAttributes.toArray(new Node[shownAttributes.size()]);
    }

    @Override
    public String getText(Object o) {
        if (this.fShowAttributes && o instanceof Node) {
            Node node = (Node)o;
            StringBuilder builder = new StringBuilder();
            if (node.getNodeType() == 1) {
                Node possibleText;
                builder.append(super.getText(node));
                if (node.hasAttributes()) {
                    Node[] shownAttributes = this.getAttributesToShow((Element)node);
                    int i = 0;
                    while (i < shownAttributes.length) {
                        String attributeValue;
                        String attributeName = shownAttributes[i].getNodeName();
                        if (attributeName != null && attributeName.length() > 0 && (attributeValue = shownAttributes[i].getNodeValue()) != null) {
                            builder.append(' ');
                            builder.append(attributeName);
                            builder.append('=');
                            builder.append(attributeValue);
                        }
                        ++i;
                    }
                } else if (node instanceof IDOMElement && (possibleText = node.getFirstChild()) != null && possibleText.getNextSibling() == null && possibleText.getNodeType() == 3) {
                    builder.append(" : ");
                    builder.append(this.firstLine(possibleText.getNodeValue().trim(), true));
                }
            } else if (node.getNodeType() == 8) {
                builder.append(this.firstLine(node.getNodeValue().trim(), true));
            } else {
                builder.append(super.getText(node));
            }
            return builder.toString();
        }
        return super.getText(o);
    }

    String getIdMatchValue(Object o) {
        if (o instanceof Node) {
            Node node = (Node)o;
            if (node.getNodeType() == 1) {
                Node possibleText;
                if (node.hasAttributes()) {
                    StringBuilder builder = new StringBuilder();
                    Node[] shownAttributes = this.getAttributesToShow((Element)node);
                    int i = 0;
                    while (i < shownAttributes.length) {
                        String attributeValue;
                        String attributeName = shownAttributes[i].getNodeName();
                        if (attributeName != null && attributeName.length() > 0 && (attributeValue = shownAttributes[i].getNodeValue()) != null) {
                            if (builder.length() > 0) {
                                builder.append("\n");
                            }
                            builder.append(attributeValue);
                        }
                        ++i;
                    }
                    if (builder.length() > 0) {
                        return builder.toString();
                    }
                } else if (node instanceof IDOMElement && (possibleText = node.getFirstChild()) != null && possibleText.getNextSibling() == null && possibleText.getNodeType() == 3) {
                    return this.firstLine(possibleText.getNodeValue().trim(), false);
                }
            } else if (node.getNodeType() == 8) {
                return this.firstLine(node.getNodeValue().trim(), false);
            }
        }
        return "";
    }

    public String getToolTipText(Object element) {
        if (element instanceof Node) {
            switch (((Node)element).getNodeType()) {
                case 3: 
                case 4: 
                case 7: 
                case 8: {
                    String nodeValue = ((Node)element).getNodeValue().trim();
                    return this.prepareText(nodeValue);
                }
                case 1: {
                    Node previous = ((Node)element).getPreviousSibling();
                    if (previous != null && previous.getNodeType() == 3) {
                        previous = previous.getPreviousSibling();
                    }
                    if (previous == null || previous.getNodeType() != 8) break;
                    return this.getToolTipText(previous);
                }
            }
        }
        return super.getToolTipText(element);
    }

    private String prepareText(String text) {
        StringBuilder nodeText = new StringBuilder();
        int i = 0;
        while (i < text.length()) {
            char c = text.charAt(i);
            if (c != '\r' && c != '\n') {
                nodeText.append(c);
            } else if (c == '\r' || c == '\n') {
                nodeText.append('\n');
                while (Character.isWhitespace(c) && i < text.length()) {
                    c = text.charAt(++i);
                }
                nodeText.append(c);
            }
            ++i;
        }
        return nodeText.toString();
    }

    public StyledString getStyledText(Object element) {
        if (element instanceof Node) {
            Node node = (Node)element;
            StyledString styleString = new StyledString();
            if (this.fShowAttributes && node.getNodeType() == 1) {
                styleString.append(super.getText(node));
                if (node.hasAttributes()) {
                    Node[] shownAttributes = this.getAttributesToShow((Element)node);
                    int i = 0;
                    while (i < shownAttributes.length) {
                        String attributeValue;
                        String attributeName = shownAttributes[i].getNodeName();
                        if (attributeName != null && attributeName.length() > 0 && (attributeValue = shownAttributes[i].getNodeValue()) != null) {
                            styleString.append(" ");
                            styleString.append(attributeName, StyledString.DECORATIONS_STYLER);
                            styleString.append("=", StyledString.DECORATIONS_STYLER);
                            styleString.append(attributeValue, StyledString.DECORATIONS_STYLER);
                        }
                        ++i;
                    }
                } else {
                    Node possibleText = node.getFirstChild();
                    if (possibleText != null && possibleText.getNextSibling() == null && possibleText.getNodeType() == 3) {
                        styleString.append(" : ");
                        styleString.append(this.firstLine(possibleText.getNodeValue().trim(), true), StyledString.DECORATIONS_STYLER);
                    }
                }
            } else if (this.fShowAttributes && node.getNodeType() == 8) {
                styleString.append(this.firstLine(node.getNodeValue().trim(), true), StyledString.DECORATIONS_STYLER);
            } else {
                styleString.append(super.getText(node));
            }
            return styleString;
        }
        return new StyledString(this.getText(element));
    }

    public void showAttributes(boolean doShow) {
        this.fShowAttributes = doShow;
    }
}

