/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.ui.IContainmentAdapter;
import org.eclipse.ui.IWorkingSet;

public class ResourceWorkingSetFilter
extends ViewerFilter {
    private IWorkingSet workingSet = null;
    private IAdaptable[] cachedWorkingSet = null;

    public IWorkingSet getWorkingSet() {
        return this.workingSet;
    }

    public void setWorkingSet(IWorkingSet workingSet) {
        this.workingSet = workingSet;
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        if (this.workingSet == null || this.workingSet.isAggregateWorkingSet() && this.workingSet.isEmpty()) {
            return true;
        }
        IResource resource = (IResource)Adapters.adapt((Object)element, IResource.class);
        if (resource != null) {
            return this.isEnclosed(resource);
        }
        return true;
    }

    private boolean isEnclosed(IResource element) {
        IPath elementPath = element.getFullPath();
        IAdaptable[] workingSetElements = this.cachedWorkingSet;
        if (workingSetElements == null) {
            workingSetElements = this.workingSet.getElements();
        }
        IAdaptable[] iAdaptableArray = workingSetElements;
        int n = workingSetElements.length;
        int n2 = 0;
        while (n2 < n) {
            IAdaptable workingSetElement = iAdaptableArray[n2];
            IContainmentAdapter containmentAdapter = (IContainmentAdapter)workingSetElement.getAdapter(IContainmentAdapter.class);
            if (containmentAdapter != null ? containmentAdapter.contains((Object)workingSetElement, (Object)element, 15) : this.isEnclosedResource(element, elementPath, workingSetElement)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean isEnclosedResource(IResource element, IPath elementPath, IAdaptable workingSetElement) {
        if (workingSetElement.equals(element)) {
            return true;
        }
        IResource workingSetResource = (IResource)Adapters.adapt((Object)workingSetElement, IResource.class);
        if (workingSetResource != null) {
            IPath resourcePath = workingSetResource.getFullPath();
            if (resourcePath.isPrefixOf(elementPath)) {
                return true;
            }
            if (elementPath.isPrefixOf(resourcePath)) {
                return true;
            }
        }
        return false;
    }

    public Object[] filter(Viewer viewer, Object parent, Object[] elements) {
        Object[] result = null;
        if (this.workingSet != null) {
            this.cachedWorkingSet = this.workingSet.getElements();
        }
        try {
            result = super.filter(viewer, parent, elements);
        }
        finally {
            this.cachedWorkingSet = null;
        }
        return result;
    }
}

