/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.ftrace.core.binary.parser;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;

public final class BinaryFTraceFileMapping {
    public static final long SEGMENT_LEN = 0x80000000L;
    public static final long SEGMENT_OVERLAP = 0x100000L;
    private final long fLength;
    private ArrayList<MappedByteBuffer> fMappedBuffers = new ArrayList();

    public BinaryFTraceFileMapping(String filePath) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (RandomAccessFile file = new RandomAccessFile(filePath, "r");){
            FileChannel channel = file.getChannel();
            this.fLength = file.length();
            int segmentCount = (int)(this.fLength / 0x80000000L);
            this.fMappedBuffers.ensureCapacity(segmentCount + 1);
            int i = 0;
            while (i < segmentCount) {
                this.fMappedBuffers.add(channel.map(FileChannel.MapMode.READ_ONLY, (long)i * 0x80000000L, 0x80100000L));
                ++i;
            }
            long remaining = this.fLength - (long)segmentCount * 0x80000000L;
            if (remaining > 0L) {
                this.fMappedBuffers.add(channel.map(FileChannel.MapMode.READ_ONLY, (long)segmentCount * 0x80000000L, remaining));
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void order(ByteOrder endianess) {
        for (MappedByteBuffer buffer : this.fMappedBuffers) {
            buffer.order(endianess);
        }
    }

    public void get(long index, byte[] dst) {
        MappedByteBuffer mappedBuffer = this.fMappedBuffers.get((int)(index / 0x80000000L));
        mappedBuffer.get((int)(index % 0x80000000L), dst);
    }

    public byte getByte(long index) {
        MappedByteBuffer mappedBuffer = this.fMappedBuffers.get((int)(index / 0x80000000L));
        return mappedBuffer.get((int)(index % 0x80000000L));
    }

    public int getInt(long index) {
        MappedByteBuffer mappedBuffer = this.fMappedBuffers.get((int)(index / 0x80000000L));
        return mappedBuffer.getInt((int)(index % 0x80000000L));
    }

    public double getDouble(long index) {
        MappedByteBuffer mappedBuffer = this.fMappedBuffers.get((int)(index / 0x80000000L));
        return mappedBuffer.getDouble((int)(index % 0x80000000L));
    }

    public long getLong(long index) {
        MappedByteBuffer mappedBuffer = this.fMappedBuffers.get((int)(index / 0x80000000L));
        return mappedBuffer.getLong((int)(index % 0x80000000L));
    }

    public short getShort(long index) {
        MappedByteBuffer mappedBuffer = this.fMappedBuffers.get((int)(index / 0x80000000L));
        return mappedBuffer.getShort((int)(index % 0x80000000L));
    }

    public long length() {
        return this.fLength;
    }
}

