/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.ui.mapping;

import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.mapping.ModelProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.team.core.mapping.ISynchronizationContext;
import org.eclipse.team.core.mapping.ISynchronizationScope;
import org.eclipse.team.internal.ui.TeamUIMessages;
import org.eclipse.team.ui.mapping.SynchronizationContentProvider;
import org.eclipse.team.ui.synchronize.AbstractSynchronizeLabelProvider;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.navigator.ICommonContentExtensionSite;
import org.eclipse.ui.navigator.ICommonLabelProvider;
import org.eclipse.ui.navigator.IDescriptionProvider;

public abstract class SynchronizationLabelProvider
extends AbstractSynchronizeLabelProvider
implements ICommonLabelProvider,
IFontProvider {
    private ISynchronizationScope scope;
    private ISynchronizationContext context;
    private ITreeContentProvider contentProvider;
    private ICommonContentExtensionSite site;

    private void init(ISynchronizationScope input, ISynchronizationContext context) {
        this.scope = input;
        this.context = context;
    }

    public void init(ICommonContentExtensionSite site) {
        this.site = site;
        this.contentProvider = site.getExtension().getContentProvider();
        this.init((ISynchronizationScope)site.getExtensionStateModel().getProperty("org.eclipse.team.ui.synchronizationScope"), (ISynchronizationContext)site.getExtensionStateModel().getProperty("org.eclipse.team.ui.synchronizationContext"));
    }

    public ISynchronizationContext getContext() {
        return this.context;
    }

    public ISynchronizationScope getScope() {
        return this.scope;
    }

    public void restoreState(IMemento aMemento) {
        ILabelProvider provider = this.getDelegateLabelProvider();
        if (provider instanceof ICommonLabelProvider) {
            ((ICommonLabelProvider)provider).restoreState(aMemento);
        }
    }

    public void saveState(IMemento aMemento) {
        ILabelProvider provider = this.getDelegateLabelProvider();
        if (provider instanceof ICommonLabelProvider) {
            ((ICommonLabelProvider)provider).saveState(aMemento);
        }
    }

    public String getDescription(Object anElement) {
        ILabelProvider provider = this.getDelegateLabelProvider();
        if (provider instanceof IDescriptionProvider) {
            return ((IDescriptionProvider)provider).getDescription(this.internalGetElement(anElement));
        }
        return null;
    }

    @Override
    protected boolean isDecorationEnabled() {
        return this.getContext() != null;
    }

    @Override
    public Image getImage(Object element) {
        Image image = super.getImage(element);
        if (image == null && this.internalGetElement(element) instanceof ModelProvider) {
            image = super.getImage(this.getModelRoot());
        }
        return image;
    }

    protected Object getModelRoot() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    @Override
    public String getText(Object element) {
        String text = super.getText(element);
        if (this.contentProvider instanceof SynchronizationContentProvider) {
            SynchronizationContentProvider scp = (SynchronizationContentProvider)this.contentProvider;
            ISynchronizationContext context = this.getContext();
            if (context != null && !scp.isInitialized(context)) {
                return NLS.bind((String)TeamUIMessages.SynchronizationLabelProvider_0, (Object)text);
            }
        }
        return text;
    }

    public ICommonContentExtensionSite getExtensionSite() {
        return this.site;
    }

    private Object internalGetElement(Object element) {
        if (element instanceof TreePath) {
            TreePath tp = (TreePath)element;
            element = tp.getLastSegment();
        }
        return element;
    }
}

