/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.analysis;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.swt.widgets.Display;
import org.eclipse.tracecompass.internal.tmf.ui.Activator;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisOutput;
import org.eclipse.tracecompass.tmf.ui.project.model.Messages;
import org.eclipse.tracecompass.tmf.ui.project.model.TraceUtils;
import org.eclipse.tracecompass.tmf.ui.views.TmfView;
import org.eclipse.tracecompass.tmf.ui.views.TmfViewFactory;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.WorkbenchPart;
import org.eclipse.ui.views.IViewDescriptor;

public class TmfAnalysisViewOutput
implements IAnalysisOutput,
IExecutableExtension {
    private String fViewId;
    private final @Nullable String fSecondaryId;
    private final Map<String, String> fProperties = new HashMap<String, String>();

    public TmfAnalysisViewOutput() {
        this.fSecondaryId = null;
    }

    public TmfAnalysisViewOutput(String viewid) {
        this.fViewId = viewid;
        this.fSecondaryId = null;
    }

    public TmfAnalysisViewOutput(String viewid, String secondaryId) {
        this.fViewId = viewid;
        this.fSecondaryId = secondaryId;
    }

    public String getViewId() {
        return this.fViewId;
    }

    public String getName() {
        IViewDescriptor descr = PlatformUI.getWorkbench().getViewRegistry().find(this.fViewId);
        String viewName = descr != null ? descr.getLabel() : this.fViewId + Messages.TmfAnalysisViewOutput_ViewUnavailable;
        return viewName;
    }

    protected IViewPart openView() throws PartInitException {
        IViewPart newViewPart;
        IWorkbench wb = PlatformUI.getWorkbench();
        IWorkbenchPage activePage = wb.getActiveWorkbenchWindow().getActivePage();
        IViewReference[] views = activePage.getViewReferences();
        String id = this.getId();
        ArrayList<IViewReference> correctTypeViews = new ArrayList<IViewReference>();
        IViewReference[] iViewReferenceArray = views;
        int n = views.length;
        int n2 = 0;
        while (n2 < n) {
            Object openedViewId;
            IViewReference view = iViewReferenceArray[n2];
            if (view.getSecondaryId() != null) {
                try {
                    UUID.fromString(Objects.requireNonNull(view.getSecondaryId()));
                    openedViewId = view.getId();
                }
                catch (IllegalArgumentException exception) {
                    openedViewId = view.getId() + ":" + view.getSecondaryId().split("&")[0];
                }
            } else {
                openedViewId = view.getId();
            }
            if (((String)openedViewId).equals(id)) {
                correctTypeViews.add(view);
            }
            ++n2;
        }
        for (IViewReference view : correctTypeViews) {
            TmfView pinnableView;
            IViewPart viewPart = view.getView(false);
            if (!(viewPart instanceof TmfView) || (pinnableView = (TmfView)viewPart).isPinned()) continue;
            return activePage.showView(view.getId(), view.getSecondaryId(), 1);
        }
        if (correctTypeViews.size() > 0 && (newViewPart = TmfViewFactory.newView(id, true)) != null) {
            IViewSite viewSite = newViewPart.getViewSite();
            return activePage.showView(viewSite.getId(), viewSite.getSecondaryId(), 1);
        }
        return activePage.showView(this.getId());
    }

    public String getId() {
        Object viewId = this.fViewId;
        String secondaryId = this.fSecondaryId;
        if (secondaryId != null) {
            viewId = (String)viewId + ":" + secondaryId;
        }
        return String.valueOf(viewId);
    }

    public void requestOutput() {
        Display.getDefault().asyncExec(() -> {
            try {
                IViewPart view = this.openView();
                if (!this.fProperties.isEmpty() && view instanceof WorkbenchPart) {
                    WorkbenchPart wbPart = (WorkbenchPart)view;
                    for (String key : this.fProperties.keySet()) {
                        wbPart.setPartProperty(key, this.fProperties.get(key));
                    }
                }
            }
            catch (PartInitException e) {
                TraceUtils.displayErrorMsg(Messages.TmfAnalysisViewOutput_Title, "Error opening view " + this.getName() + e.getMessage());
                Activator.getDefault().logError("Error opening view " + this.getName(), e);
            }
        });
    }

    public void setOutputProperty(@NonNull String key, String value, boolean immediate) {
        if (value == null) {
            this.fProperties.remove(key);
        } else {
            IWorkbench wb;
            IWorkbenchPage activePage;
            IViewPart view;
            this.fProperties.put(key, value);
            if (immediate && (view = (activePage = (wb = PlatformUI.getWorkbench()).getActiveWorkbenchWindow().getActivePage()).findView(this.fViewId)) instanceof WorkbenchPart) {
                ((WorkbenchPart)view).setPartProperty(key, value);
            }
        }
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        this.fViewId = config.getAttribute("id");
    }
}

