/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xbean.classloader;

import java.io.File;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarFile;
import org.apache.xbean.classloader.JarFileClassLoader;
import org.apache.xbean.classloader.NonLockingJarFile;
import org.apache.xbean.classloader.UrlResourceFinder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NonLockingJarFileClassLoader
extends JarFileClassLoader {
    private static final UrlResourceFinder.JarFileFactory JAR_FILE_FACTORY = new UrlResourceFinder.JarFileFactory(){
        private Map<File, SoftReference<NonLockingJarFile>> jarFileCache = new HashMap<File, SoftReference<NonLockingJarFile>>();

        public JarFile newJarFile(File file) throws IOException {
            NonLockingJarFile rtn;
            SoftReference<NonLockingJarFile> cached = this.jarFileCache.get(file);
            NonLockingJarFile nonLockingJarFile = rtn = cached == null ? null : cached.get();
            if (rtn == null) {
                rtn = new NonLockingJarFile(file);
                this.jarFileCache.put(file, new SoftReference<NonLockingJarFile>(rtn));
            }
            return rtn;
        }
    };

    public NonLockingJarFileClassLoader(String name, URL[] urls, ClassLoader parent, boolean inverseClassLoading, String[] hiddenClasses, String[] nonOverridableClasses) {
        super(name, urls, parent, inverseClassLoading, hiddenClasses, nonOverridableClasses);
    }

    public NonLockingJarFileClassLoader(String name, URL[] urls, ClassLoader parent) {
        super(name, urls, parent);
    }

    public NonLockingJarFileClassLoader(String name, URL[] urls, ClassLoader[] parents, boolean inverseClassLoading, Collection<String> hiddenClasses, Collection<String> nonOverridableClasses) {
        super(name, urls, parents, inverseClassLoading, hiddenClasses, nonOverridableClasses);
    }

    public NonLockingJarFileClassLoader(String name, URL[] urls, ClassLoader[] parents, boolean inverseClassLoading, String[] hiddenClasses, String[] nonOverridableClasses) {
        super(name, urls, parents, inverseClassLoading, hiddenClasses, nonOverridableClasses);
    }

    public NonLockingJarFileClassLoader(String name, URL[] urls, ClassLoader[] parents) {
        super(name, urls, parents);
    }

    public NonLockingJarFileClassLoader(String name, URL[] urls) {
        super(name, urls);
    }

    @Override
    protected UrlResourceFinder newResourceFinder() {
        return new UrlResourceFinder(JAR_FILE_FACTORY);
    }
}

