/*
 * Decompiled with CFR 0.152.
 */
package jdk.test.lib.hprof.model;

import java.io.IOException;
import java.nio.ByteOrder;
import java.util.Objects;
import jdk.test.lib.hprof.model.ArrayTypeCodes;
import jdk.test.lib.hprof.model.JavaBoolean;
import jdk.test.lib.hprof.model.JavaByte;
import jdk.test.lib.hprof.model.JavaChar;
import jdk.test.lib.hprof.model.JavaClass;
import jdk.test.lib.hprof.model.JavaDouble;
import jdk.test.lib.hprof.model.JavaFloat;
import jdk.test.lib.hprof.model.JavaHeapObjectVisitor;
import jdk.test.lib.hprof.model.JavaInt;
import jdk.test.lib.hprof.model.JavaLazyReadObject;
import jdk.test.lib.hprof.model.JavaLong;
import jdk.test.lib.hprof.model.JavaShort;
import jdk.test.lib.hprof.model.JavaThing;
import jdk.test.lib.hprof.model.Snapshot;
import jdk.test.lib.hprof.parser.ReadBuffer;

public class JavaValueArray
extends JavaLazyReadObject
implements ArrayTypeCodes {
    private JavaClass clazz;
    private int data;
    private static final int SIGNATURE_MASK = 255;
    private static final int LENGTH_DIVIDER_MASK = 65280;
    private static final int LENGTH_DIVIDER_SHIFT = 8;
    private static final int STRING_HI_BYTE_SHIFT;
    private static final int STRING_LO_BYTE_SHIFT;

    private static String arrayTypeName(byte sig) {
        switch (sig) {
            case 66: {
                return "byte[]";
            }
            case 90: {
                return "boolean[]";
            }
            case 67: {
                return "char[]";
            }
            case 83: {
                return "short[]";
            }
            case 73: {
                return "int[]";
            }
            case 70: {
                return "float[]";
            }
            case 74: {
                return "long[]";
            }
            case 68: {
                return "double[]";
            }
        }
        throw new RuntimeException("invalid array element sig: " + sig);
    }

    private static int elementSize(byte type) {
        switch (type) {
            case 66: 
            case 90: {
                return 1;
            }
            case 67: 
            case 83: {
                return 2;
            }
            case 70: 
            case 73: {
                return 4;
            }
            case 68: 
            case 74: {
                return 8;
            }
        }
        throw new RuntimeException("invalid array element type: " + type);
    }

    @Override
    protected final long readValueLength() throws IOException {
        long offset = this.getOffset() + (long)this.idSize() + 4L;
        long len = this.buf().getInt(offset);
        return len * (long)JavaValueArray.elementSize(this.getElementType());
    }

    private long dataStartOffset() {
        return this.getOffset() + (long)this.idSize() + 4L + 4L + 1L;
    }

    @Override
    protected final JavaThing[] readValue() throws IOException {
        int len = this.getLength();
        long offset = this.dataStartOffset();
        JavaThing[] res = new JavaThing[len];
        ReadBuffer readBuffer = this.buf();
        synchronized (readBuffer) {
            switch (this.getElementType()) {
                case 90: {
                    for (int i = 0; i < len; ++i) {
                        res[i] = new JavaBoolean(this.booleanAt(offset));
                        ++offset;
                    }
                    return res;
                }
                case 66: {
                    for (int i = 0; i < len; ++i) {
                        res[i] = new JavaByte(this.byteAt(offset));
                        ++offset;
                    }
                    return res;
                }
                case 67: {
                    for (int i = 0; i < len; ++i) {
                        res[i] = new JavaChar(this.charAt(offset));
                        offset += 2L;
                    }
                    return res;
                }
                case 83: {
                    for (int i = 0; i < len; ++i) {
                        res[i] = new JavaShort(this.shortAt(offset));
                        offset += 2L;
                    }
                    return res;
                }
                case 73: {
                    for (int i = 0; i < len; ++i) {
                        res[i] = new JavaInt(this.intAt(offset));
                        offset += 4L;
                    }
                    return res;
                }
                case 74: {
                    for (int i = 0; i < len; ++i) {
                        res[i] = new JavaLong(this.longAt(offset));
                        offset += 8L;
                    }
                    return res;
                }
                case 70: {
                    for (int i = 0; i < len; ++i) {
                        res[i] = new JavaFloat(this.floatAt(offset));
                        offset += 4L;
                    }
                    return res;
                }
                case 68: {
                    for (int i = 0; i < len; ++i) {
                        res[i] = new JavaDouble(this.doubleAt(offset));
                        offset += 8L;
                    }
                    return res;
                }
            }
            throw new RuntimeException("unknown primitive type?");
        }
    }

    public JavaValueArray(byte elementSignature, long offset) {
        super(offset);
        this.data = elementSignature & 0xFF;
    }

    @Override
    public JavaClass getClazz() {
        return this.clazz;
    }

    @Override
    public void visitReferencedObjects(JavaHeapObjectVisitor v) {
        super.visitReferencedObjects(v);
    }

    @Override
    public void resolve(Snapshot snapshot) {
        if (this.clazz instanceof JavaClass) {
            return;
        }
        byte elementSig = this.getElementType();
        this.clazz = snapshot.findClass(JavaValueArray.arrayTypeName(elementSig));
        if (this.clazz == null) {
            this.clazz = snapshot.getArrayClass("" + (char)elementSig);
        }
        this.getClazz().addInstance(this);
        super.resolve(snapshot);
    }

    public int getLength() {
        int divider = (this.data & 0xFF00) >>> 8;
        if (divider == 0) {
            byte elementSignature = this.getElementType();
            switch (elementSignature) {
                case 66: 
                case 90: {
                    divider = 1;
                    break;
                }
                case 67: 
                case 83: {
                    divider = 2;
                    break;
                }
                case 70: 
                case 73: {
                    divider = 4;
                    break;
                }
                case 68: 
                case 74: {
                    divider = 8;
                    break;
                }
                default: {
                    throw new RuntimeException("unknown primitive type: " + elementSignature);
                }
            }
            this.data |= divider << 8;
        }
        return (int)(this.getValueLength() / (long)divider);
    }

    public JavaThing[] getElements() {
        return this.getValue();
    }

    public byte getElementType() {
        return (byte)(this.data & 0xFF);
    }

    private void checkIndex(int index) {
        Objects.checkIndex(index, this.getLength());
    }

    private void requireType(char type) {
        if (this.getElementType() != type) {
            throw new RuntimeException("not of type : " + type);
        }
    }

    public String valueString() {
        return this.valueString(true);
    }

    public String valueString(boolean bigLimit) {
        StringBuilder result;
        JavaThing[] things = this.getValue();
        byte elementSignature = this.getElementType();
        if (elementSignature == 67) {
            result = new StringBuilder();
            for (int i = 0; i < things.length; ++i) {
                result.append(things[i]);
            }
        } else {
            int limit = 8;
            if (bigLimit) {
                limit = 1000;
            }
            result = new StringBuilder("{");
            block10: for (int i = 0; i < things.length; ++i) {
                if (i > 0) {
                    result.append(", ");
                }
                if (i >= limit) {
                    result.append("... ");
                    break;
                }
                switch (elementSignature) {
                    case 90: {
                        boolean val = ((JavaBoolean)things[i]).value;
                        if (val) {
                            result.append("true");
                            continue block10;
                        }
                        result.append("false");
                        continue block10;
                    }
                    case 66: {
                        byte val = ((JavaByte)things[i]).value;
                        result.append("0x").append(Integer.toString(val, 16));
                        continue block10;
                    }
                    case 83: {
                        short val = ((JavaShort)things[i]).value;
                        result.append(val);
                        continue block10;
                    }
                    case 73: {
                        int val = ((JavaInt)things[i]).value;
                        result.append(val);
                        continue block10;
                    }
                    case 74: {
                        long val = ((JavaLong)things[i]).value;
                        result.append(val);
                        continue block10;
                    }
                    case 70: {
                        float val = ((JavaFloat)things[i]).value;
                        result.append(val);
                        continue block10;
                    }
                    case 68: {
                        double val = ((JavaDouble)things[i]).value;
                        result.append(val);
                        continue block10;
                    }
                    default: {
                        throw new RuntimeException("unknown primitive type?");
                    }
                }
            }
            result.append('}');
        }
        return result.toString();
    }

    public String valueAsString(boolean compact) {
        if (this.getElementType() == 66) {
            JavaThing[] things = this.getValue();
            if (compact) {
                byte[] bytes = new byte[things.length];
                for (int i = 0; i < things.length; ++i) {
                    bytes[i] = ((JavaByte)things[i]).value;
                }
                return new String(bytes);
            }
            char[] chars = new char[things.length / 2];
            for (int i = 0; i < things.length; i += 2) {
                int b1 = ((JavaByte)things[i]).value << STRING_HI_BYTE_SHIFT;
                int b2 = ((JavaByte)things[i + 1]).value << STRING_LO_BYTE_SHIFT;
                chars[i / 2] = (char)(b1 | b2);
            }
            return new String(chars);
        }
        return this.valueString();
    }

    static {
        if (ByteOrder.nativeOrder() == ByteOrder.BIG_ENDIAN) {
            STRING_HI_BYTE_SHIFT = 8;
            STRING_LO_BYTE_SHIFT = 0;
        } else {
            STRING_HI_BYTE_SHIFT = 0;
            STRING_LO_BYTE_SHIFT = 8;
        }
    }
}

