/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.ISaveablePart;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPart2;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.Saveable;
import org.eclipse.ui.internal.SaveableHelper;

public class DefaultSaveable
extends Saveable {
    private final IWorkbenchPart part;

    public DefaultSaveable(IWorkbenchPart part) {
        this.part = part;
    }

    @Override
    public void doSave(IProgressMonitor monitor) {
        ISaveablePart saveable = SaveableHelper.getSaveable(this.part);
        if (saveable != null) {
            saveable.doSave(monitor);
        }
    }

    @Override
    public String getName() {
        if (this.part instanceof IWorkbenchPart2) {
            return ((IWorkbenchPart2)this.part).getPartName();
        }
        return this.part.getTitle();
    }

    @Override
    public ImageDescriptor getImageDescriptor() {
        Image image = this.part.getTitleImage();
        if (image == null) {
            return null;
        }
        return ImageDescriptor.createFromImage((Image)image);
    }

    @Override
    public String getToolTipText() {
        return this.part.getTitleToolTip();
    }

    @Override
    public boolean isDirty() {
        ISaveablePart saveable = SaveableHelper.getSaveable(this.part);
        if (saveable != null) {
            return saveable.isDirty();
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.part.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DefaultSaveable other = (DefaultSaveable)obj;
        return !(this.part == null ? other.part != null : !this.part.equals(other.part));
    }

    @Override
    public boolean show(IWorkbenchPage page) {
        IWorkbenchPartReference reference = page.getReference(this.part);
        if (reference != null) {
            page.activate(this.part);
            return true;
        }
        IWorkbenchPart iWorkbenchPart = this.part;
        if (iWorkbenchPart instanceof IViewPart) {
            IViewPart viewPart = (IViewPart)iWorkbenchPart;
            try {
                page.showView(viewPart.getViewSite().getId(), viewPart.getViewSite().getSecondaryId(), 1);
            }
            catch (PartInitException e) {
                return false;
            }
            return true;
        }
        return false;
    }
}

