/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.internal.services.about;

import java.io.PrintWriter;
import java.text.Collator;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.e4.core.internal.services.about.AboutMessages;
import org.eclipse.e4.core.services.about.ISystemInformation;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.osgi.service.component.annotations.Component;

@Component(service={ISystemInformation.class})
@ISystemInformation.Section(value="section.installed.bundles")
public class InstalledBundles
implements ISystemInformation {
    @Override
    public void append(PrintWriter writer) {
        Bundle[] bundles = FrameworkUtil.getBundle(InstalledBundles.class).getBundleContext().getBundles();
        Map<String, String> headers = Arrays.stream(bundles).collect(Collectors.toMap(this::identify, this::name));
        Arrays.stream(bundles).sorted(this.createComparator(headers)).forEach(b -> this.writeBundleInfo(writer, (Bundle)b));
    }

    String identify(Bundle bundle) {
        return bundle.getSymbolicName() + "_" + String.valueOf(bundle.getVersion());
    }

    private String name(Bundle bundle) {
        String name = (String)bundle.getHeaders(null).get("Bundle-Name");
        return name != null ? name : "";
    }

    private void writeBundleInfo(PrintWriter writer, Bundle bundle) {
        String id = bundle.getSymbolicName();
        String version = bundle.getVersion().toString();
        String name = this.name(bundle);
        String state = this.getStateName(bundle.getState());
        writer.println(String.format(AboutMessages.bundleInfoFormat, id, version, name, state));
    }

    private Comparator<Bundle> createComparator(Map<String, String> names) {
        Collator collator = Collator.getInstance(Locale.getDefault());
        return (o1, o2) -> {
            String id2;
            String id1 = this.identify((Bundle)o1);
            if (!id1.equals(id2 = this.identify((Bundle)o2))) {
                return collator.compare(id1, id2);
            }
            return collator.compare((String)names.get(id1), (String)names.get(id2));
        };
    }

    private String getStateName(int state) {
        return switch (state) {
            case 2 -> AboutMessages.bundleStateInstalled;
            case 4 -> AboutMessages.bundleStateResolved;
            case 8 -> AboutMessages.bundleStateStarting;
            case 16 -> AboutMessages.bundleStateStopping;
            case 1 -> AboutMessages.bundleStateUninstalled;
            case 32 -> AboutMessages.bundleStateActive;
            default -> AboutMessages.bundleStateUnknown;
        };
    }
}

