/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.codan.internal.core;

import org.eclipse.cdt.codan.core.CodanCorePlugin;
import org.eclipse.cdt.codan.core.model.CodanSeverity;
import org.eclipse.cdt.codan.core.model.IProblem;
import org.eclipse.cdt.codan.core.model.IProblemProfile;
import org.eclipse.cdt.codan.core.model.IProblemWorkingCopy;
import org.eclipse.cdt.codan.core.param.IProblemPreference;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.osgi.service.prefs.Preferences;

public class CodanPreferencesLoader {
    private IProblemProfile baseModel;

    public CodanPreferencesLoader(IProblemProfile profile) {
        this.setInput(profile);
    }

    public CodanPreferencesLoader() {
    }

    public void setInput(IProblemProfile profile) {
        this.baseModel = profile;
    }

    public IProblem[] getProblems() {
        IProblem[] problems = this.baseModel.getProblems();
        return problems;
    }

    public void setProperty(String id, String s) {
        CodanSeverity sev;
        IProblem prob = this.baseModel.findProblem(id);
        if (!(prob instanceof IProblemWorkingCopy)) {
            return;
        }
        String sevs = s;
        boolean enabled = true;
        if (sevs.startsWith("-")) {
            sevs = sevs.substring(1);
            enabled = false;
        }
        ((IProblemWorkingCopy)prob).setEnabled(enabled);
        try {
            sev = CodanSeverity.valueOf(sevs);
        }
        catch (RuntimeException e) {
            sev = CodanSeverity.Warning;
        }
        ((IProblemWorkingCopy)prob).setSeverity(sev);
    }

    public String toString() {
        return this.getInput().toString();
    }

    public IProblemProfile getInput() {
        return this.baseModel;
    }

    public String getProperty(String id) {
        IProblem prob = this.baseModel.findProblem(id);
        String enabled = prob.isEnabled() ? "" : "-";
        String severity = prob.getSeverity().toString();
        String res = enabled + severity;
        return res;
    }

    public void load(Preferences storePreferences) {
        IProblem[] probs = this.getProblems();
        int i = 0;
        while (i < probs.length) {
            String id = probs[i].getId();
            String s = storePreferences.get(id, null);
            if (s != null) {
                this.setProperty(id, s);
                this.setProblemPreferenceValues(id, storePreferences);
            }
            ++i;
        }
    }

    public void load(Preferences[] storePreferences) {
        IPreferencesService prefService = Platform.getPreferencesService();
        IProblem[] probs = this.getProblems();
        int i = 0;
        while (i < probs.length) {
            String id = probs[i].getId();
            String s = prefService.get(id, null, storePreferences);
            if (s != null) {
                this.setProperty(id, s);
                this.setProblemPreferenceValues(id, storePreferences);
            }
            ++i;
        }
    }

    private void setProblemPreferenceValues(String problemId, Preferences storePreferences) {
        IProblem prob = this.baseModel.findProblem(problemId);
        String prefKey = this.getPreferencesKey(problemId);
        if (prefKey == null) {
            return;
        }
        String exported = storePreferences.get(prefKey, null);
        if (exported != null) {
            try {
                prob.getPreference().importValue(exported);
            }
            catch (IllegalArgumentException e) {
                CodanCorePlugin.log(e);
            }
        }
    }

    private void setProblemPreferenceValues(String problemId, Preferences[] storePreferences) {
        IPreferencesService prefService = Platform.getPreferencesService();
        IProblem prob = this.baseModel.findProblem(problemId);
        String prefKey = this.getPreferencesKey(problemId);
        if (prefKey == null) {
            return;
        }
        String exported = prefService.get(prefKey, null, storePreferences);
        if (exported != null) {
            try {
                prob.getPreference().importValue(exported);
            }
            catch (IllegalArgumentException e) {
                CodanCorePlugin.log(e);
            }
        }
    }

    public static IEclipsePreferences getProjectNode(IProject project) {
        if (!project.exists()) {
            return null;
        }
        return new ProjectScope(project).getNode("org.eclipse.cdt.codan.core");
    }

    public static IEclipsePreferences getWorkspaceNode() {
        return InstanceScope.INSTANCE.getNode("org.eclipse.cdt.codan.core");
    }

    public String getPreferencesKey(String id) {
        IProblem prob = this.baseModel.findProblem(id);
        IProblemPreference pref = prob.getPreference();
        if (pref == null) {
            return null;
        }
        return id + "." + pref.getKey();
    }

    public String getPreferencesString(String id) {
        IProblem prob = this.baseModel.findProblem(id);
        IProblemPreference pref = prob.getPreference();
        if (pref == null) {
            return null;
        }
        String str = pref.exportValue();
        return str;
    }
}

