/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.lsp.clangd.internal.config;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.eclipse.cdt.lsp.util.LspUtils;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ui.statushandlers.StatusManager;

public class CompileCommandsMonitor {
    private static final String CDBF_SPECIFICATION_JSON_FILE = "compile_commands.json";
    private static final long DEBOUNCE_DELAY = 2000L;
    private final IWorkspace workspace;
    private final Debouncer debouncer;
    private final IResourceChangeListener listener = new IResourceChangeListener(){

        public void resourceChanged(IResourceChangeEvent event) {
            Set<IProject> affectedProjects = this.collectAffectedProjects(event);
            if (!affectedProjects.isEmpty()) {
                CompileCommandsMonitor.this.debouncer.run(() -> CompileCommandsMonitor.this.restartLanguageServers());
            }
        }

        private Set<IProject> collectAffectedProjects(IResourceChangeEvent event) {
            HashSet<IProject> projects = new HashSet<IProject>();
            if (event.getDelta() != null && event.getType() == 1) {
                try {
                    event.getDelta().accept(delta -> {
                        if ((delta.getKind() == 1 || delta.getKind() == 2 || (delta.getFlags() & 0x100) != 0) && CompileCommandsMonitor.CDBF_SPECIFICATION_JSON_FILE.equals(delta.getResource().getName())) {
                            projects.add(delta.getResource().getProject());
                        }
                        return true;
                    });
                }
                catch (CoreException e) {
                    StatusManager.getManager().handle(e, "org.eclipse.cdt.lsp.clangd");
                }
            }
            return projects;
        }
    };

    public CompileCommandsMonitor(IWorkspace workspace) {
        this.workspace = workspace;
        this.debouncer = new Debouncer(2000L);
    }

    protected void restartLanguageServers() {
        LspUtils.getLanguageServers().forEach(w -> w.restart());
    }

    public CompileCommandsMonitor start() {
        this.workspace.addResourceChangeListener(this.listener);
        this.debouncer.start();
        return this;
    }

    public void stop() {
        this.workspace.removeResourceChangeListener(this.listener);
        this.debouncer.stop();
    }

    private static final class Debouncer {
        private long debounceDelay;
        private ScheduledExecutorService scheduler;
        private ScheduledFuture<?> debounceTimer;

        public Debouncer(long debounceDelay) {
            this.debounceDelay = debounceDelay;
        }

        public void run(Runnable runnable) {
            if (this.debounceTimer != null && !this.debounceTimer.isDone()) {
                this.debounceTimer.cancel(true);
            }
            this.debounceTimer = this.scheduler.schedule(runnable, this.debounceDelay, TimeUnit.MILLISECONDS);
        }

        public void start() {
            this.scheduler = Executors.newScheduledThreadPool(1);
        }

        public void stop() {
            this.scheduler.shutdown();
        }
    }
}

