/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.common.project.facet.core.libprov.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.ExpressionConverter;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jst.common.project.facet.core.internal.FacetedProjectFrameworkJavaPlugin;
import org.eclipse.jst.common.project.facet.core.libprov.ILibraryProvider;
import org.eclipse.jst.common.project.facet.core.libprov.LibraryProviderActionType;
import org.eclipse.jst.common.project.facet.core.libprov.LibraryProviderFramework;
import org.eclipse.jst.common.project.facet.core.libprov.LibraryProviderOperationConfig;
import org.eclipse.jst.common.project.facet.core.libprov.internal.LegacyLibraryProviderDetectorsExtensionPoint;
import org.eclipse.jst.common.project.facet.core.libprov.internal.LibraryProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.project.facet.core.FacetedProjectFramework;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.util.internal.PluginUtil;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public final class LibraryProviderFrameworkImpl {
    private static final String UNKNOWN_LIBRARY_PROVIDER = "unknown-library-provider";
    private static final String EXTENSION_POINT_ID = "libraryProviders";
    private static final String EL_ACTION = "action";
    private static final String EL_CONFIG = "config";
    private static final String EL_ENABLEMENT = "enablement";
    private static final String EL_LABEL = "label";
    private static final String EL_OPERATION = "operation";
    private static final String EL_PARAM = "param";
    private static final String EL_PRIORITY = "priority";
    private static final String EL_PROVIDER = "provider";
    private static final String ATTR_ABSTRACT = "abstract";
    private static final String ATTR_CLASS = "class";
    private static final String ATTR_EXTENDS = "extends";
    private static final String ATTR_HIDDEN = "hidden";
    private static final String ATTR_ID = "id";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_TYPE = "type";
    private static final String ATTR_VALUE = "value";
    private static final String PREFS_LIBPROV = "libprov";
    private static final String PREFS_PROVIDER_ID = "provider-id";
    private static final String PREFS_LAST_PROVIDER_USED = "libprov/last-provider-used";
    private static LibraryProviderFrameworkImpl instance = null;
    private final Set<ILibraryProvider> providers = new HashSet<ILibraryProvider>();
    private final Set<ILibraryProvider> providersReadOnly = Collections.unmodifiableSet(this.providers);
    private final Map<String, ILibraryProvider> providersLookupTable = new HashMap<String, ILibraryProvider>();

    public LibraryProviderFrameworkImpl() {
        this.readExtensions();
    }

    public static synchronized LibraryProviderFrameworkImpl get() {
        if (instance == null) {
            instance = new LibraryProviderFrameworkImpl();
        }
        return instance;
    }

    public Set<ILibraryProvider> getProviders() {
        return this.providersReadOnly;
    }

    public boolean isProviderDefined(String id) {
        return this.providersLookupTable.containsKey(id);
    }

    public ILibraryProvider getProvider(String id) {
        if (!this.isProviderDefined(id)) {
            String msg = Resources.bind((String)Resources.libraryProviderNotDefined, (Object)id);
            throw new IllegalArgumentException(msg);
        }
        return this.providersLookupTable.get(id);
    }

    public ILibraryProvider getCurrentProvider(IProject project, IProjectFacet facet) {
        IFacetedProject fproj;
        try {
            fproj = ProjectFacetsManager.create((IProject)project);
        }
        catch (CoreException e) {
            throw new RuntimeException(e);
        }
        if (!fproj.hasProjectFacet(facet)) {
            return null;
        }
        String providerId = null;
        try {
            Preferences prefs = fproj.getPreferences(facet);
            if (prefs.nodeExists(PREFS_LIBPROV)) {
                prefs = prefs.node(PREFS_LIBPROV);
                providerId = prefs.get(PREFS_PROVIDER_ID, null);
            }
        }
        catch (BackingStoreException e) {
            throw new RuntimeException(e);
        }
        ILibraryProvider provider = null;
        if (providerId != null) {
            provider = LibraryProviderFramework.isProviderDefined(providerId) ? LibraryProviderFramework.getProvider(providerId) : this.getProvider(UNKNOWN_LIBRARY_PROVIDER);
        } else {
            provider = LegacyLibraryProviderDetectorsExtensionPoint.detect(project, facet);
            if (provider == null) {
                provider = this.getProvider(UNKNOWN_LIBRARY_PROVIDER);
            }
        }
        return provider;
    }

    public void setCurrentProvider(IProject project, IProjectFacet facet, ILibraryProvider provider) {
        IFacetedProject fproj;
        try {
            fproj = ProjectFacetsManager.create((IProject)project);
        }
        catch (CoreException e) {
            throw new RuntimeException(e);
        }
        try {
            Preferences prefs = fproj.getPreferences(facet).node(PREFS_LIBPROV);
            if (provider == null) {
                prefs.removeNode();
            } else {
                prefs.put(PREFS_PROVIDER_ID, provider.getId());
            }
            prefs.flush();
        }
        catch (BackingStoreException e) {
            throw new RuntimeException(e);
        }
    }

    public ILibraryProvider getLastProviderUsed(IProjectFacetVersion fv) {
        try {
            IProjectFacet facet = fv.getProjectFacet();
            Preferences prefs = FacetedProjectFramework.getPreferences((IProjectFacet)facet).node(PREFS_LAST_PROVIDER_USED);
            String providerId = prefs.get(fv.getVersionString(), null);
            if (providerId != null && this.isProviderDefined(providerId)) {
                return this.getProvider(providerId);
            }
        }
        catch (BackingStoreException e) {
            FacetedProjectFrameworkJavaPlugin.log((Exception)((Object)e));
        }
        return null;
    }

    public void setLastProviderUsed(IProjectFacetVersion fv, ILibraryProvider provider) {
        try {
            IProjectFacet facet = fv.getProjectFacet();
            Preferences prefs = FacetedProjectFramework.getPreferences((IProjectFacet)facet).node(PREFS_LAST_PROVIDER_USED);
            prefs.put(fv.getVersionString(), provider.getId());
            prefs.flush();
        }
        catch (BackingStoreException e) {
            FacetedProjectFrameworkJavaPlugin.log((Exception)((Object)e));
        }
    }

    public static void reportInvalidActionType(String type, String pluginId) {
        String msg = Resources.bind((String)Resources.invalidActionType, (Object)type, (Object)pluginId);
        FacetedProjectFrameworkJavaPlugin.log(FacetedProjectFrameworkJavaPlugin.createErrorStatus(msg));
    }

    public static void reportProviderNotDefined(String providerId, String pluginId) {
        String msg = Resources.bind((String)Resources.libraryProviderNotDefinedWithPlugin, (Object)providerId, (Object)pluginId);
        FacetedProjectFrameworkJavaPlugin.log(FacetedProjectFrameworkJavaPlugin.createErrorStatus(msg));
    }

    /*
     * WARNING - void declaration
     */
    private void readExtensions() {
        String baseProviderId;
        LibraryProvider provider;
        void var5_8;
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint("org.eclipse.jst.common.project.facet.core", EXTENSION_POINT_ID);
        if (point == null) {
            throw new IllegalStateException();
        }
        ArrayList<IConfigurationElement> cfgels = new ArrayList<IConfigurationElement>();
        IExtension[] iExtensionArray = point.getExtensions();
        int n = iExtensionArray.length;
        boolean n2 = false;
        while (var5_8 < n) {
            IExtension extension = iExtensionArray[var5_8];
            IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
            int n3 = iConfigurationElementArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement element = iConfigurationElementArray[n4];
                cfgels.add(element);
                ++n4;
            }
            ++var5_8;
        }
        HashMap<LibraryProvider, String> providerToBaseIdMap = new HashMap<LibraryProvider, String>();
        for (IConfigurationElement iConfigurationElement : cfgels) {
            if (!iConfigurationElement.getName().equals(EL_PROVIDER)) continue;
            try {
                String hiddenAttr;
                String abstractAttr;
                provider = new LibraryProvider();
                provider.setPluginId(iConfigurationElement.getContributor().getName());
                provider.setId(PluginUtil.findRequiredAttribute((IConfigurationElement)iConfigurationElement, (String)ATTR_ID));
                if (this.providersLookupTable.containsKey(provider.getId())) {
                    String msg = Resources.bind((String)Resources.libraryProviderIdAlreadyUsed, (Object)provider.getId());
                    FacetedProjectFrameworkJavaPlugin.log(FacetedProjectFrameworkJavaPlugin.createErrorStatus(msg));
                    throw new PluginUtil.InvalidExtensionException();
                }
                baseProviderId = iConfigurationElement.getAttribute(ATTR_EXTENDS);
                if (baseProviderId != null) {
                    providerToBaseIdMap.put(provider, baseProviderId.trim());
                }
                if ((abstractAttr = iConfigurationElement.getAttribute(ATTR_ABSTRACT)) != null) {
                    provider.setIsAbstract(Boolean.valueOf(abstractAttr));
                }
                if ((hiddenAttr = iConfigurationElement.getAttribute(ATTR_HIDDEN)) != null) {
                    provider.setIsHidden(Boolean.valueOf(hiddenAttr));
                }
                IConfigurationElement[] iConfigurationElementArray = iConfigurationElement.getChildren();
                int n5 = iConfigurationElementArray.length;
                int n6 = 0;
                while (n6 < n5) {
                    IConfigurationElement child = iConfigurationElementArray[n6];
                    String childName = child.getName();
                    if (childName.equals(EL_LABEL)) {
                        provider.setLabel(child.getValue().trim());
                    } else if (childName.equals(EL_ENABLEMENT)) {
                        Expression expr;
                        try {
                            expr = ExpressionConverter.getDefault().perform(child);
                        }
                        catch (CoreException e) {
                            FacetedProjectFrameworkJavaPlugin.log((Exception)((Object)e));
                            throw new PluginUtil.InvalidExtensionException();
                        }
                        provider.setEnablementCondition(expr);
                    } else if (childName.equals(EL_PRIORITY)) {
                        int priority;
                        String priorityString = child.getValue().trim();
                        try {
                            priority = Integer.parseInt(priorityString);
                        }
                        catch (NumberFormatException e) {
                            FacetedProjectFrameworkJavaPlugin.log(e);
                            throw new PluginUtil.InvalidExtensionException();
                        }
                        provider.setPriority(priority);
                    } else if (childName.equals(EL_PARAM)) {
                        String name = PluginUtil.findRequiredAttribute((IConfigurationElement)child, (String)ATTR_NAME);
                        String value = child.getAttribute(ATTR_VALUE);
                        if (value == null) {
                            value = PluginUtil.getElementValue((IConfigurationElement)child, null);
                        }
                        provider.addParam(name, value);
                    } else if (childName.equals(EL_ACTION)) {
                        LibraryProviderActionType t;
                        String type = PluginUtil.findRequiredAttribute((IConfigurationElement)child, (String)ATTR_TYPE).toUpperCase();
                        try {
                            t = LibraryProviderActionType.valueOf(type);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            LibraryProviderFrameworkImpl.reportInvalidActionType(type, provider.getPluginId());
                            throw new PluginUtil.InvalidExtensionException();
                        }
                        IConfigurationElement elConfig = PluginUtil.findOptionalElement((IConfigurationElement)child, (String)EL_CONFIG);
                        String configClassName = elConfig == null ? LibraryProviderOperationConfig.class.getName() : PluginUtil.findRequiredAttribute((IConfigurationElement)elConfig, (String)ATTR_CLASS);
                        IConfigurationElement elOperation = PluginUtil.findRequiredElement((IConfigurationElement)child, (String)EL_OPERATION);
                        String operationClassName = PluginUtil.findRequiredAttribute((IConfigurationElement)elOperation, (String)ATTR_CLASS);
                        provider.addActionDef(t, configClassName, operationClassName);
                    }
                    ++n6;
                }
                if (provider == null) continue;
                this.providers.add(provider);
                this.providersLookupTable.put(provider.getId(), provider);
            }
            catch (PluginUtil.InvalidExtensionException invalidExtensionException) {}
        }
        for (Map.Entry entry : providerToBaseIdMap.entrySet()) {
            provider = (LibraryProvider)entry.getKey();
            baseProviderId = (String)entry.getValue();
            ILibraryProvider baseProvider = this.providersLookupTable.get(baseProviderId);
            if (baseProvider == null) {
                LibraryProviderFrameworkImpl.reportProviderNotDefined(baseProviderId, provider.getPluginId());
                this.providers.remove(provider);
                this.providersLookupTable.remove(provider.getId());
                continue;
            }
            provider.setBaseProvider(baseProvider);
        }
    }

    private static final class Resources
    extends NLS {
        public static String libraryProviderNotDefined;
        public static String libraryProviderNotDefinedWithPlugin;
        public static String libraryProviderIdAlreadyUsed;
        public static String invalidActionType;

        static {
            Resources.initializeMessages((String)LibraryProviderFrameworkImpl.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

