/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.s.widgetmap;

import java.nio.file.Path;
import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.scout.sdk.core.s.model.js.ScoutJsModel;
import org.eclipse.scout.sdk.core.s.model.js.ScoutJsModels;
import org.eclipse.scout.sdk.core.s.widgetmap.IdObjectType;
import org.eclipse.scout.sdk.core.s.widgetmap.IdObjectTypeMap;
import org.eclipse.scout.sdk.core.s.widgetmap.ObjectType;
import org.eclipse.scout.sdk.core.s.widgetmap.WidgetMap;
import org.eclipse.scout.sdk.core.s.widgetmap.generator.IdObjectTypeMapGenerator;
import org.eclipse.scout.sdk.core.s.widgetmap.generator.ObjectTypeGenerator;
import org.eclipse.scout.sdk.core.typescript.generator.nodeelement.INodeElementGenerator;
import org.eclipse.scout.sdk.core.typescript.model.api.IConstantValue;
import org.eclipse.scout.sdk.core.typescript.model.api.IES6Class;
import org.eclipse.scout.sdk.core.typescript.model.api.INodeElement;
import org.eclipse.scout.sdk.core.typescript.model.api.IObjectLiteral;
import org.eclipse.scout.sdk.core.util.Strings;

public final class IdObjectTypeMapUtils {
    private IdObjectTypeMapUtils() {
    }

    public static Stream<ObjectType> createObjectTypesForPage(String pageOrModelName, IObjectLiteral pageModel) {
        if (pageOrModelName == null || pageModel == null) {
            return Stream.empty();
        }
        return Stream.concat(IdObjectTypeMapUtils.createDetailFormForPage(pageOrModelName, pageModel).stream(), IdObjectTypeMapUtils.createDetailTableForPage(pageOrModelName, pageModel).stream());
    }

    public static Optional<ObjectType> createDetailFormForPage(String pageOrModelName, IObjectLiteral pageModel) {
        return IdObjectTypeMapUtils.createObjectTypeForPage(pageOrModelName, pageModel, "detailForm", Predicate.not("Form"::equals));
    }

    public static Optional<ObjectType> createDetailTableForPage(String pageOrModelName, IObjectLiteral pageModel) {
        return IdObjectTypeMapUtils.createObjectTypeForPage(pageOrModelName, pageModel, "detailTable", Predicate.not("Table"::equals));
    }

    private static Optional<ObjectType> createObjectTypeForPage(String pageOrModelName, IObjectLiteral pageModel, String propertyName, Predicate<String> acceptName) {
        if (pageOrModelName == null || pageModel == null || propertyName == null || acceptName == null) {
            return Optional.empty();
        }
        String pageName = Strings.removeSuffix((String)pageOrModelName, (CharSequence)"Model");
        return pageModel.property(propertyName).filter(cv -> cv.type() == IConstantValue.ConstantValueType.ObjectLiteral).flatMap(IConstantValue::asObjectLiteral).flatMap(ol -> ol.property("objectType").flatMap(IConstantValue::asES6Class).flatMap(es6Class -> ObjectType.create(es6Class, IdObjectTypeMapUtils.calculateUsedNames((INodeElement)pageModel))).map(objectType -> {
            String es6ClassName = objectType.es6Class().name();
            Object newClassName = IdObjectTypeMapUtils.getId(ol).orElse(es6ClassName);
            if (!acceptName.test((String)newClassName) || es6ClassName.equals(newClassName)) {
                newClassName = pageName + (String)newClassName;
            }
            return objectType.withNewClassNameAndMaps((CharSequence)newClassName, (IObjectLiteral)ol);
        }));
    }

    public static Collection<String> calculateUsedNames(INodeElement nodeElement) {
        if (nodeElement == null) {
            return new HashSet<String>();
        }
        Path containingFile = nodeElement.containingFile().orElse(null);
        return nodeElement.containingModule().elements().stream().filter(element -> element.containingFile().filter(otherPath -> !otherPath.equals(containingFile)).isPresent()).filter(INodeElement::isExportedFromModule).map(INodeElement::moduleExportNames).flatMap(Collection::stream).collect(Collectors.toCollection(HashSet::new));
    }

    public static Optional<String> getId(IObjectLiteral model) {
        return IdObjectTypeMapUtils.getId(model, null);
    }

    public static Optional<String> getId(IObjectLiteral model, ScoutJsModel scoutJsModel) {
        return Optional.ofNullable(model).flatMap(ol -> ol.property("id")).flatMap(IConstantValue::asString).map(s -> IdObjectTypeMapUtils.removeNamespace(s, scoutJsModel, (INodeElement)model.containingModule())).flatMap(Strings::notBlank);
    }

    private static String removeNamespace(String s, ScoutJsModel scoutJsModel, INodeElement nodeElement) {
        if (scoutJsModel == null && nodeElement == null) {
            return s;
        }
        return Optional.ofNullable(scoutJsModel).or(() -> ScoutJsModels.create(nodeElement.containingModule())).flatMap(ScoutJsModel::namespace).map(namespace -> Strings.removePrefix((String)s, (CharSequence)(namespace + "."))).orElse(s);
    }

    public static Optional<IES6Class> getObjectType(IObjectLiteral model) {
        return Optional.ofNullable(model).flatMap(ol -> ol.property("objectType")).flatMap(IConstantValue::asES6Class);
    }

    public static Optional<IdObjectTypeMapGenerator> createIdObjectTypeMapGenerator(IdObjectTypeMap map) {
        return Optional.ofNullable(map).filter(Predicate.not(IdObjectTypeMap::isEmpty)).map(m -> new IdObjectTypeMapGenerator().withMap((IdObjectTypeMap)m));
    }

    public static Optional<ObjectTypeGenerator> createObjectTypeGenerator(ObjectType objectType) {
        return Optional.ofNullable(objectType).filter(ot -> ot.newClassName().isPresent()).map(ot -> new ObjectTypeGenerator().withObjectType((ObjectType)ot));
    }

    public static Optional<IdObjectTypeMapGenerator> createWidgetMapGenerator(String widgetOrModelName, IObjectLiteral widgetModel, IES6Class mainWidget) {
        return WidgetMap.create(widgetOrModelName, widgetModel, mainWidget).flatMap(IdObjectTypeMapUtils::createIdObjectTypeMapGenerator);
    }

    public static Stream<ObjectTypeGenerator> createObjectTypeGeneratorsForPage(String pageOrModelName, IObjectLiteral pageModel) {
        return IdObjectTypeMapUtils.createObjectTypesForPage(pageOrModelName, pageModel).map(IdObjectTypeMapUtils::createObjectTypeGenerator).flatMap(Optional::stream);
    }

    public static Optional<ObjectTypeGenerator> createDetailFormGeneratorForPage(String pageOrModelName, IObjectLiteral pageModel) {
        return IdObjectTypeMapUtils.createDetailFormForPage(pageOrModelName, pageModel).flatMap(IdObjectTypeMapUtils::createObjectTypeGenerator);
    }

    public static Optional<ObjectTypeGenerator> createDetailTableGeneratorForPage(String pageOrModelName, IObjectLiteral pageModel) {
        return IdObjectTypeMapUtils.createDetailTableForPage(pageOrModelName, pageModel).flatMap(IdObjectTypeMapUtils::createObjectTypeGenerator);
    }

    public static Stream<INodeElementGenerator<?>> collectAdditionalGenerators(IdObjectTypeMapGenerator generator) {
        return Optional.ofNullable(generator).flatMap(IdObjectTypeMapGenerator::map).stream().flatMap(IdObjectTypeMapUtils::collectAdditionalGenerators);
    }

    private static Stream<INodeElementGenerator<?>> collectAdditionalGenerators(IdObjectTypeMap map) {
        return map.elements().values().stream().map(IdObjectType::objectType).filter(objectType -> objectType.newClassName().isPresent()).flatMap(objectType -> Stream.concat(IdObjectTypeMapUtils.createObjectTypeGenerator(objectType).stream(), IdObjectTypeMapUtils.collectAdditionalGenerators(objectType)));
    }

    public static Stream<INodeElementGenerator<?>> collectAdditionalGenerators(ObjectTypeGenerator generator) {
        return Optional.ofNullable(generator).flatMap(ObjectTypeGenerator::objectType).stream().flatMap(IdObjectTypeMapUtils::collectAdditionalGenerators);
    }

    private static Stream<INodeElementGenerator<?>> collectAdditionalGenerators(ObjectType objectType) {
        return Stream.concat(objectType.widgetMap().stream().flatMap(m -> Stream.concat(IdObjectTypeMapUtils.createIdObjectTypeMapGenerator(m).stream(), IdObjectTypeMapUtils.collectAdditionalGenerators(m))), objectType.columnMap().stream().flatMap(m -> Stream.concat(IdObjectTypeMapUtils.createIdObjectTypeMapGenerator(m).stream(), IdObjectTypeMapUtils.collectAdditionalGenerators(m))));
    }
}

