/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.s.nls.properties;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import org.eclipse.scout.sdk.core.builder.ISourceBuilder;
import org.eclipse.scout.sdk.core.generator.ISourceGenerator;
import org.eclipse.scout.sdk.core.generator.properties.PropertiesGenerator;
import org.eclipse.scout.sdk.core.s.environment.IEnvironment;
import org.eclipse.scout.sdk.core.s.environment.IProgress;
import org.eclipse.scout.sdk.core.s.nls.Language;
import org.eclipse.scout.sdk.core.s.nls.properties.AbstractTranslationPropertiesFile;
import org.eclipse.scout.sdk.core.util.Ensure;
import org.eclipse.scout.sdk.core.util.SdkException;
import org.eclipse.scout.sdk.core.util.Strings;

public class EditableTranslationFile
extends AbstractTranslationPropertiesFile {
    private final Path m_file;

    public EditableTranslationFile(Path file, Charset encoding, Language language) {
        super(language, encoding, () -> EditableTranslationFile.toStream(file));
        this.m_file = (Path)Ensure.notNull((Object)file);
    }

    protected static InputStream toStream(Path file) {
        if (!Files.isRegularFile(file, new LinkOption[0])) {
            return new ByteArrayInputStream(new byte[0]);
        }
        try {
            return new BufferedInputStream(Files.newInputStream(file, StandardOpenOption.READ));
        }
        catch (IOException e) {
            throw new SdkException((CharSequence)"Cannot read file '{}'.", new Object[]{file, e});
        }
    }

    @Override
    public boolean isEditable() {
        return true;
    }

    @Override
    protected void writeEntries(PropertiesGenerator content, IEnvironment env, IProgress progress) {
        progress.init(100, "Write translation properties file", new Object[0]);
        content.properties().entrySet().removeIf(entry -> Strings.isBlank((CharSequence)((CharSequence)entry.getValue())) || Strings.isBlank((CharSequence)((CharSequence)entry.getKey())));
        progress.worked(10);
        if (content.properties().isEmpty()) {
            env.deleteIfExists(this.path());
            progress.worked(90);
            return;
        }
        env.writeResource((ISourceGenerator<ISourceBuilder<?>>)content, this.path(), progress.newChild(70));
        progress.worked(90);
    }

    @Override
    protected Object source() {
        return this.path();
    }

    public Path path() {
        return this.m_file;
    }
}

