/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.engine.discovery;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.engine.discovery.ClassNameFilter;

abstract class AbstractClassNameFilter
implements ClassNameFilter {
    protected final List<Pattern> patterns;
    protected final String patternDescription;

    AbstractClassNameFilter(String ... patterns) {
        Preconditions.notEmpty((Object[])patterns, (String)"patterns array must not be null or empty");
        Preconditions.containsNoNullElements((Object[])patterns, (String)"patterns array must not contain null elements");
        this.patterns = Arrays.stream(patterns).map(Pattern::compile).toList();
        this.patternDescription = Arrays.stream(patterns).collect(Collectors.joining("' OR '", "'", "'"));
    }

    @Override
    public abstract Predicate<String> toPredicate();

    protected Optional<Pattern> findMatchingPattern(String className) {
        return this.patterns.stream().filter(pattern -> pattern.matcher(className).matches()).findAny();
    }
}

