/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.references.search;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import org.eclipse.lemminx.dom.DOMAttr;
import org.eclipse.lemminx.dom.DOMNode;
import org.eclipse.lemminx.dom.DOMRange;
import org.eclipse.lemminx.extensions.references.search.SearchNode;
import org.eclipse.lemminx.utils.StringUtils;

public class SearchNodeFactory {
    private static final Predicate<Character> NAME_PREDICATE = ch -> !Character.isWhitespace(ch.charValue());

    public static List<SearchNode> findSearchNodes(DOMNode node, String prefix, boolean multiple, SearchNode.Direction direction) {
        int startNode = SearchNodeFactory.getStartNode(node);
        if (startNode == -1) {
            return Collections.emptyList();
        }
        int endNode = SearchNodeFactory.getEndNode(node);
        if (endNode == -1) {
            return Collections.emptyList();
        }
        if (multiple) {
            String text = node.getOwnerDocument().getText();
            ArrayList<SearchNode> searchNodes = new ArrayList<SearchNode>();
            int itemStart = -1;
            for (int j = startNode; j < endNode; ++j) {
                char c = text.charAt(j);
                if (itemStart == -1) {
                    if (Character.isWhitespace(c)) continue;
                    itemStart = j;
                    continue;
                }
                if (!Character.isWhitespace(c)) continue;
                searchNodes.add(new SearchNode(itemStart, j, node, prefix, direction));
                itemStart = -1;
            }
            if (itemStart != -1) {
                searchNodes.add(new SearchNode(itemStart, endNode, node, prefix, direction));
            }
            return searchNodes;
        }
        return Arrays.asList(new SearchNode(startNode, endNode, node, prefix, direction));
    }

    public static SearchNode getSearchNodeAt(DOMNode node, int offset, String prefix, boolean multiple, SearchNode.Direction direction) {
        int startNode = SearchNodeFactory.getStartNode(node);
        if (startNode == -1) {
            return null;
        }
        int endNode = SearchNodeFactory.getEndNode(node);
        if (endNode == -1) {
            return null;
        }
        if (multiple) {
            String text = node.getOwnerDocument().getText();
            if (offset != startNode) {
                int left = StringUtils.findStartWord(text, offset, startNode, NAME_PREDICATE);
                startNode = left != -1 ? left : ((left = StringUtils.findStartWord(text, offset - 1, startNode, NAME_PREDICATE)) != -1 ? left : offset);
            }
            if (offset != endNode - 1) {
                int right = StringUtils.findEndWord(text, offset, endNode, NAME_PREDICATE);
                endNode = right != -1 ? right : offset;
            }
        }
        return new SearchNode(startNode, endNode, node, prefix, direction);
    }

    private static int getStartNode(DOMNode node) {
        DOMRange range = SearchNodeFactory.getDOMRange(node);
        if (range == null) {
            return -1;
        }
        return range.getStart() + (node.isAttribute() ? 1 : 0);
    }

    private static int getEndNode(DOMNode node) {
        DOMRange range = SearchNodeFactory.getDOMRange(node);
        if (range == null) {
            return -1;
        }
        return range.getEnd() - (node.isAttribute() ? 1 : 0);
    }

    private static DOMRange getDOMRange(DOMNode node) {
        if (node.isAttribute()) {
            DOMAttr attr = (DOMAttr)node;
            return attr.getNodeAttrValue();
        }
        return node;
    }
}

