/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.debug.core.model;

import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.statet.internal.r.debug.core.model.RElementVariableProxy;
import org.eclipse.statet.internal.r.debug.core.model.RValueProxy;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.r.debug.core.IRDebugTarget;
import org.eclipse.statet.r.debug.core.IRElementVariable;
import org.eclipse.statet.r.debug.core.IRValue;
import org.eclipse.statet.r.debug.core.IRVariable;

@NonNullByDefault
public class RVariableProxy
implements IRVariable {
    protected final IRVariable variable;
    protected final IRVariable parent;

    public static RVariableProxy create(IRVariable variable, IRVariable parent) {
        if (variable instanceof IRElementVariable) {
            return new RElementVariableProxy((IRElementVariable)variable, parent);
        }
        return new RVariableProxy(variable, parent);
    }

    public static @Nullable Object unproxy(@Nullable Object obj) {
        if (obj instanceof RVariableProxy) {
            return ((RVariableProxy)obj).variable;
        }
        return obj;
    }

    protected RVariableProxy(IRVariable variable, IRVariable parent) {
        this.variable = variable;
        this.parent = parent;
    }

    public final String getModelIdentifier() {
        return this.variable.getModelIdentifier();
    }

    @Override
    public final IRDebugTarget getDebugTarget() {
        return this.variable.getDebugTarget();
    }

    public final ILaunch getLaunch() {
        return this.variable.getLaunch();
    }

    @Override
    public final @Nullable IRVariable getParent() {
        return this.parent;
    }

    @Override
    public final String getName() {
        return this.variable.getName();
    }

    @Override
    public final String getReferenceTypeName() throws DebugException {
        return this.variable.getReferenceTypeName();
    }

    public final boolean hasValueChanged() throws DebugException {
        return this.variable.hasValueChanged();
    }

    @Override
    public final IRValue getValue() throws DebugException {
        return RValueProxy.create(this.variable.getValue(), this);
    }

    @Override
    public final boolean supportsValueModification() {
        return this.variable.supportsValueModification();
    }

    @Override
    public final boolean verifyValue(String expression) throws DebugException {
        return this.variable.verifyValue(expression);
    }

    public final boolean verifyValue(IValue value) throws DebugException {
        return this.variable.verifyValue(value);
    }

    @Override
    public final void setValue(String expression) throws DebugException {
        this.variable.setValue(expression);
    }

    public final void setValue(IValue value) throws DebugException {
        this.variable.setValue(value);
    }

    @Override
    public <T> @Nullable T getAdapter(Class<T> type) {
        return this.variable.getAdapter(type);
    }

    public final int hashCode() {
        return this.variable.hashCode();
    }

    public final boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        return this.variable.equals(obj);
    }

    public final String toString() {
        return this.variable.toString();
    }
}

