/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.ast.core.util;

import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.ltk.ast.core.AstNode;
import org.eclipse.statet.ltk.ast.core.AstVisitor;

@NonNullByDefault
public class AstPrinter
implements AstVisitor {
    protected final Writer writer;
    private @Nullable String text;
    private int level;
    private final int maxFragmentSize = 25;

    public AstPrinter(Writer writer) {
        this.writer = writer;
    }

    public Writer getWriter() {
        return this.writer;
    }

    public void print(AstNode node, String text) throws IOException {
        try {
            try {
                this.level = 0;
                this.text = text;
                node.accept(this);
            }
            catch (InvocationTargetException e) {
                throw (IOException)e.getCause();
            }
        }
        finally {
            this.text = null;
        }
    }

    @Override
    public void visit(AstNode node) throws InvocationTargetException {
        try {
            this.printIdent(this.level);
            this.writer.append('[');
            this.writer.append(Integer.toString(node.getStartOffset()));
            this.writer.append(", ");
            this.writer.append(Integer.toString(node.getEndOffset()));
            this.writer.append(") ");
            this.printNodeInfo(node);
            this.printFragment(node.getStartOffset(), node.getEndOffset());
            this.writer.append('\n');
            ++this.level;
            node.acceptInChildren(this);
            --this.level;
        }
        catch (IOException e) {
            throw new InvocationTargetException(e);
        }
    }

    protected void printIdent(int depth) throws IOException {
        int i = 0;
        while (i < depth) {
            this.writer.write("    ");
            ++i;
        }
    }

    protected void printNodeInfo(AstNode node) throws IOException {
        this.writer.append(node.getClass().getSimpleName());
    }

    protected void printFragment(int startOffset, int endOffset) throws IOException {
        String text = this.text;
        if (text != null && 25 > 0) {
            this.writer.write(": ");
            int l = endOffset - startOffset;
            if (l <= 25) {
                this.writeEncoded(text, startOffset, l);
            } else if (25 < 13) {
                this.writeEncoded(text, startOffset, 25 - 3);
                this.writer.write(" ... ");
            } else {
                l = (25 - 3) / 2;
                this.writeEncoded(text, startOffset, l);
                this.writer.write(" ... ");
                this.writeEncoded(text, endOffset - l, l);
            }
        }
    }

    private void writeEncoded(String s, int begin, int length) throws IOException {
        int end = begin + length;
        int i = begin;
        while (i < end) {
            if (i < 0) {
                this.writer.write("<E: out of bounds>");
                i = 0;
            } else if (i >= s.length()) {
                this.writer.write("<E: out of bounds>");
                return;
            }
            char c = s.charAt(i);
            if (c < '\u0010') {
                this.writer.write("<0x0");
                this.writer.write(Integer.toHexString(c));
                this.writer.write(62);
            } else if (c < ' ') {
                this.writer.write("<0x");
                this.writer.write(Integer.toHexString(c));
                this.writer.write(62);
            } else {
                this.writer.write(c);
            }
            ++i;
        }
    }
}

