/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.docmlet.wikitext.core.ast;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.statet.docmlet.wikitext.core.ast.Label;
import org.eclipse.statet.docmlet.wikitext.core.ast.NodeType;
import org.eclipse.statet.docmlet.wikitext.core.ast.WikitextAstNode;
import org.eclipse.statet.docmlet.wikitext.core.ast.WikitextAstVisitor;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.ltk.ast.core.AstNode;
import org.eclipse.statet.ltk.ast.core.AstVisitor;

@NonNullByDefault
public abstract class Image
extends WikitextAstNode {
    public static final byte COMMON = 0;
    public static final byte SRC_BY_REF = 2;
    private final byte linkType;
    private final @Nullable String uri;

    private Image(WikitextAstNode parent, int startOffset, int endOffset, byte linkType, @Nullable String uri) {
        super(parent, startOffset, endOffset);
        this.linkType = linkType;
        this.uri = uri;
    }

    private Image(WikitextAstNode parent, int startOffset, String uri) {
        super(parent, startOffset, startOffset);
        this.linkType = 0;
        this.uri = uri;
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.LINK;
    }

    public boolean hasChildren() {
        return false;
    }

    public int getChildCount() {
        return 0;
    }

    @Override
    public WikitextAstNode getChild(int index) {
        throw new IndexOutOfBoundsException();
    }

    public int getChildIndex(AstNode element) {
        return -1;
    }

    public void acceptInChildren(AstVisitor visitor) throws InvocationTargetException {
    }

    @Override
    public void acceptInWikitext(WikitextAstVisitor visitor) throws InvocationTargetException {
        visitor.visit(this);
    }

    @Override
    public void acceptInWikitextChildren(WikitextAstVisitor visitor) throws InvocationTargetException {
    }

    public byte getImageType() {
        return this.linkType;
    }

    public String getUri() {
        return this.uri;
    }

    public abstract Label getReferenceLabel();

    /* synthetic */ Image(WikitextAstNode wikitextAstNode, int n, int n2, byte by, String string, Image image) {
        this(wikitextAstNode, n, n2, by, string);
    }

    static final class Common
    extends Image {
        Common(WikitextAstNode parent, int startOffset, int endOffset, byte linkType, String href) {
            super(parent, startOffset, endOffset, linkType, href, null);
        }

        @Override
        public @Nullable Label getReferenceLabel() {
            return null;
        }
    }

    static final class Ref
    extends Image {
        private final Label referenceLabel;

        Ref(WikitextAstNode parent, int startOffset, int endOffset, byte linkType, Label referenceLabel) {
            super(parent, startOffset, endOffset, linkType, null, null);
            referenceLabel.parent = this;
            this.referenceLabel = (Label)((Object)ObjectUtils.nonNullAssert((Object)((Object)referenceLabel)));
        }

        @Override
        public boolean hasChildren() {
            return true;
        }

        @Override
        public int getChildCount() {
            return 1;
        }

        @Override
        public WikitextAstNode getChild(int index) {
            if (index == 0) {
                return this.referenceLabel;
            }
            throw new IndexOutOfBoundsException(Integer.toString(index));
        }

        @Override
        public int getChildIndex(AstNode element) {
            if (this.referenceLabel == element) {
                return 0;
            }
            return -1;
        }

        @Override
        public Label getReferenceLabel() {
            return this.referenceLabel;
        }

        @Override
        public void acceptInChildren(AstVisitor visitor) throws InvocationTargetException {
            this.referenceLabel.accept(visitor);
        }

        @Override
        public void acceptInWikitextChildren(WikitextAstVisitor visitor) throws InvocationTargetException {
            this.referenceLabel.acceptInWikitext(visitor);
        }
    }
}

