/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.docmlet.wikitext.commonmark.core;

import java.util.regex.Matcher;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.Line;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.TextSegment;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.ObjectUtils;

@NonNullByDefault
public class Cursor {
    private final TextSegment segment;
    private final String text;
    private int textOffset;

    public Cursor(TextSegment segment) {
        this.segment = (TextSegment)ObjectUtils.nonNullAssert((Object)segment);
        this.text = segment.getText();
        this.textOffset = 0;
    }

    public int getOffset() {
        return this.segment.toOffset(this.textOffset);
    }

    public int getOffset(int offset) {
        return this.segment.toOffset(this.textOffset + offset);
    }

    public int toCursorOffset(int documentOffset) {
        return this.segment.toTextOffset(documentOffset);
    }

    public char getChar() {
        return this.text.charAt(this.textOffset);
    }

    public char getChar(int offset) {
        return this.text.charAt(offset);
    }

    public boolean hasChar() {
        return this.textOffset < this.text.length();
    }

    public String getText(int offset, int endIndex) {
        return this.text.substring(offset, endIndex);
    }

    public char getPrevious() {
        return this.getPrevious(1);
    }

    public boolean hasPrevious() {
        return this.textOffset - 1 >= 0;
    }

    public boolean hasPrevious(int offset) {
        if (offset <= 0) {
            throw new IllegalArgumentException();
        }
        return this.textOffset - offset >= 0;
    }

    public char getPrevious(int offset) {
        if (offset <= 0) {
            throw new IllegalArgumentException();
        }
        int charOffset = this.textOffset - offset;
        return this.text.charAt(charOffset);
    }

    public boolean hasNext() {
        return this.textOffset + 1 < this.text.length();
    }

    public boolean hasNext(int offset) {
        if (offset <= 0) {
            throw new IllegalArgumentException();
        }
        return this.textOffset + offset < this.text.length();
    }

    public char getNext() {
        return this.getNext(1);
    }

    public char getNext(int offset) {
        if (offset <= 0) {
            throw new IllegalArgumentException();
        }
        return this.text.charAt(this.textOffset + offset);
    }

    public int getRemaining() {
        return this.text.length() - this.textOffset;
    }

    public String getTextAtOffset() {
        return this.text.substring(this.textOffset, this.text.length());
    }

    public String getTextAtOffset(int start, int end) {
        return this.text.substring(this.textOffset + start, this.textOffset + end);
    }

    public void advance() {
        if (this.textOffset < this.text.length()) {
            ++this.textOffset;
        }
    }

    public void advance(int count) {
        if (count < 0) {
            throw new IllegalArgumentException("count= " + count);
        }
        int x = 0;
        while (x < count) {
            this.advance();
            ++x;
        }
    }

    public void rewind(int count) {
        if (count < 0) {
            throw new IllegalArgumentException("count= " + count);
        }
        int x = 0;
        while (x < count) {
            this.rewind();
            ++x;
        }
    }

    public void rewind() {
        if (this.textOffset > 0) {
            --this.textOffset;
        }
    }

    public Line getLineAtOffset() {
        return this.segment.getLineAtOffset(this.textOffset);
    }

    public Matcher setup(Matcher matcher) {
        matcher.reset(this.text);
        matcher.region(this.textOffset, this.text.length());
        return matcher;
    }

    public Matcher setup(Matcher matcher, int offset) {
        matcher.reset(this.text);
        matcher.region(this.textOffset + offset, this.text.length());
        return matcher;
    }

    public int getMatcherOffset(int matchOffset) {
        return this.segment.toOffset(matchOffset);
    }
}

