/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.interpreter.internal.optional.debug;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.debug.ui.IDebugView;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.sirius.ui.interpreter.internal.view.Variable;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public final class DebugViewHelper {
    private DebugViewHelper() {
    }

    public static List<Variable> getCurrentDebugThreadVariables() {
        ISelection threadSelection;
        IDebugView debugView = DebugViewHelper.getDebugView();
        if (debugView != null && !(threadSelection = debugView.getViewer().getSelection()).isEmpty() && threadSelection instanceof IStructuredSelection && ((IStructuredSelection)threadSelection).getFirstElement() instanceof IStackFrame) {
            IStackFrame frame = (IStackFrame)((IStructuredSelection)threadSelection).getFirstElement();
            try {
                return DebugViewHelper.convertToInterpreterVariables(frame.getVariables());
            }
            catch (DebugException debugException) {}
        }
        return new ArrayList<Variable>();
    }

    private static List<Variable> convertToInterpreterVariables(IVariable[] debugVariables) {
        ArrayList<Variable> interpreterVariables = new ArrayList<Variable>();
        if (debugVariables != null && debugVariables.length != 0) {
            int i = 0;
            while (i < debugVariables.length) {
                Variable variable = (Variable)debugVariables[i].getAdapter(Variable.class);
                if (variable != null) {
                    interpreterVariables.add(variable);
                }
                ++i;
            }
        }
        return interpreterVariables;
    }

    private static IDebugView getDebugView() {
        IWorkbenchWindow workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (workbenchWindow != null && workbenchWindow.getActivePage() != null) {
            IViewReference[] iViewReferenceArray = workbenchWindow.getActivePage().getViewReferences();
            int n = iViewReferenceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IViewReference viewReference = iViewReferenceArray[n2];
                IViewPart viewPart = viewReference.getView(false);
                if (viewPart instanceof IDebugView && DebugViewHelper.isAvailable((IDebugView)viewPart)) {
                    return (IDebugView)viewPart;
                }
                ++n2;
            }
        }
        return null;
    }

    private static boolean isAvailable(IDebugView debugView) {
        Viewer viewer = debugView.getViewer();
        return viewer != null && viewer.getControl() != null && !viewer.getControl().isDisposed();
    }
}

