/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.model.siteplan;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum TrackType implements Enumerator
{
    NONE(0, "None", "None"),
    MAIN_TRACK(2, "MainTrack", "MainTrack"),
    SIDE_TRACK(4, "SideTrack", "SideTrack"),
    CONNECTING_TRACK(5, "ConnectingTrack", "ConnectingTrack"),
    ROUTE_TRACK(3, "RouteTrack", "RouteTrack"),
    OTHER(6, "Other", "Other"),
    PASSING_MAIN_TRACK(1, "PassingMainTrack", "PassingMainTrack");

    public static final int NONE_VALUE = 0;
    public static final int MAIN_TRACK_VALUE = 2;
    public static final int SIDE_TRACK_VALUE = 4;
    public static final int CONNECTING_TRACK_VALUE = 5;
    public static final int ROUTE_TRACK_VALUE = 3;
    public static final int OTHER_VALUE = 6;
    public static final int PASSING_MAIN_TRACK_VALUE = 1;
    private static final TrackType[] VALUES_ARRAY;
    public static final List<TrackType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new TrackType[]{NONE, MAIN_TRACK, SIDE_TRACK, CONNECTING_TRACK, ROUTE_TRACK, OTHER, PASSING_MAIN_TRACK};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static TrackType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            TrackType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static TrackType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            TrackType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static TrackType get(int value) {
        switch (value) {
            case 0: {
                return NONE;
            }
            case 2: {
                return MAIN_TRACK;
            }
            case 4: {
                return SIDE_TRACK;
            }
            case 5: {
                return CONNECTING_TRACK;
            }
            case 3: {
                return ROUTE_TRACK;
            }
            case 6: {
                return OTHER;
            }
            case 1: {
                return PASSING_MAIN_TRACK;
            }
        }
        return null;
    }

    private TrackType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

