/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.core.fileservice;

import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.set.model.planpro.Basisobjekte.Identitaet_TypeClass;
import org.eclipse.set.model.planpro.Basisobjekte.Ur_Objekt;
import org.eclipse.set.model.planpro.Layoutinformationen.PlanPro_Layoutinfo;
import org.eclipse.set.model.planpro.PlanPro.Ausgabe_Fachdaten;
import org.eclipse.set.model.planpro.PlanPro.Container_AttributeGroup;
import org.eclipse.set.model.planpro.PlanPro.Fachdaten_AttributeGroup;
import org.eclipse.set.model.planpro.PlanPro.LST_Planung_AttributeGroup;
import org.eclipse.set.model.planpro.PlanPro.LST_Zustand;
import org.eclipse.set.model.planpro.PlanPro.PlanPro_Schnittstelle;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class GuidCache {
    private final Map<String, EObject> globalGuidToObjectMap = new HashMap<String, EObject>();
    private final Map<String, EObject> singleGuidToObjectMap = new HashMap<String, EObject>();
    private final Map<String, EObject> initialGuidToObjectMap = new HashMap<String, EObject>();
    private final Map<String, EObject> planningGuidToObjectMap = new HashMap<String, EObject>();
    private final Map<String, EObject> layoutGuidToObjectMap = new HashMap<String, EObject>();

    public EObject get(String guid, EObject source) {
        ContainerType container = this.getContainerType(source);
        if (container != null) {
            switch (container) {
                case Initial: {
                    return this.initialGuidToObjectMap.get(guid);
                }
                case Planning: {
                    return this.planningGuidToObjectMap.get(guid);
                }
                case Single: {
                    return this.singleGuidToObjectMap.get(guid);
                }
                case Global: {
                    return this.globalGuidToObjectMap.get(guid);
                }
                case Layout: {
                    return this.layoutGuidToObjectMap.get(guid);
                }
            }
            return null;
        }
        return null;
    }

    public void prepare(PlanPro_Schnittstelle planProSchnittstelle) {
        this.prepare(planProSchnittstelle, ContainerType.Global, this.globalGuidToObjectMap);
        this.prepare(planProSchnittstelle, ContainerType.Single, this.singleGuidToObjectMap);
        this.prepare(planProSchnittstelle, ContainerType.Initial, this.initialGuidToObjectMap);
        this.prepare(planProSchnittstelle, ContainerType.Planning, this.planningGuidToObjectMap);
    }

    public void prepare(PlanPro_Layoutinfo layout) {
        this.prepare(layout, this.layoutGuidToObjectMap);
    }

    private void prepare(PlanPro_Layoutinfo layout, Map<String, EObject> map) {
        List _filter;
        Iterable<Ur_Objekt> _commonObjects = this.getCommonObjects((EObject)layout);
        List _elvis = null;
        TreeIterator _eAllContents = null;
        if (layout != null) {
            _eAllContents = layout.eAllContents();
        }
        _elvis = (_filter = Iterables.filter((Iterable)IteratorExtensions.toList(_eAllContents), Ur_Objekt.class)) != null ? _filter : Collections.unmodifiableList(CollectionLiterals.newArrayList());
        Consumer<Ur_Objekt> _function = it -> {
            Identitaet_TypeClass _identitaet = null;
            if (it != null) {
                _identitaet = it.getIdentitaet();
            }
            String _wert = null;
            if (_identitaet != null) {
                _wert = _identitaet.getWert();
            }
            map.put(_wert, (EObject)it);
        };
        Iterables.concat(_commonObjects, _elvis).forEach(_function);
    }

    private void prepare(PlanPro_Schnittstelle planProSchnittstelle, ContainerType containerType, Map<String, EObject> map) {
        Iterable<Ur_Objekt> _commonObjects = this.getCommonObjects((EObject)planProSchnittstelle);
        Iterable<Object> _elvis = null;
        Iterable<Ur_Objekt> _objectList = this.getObjectList(planProSchnittstelle, containerType);
        _elvis = _objectList != null ? _objectList : Collections.unmodifiableList(CollectionLiterals.newArrayList());
        Consumer<Ur_Objekt> _function = it -> {
            Identitaet_TypeClass _identitaet = null;
            if (it != null) {
                _identitaet = it.getIdentitaet();
            }
            String _wert = null;
            if (_identitaet != null) {
                _wert = _identitaet.getWert();
            }
            map.put(_wert, (EObject)it);
        };
        Iterables.concat(_commonObjects, _elvis).forEach(_function);
    }

    private Iterable<Ur_Objekt> getObjectList(PlanPro_Schnittstelle planProSchnittstelle, ContainerType containerType) {
        if (containerType != null) {
            switch (containerType) {
                case Single: {
                    LST_Zustand _lSTZustand = null;
                    if (planProSchnittstelle != null) {
                        _lSTZustand = planProSchnittstelle.getLSTZustand();
                    }
                    Container_AttributeGroup _container = null;
                    if (_lSTZustand != null) {
                        _container = _lSTZustand.getContainer();
                    }
                    EList _eContents = null;
                    if (_container != null) {
                        _eContents = _container.eContents();
                    }
                    Iterable _filter = null;
                    if (_eContents != null) {
                        _filter = Iterables.filter((Iterable)_eContents, Ur_Objekt.class);
                    }
                    return _filter;
                }
                case Planning: {
                    LST_Planung_AttributeGroup _lSTPlanung = null;
                    if (planProSchnittstelle != null) {
                        _lSTPlanung = planProSchnittstelle.getLSTPlanung();
                    }
                    Fachdaten_AttributeGroup _fachdaten = null;
                    if (_lSTPlanung != null) {
                        _fachdaten = _lSTPlanung.getFachdaten();
                    }
                    EList _ausgabeFachdaten = null;
                    if (_fachdaten != null) {
                        _ausgabeFachdaten = _fachdaten.getAusgabeFachdaten();
                    }
                    List _map = null;
                    if (_ausgabeFachdaten != null) {
                        Functions.Function1 _function = it -> {
                            LST_Zustand _lSTZustandZiel = it.getLSTZustandZiel();
                            Container_AttributeGroup _container_1 = null;
                            if (_lSTZustandZiel != null) {
                                _container_1 = _lSTZustandZiel.getContainer();
                            }
                            return _container_1;
                        };
                        _map = ListExtensions.map((List)_ausgabeFachdaten, (Functions.Function1)_function);
                    }
                    Iterable _filterNull = null;
                    if (_map != null) {
                        _filterNull = IterableExtensions.filterNull((Iterable)_map);
                    }
                    Iterable _flatMap = null;
                    if (_filterNull != null) {
                        Functions.Function1 _function_1 = it -> it.eContents();
                        _flatMap = IterableExtensions.flatMap((Iterable)_filterNull, (Functions.Function1)_function_1);
                    }
                    Iterable _filter_1 = null;
                    if (_flatMap != null) {
                        _filter_1 = Iterables.filter((Iterable)_flatMap, Ur_Objekt.class);
                    }
                    return _filter_1;
                }
                case Initial: {
                    LST_Planung_AttributeGroup _lSTPlanung_1 = null;
                    if (planProSchnittstelle != null) {
                        _lSTPlanung_1 = planProSchnittstelle.getLSTPlanung();
                    }
                    Fachdaten_AttributeGroup _fachdaten_1 = null;
                    if (_lSTPlanung_1 != null) {
                        _fachdaten_1 = _lSTPlanung_1.getFachdaten();
                    }
                    EList _ausgabeFachdaten_1 = null;
                    if (_fachdaten_1 != null) {
                        _ausgabeFachdaten_1 = _fachdaten_1.getAusgabeFachdaten();
                    }
                    List _map_1 = null;
                    if (_ausgabeFachdaten_1 != null) {
                        Functions.Function1 _function_2 = it -> {
                            LST_Zustand _lSTZustandStart = it.getLSTZustandStart();
                            Container_AttributeGroup _container_1 = null;
                            if (_lSTZustandStart != null) {
                                _container_1 = _lSTZustandStart.getContainer();
                            }
                            return _container_1;
                        };
                        _map_1 = ListExtensions.map((List)_ausgabeFachdaten_1, (Functions.Function1)_function_2);
                    }
                    Iterable _filterNull_1 = null;
                    if (_map_1 != null) {
                        _filterNull_1 = IterableExtensions.filterNull((Iterable)_map_1);
                    }
                    Iterable _flatMap_1 = null;
                    if (_filterNull_1 != null) {
                        Functions.Function1 _function_3 = it -> it.eContents();
                        _flatMap_1 = IterableExtensions.flatMap((Iterable)_filterNull_1, (Functions.Function1)_function_3);
                    }
                    Iterable _filter_2 = null;
                    if (_flatMap_1 != null) {
                        _filter_2 = Iterables.filter((Iterable)_flatMap_1, Ur_Objekt.class);
                    }
                    return _filter_2;
                }
                case Global: {
                    LST_Planung_AttributeGroup _lSTPlanung_2 = null;
                    if (planProSchnittstelle != null) {
                        _lSTPlanung_2 = planProSchnittstelle.getLSTPlanung();
                    }
                    Fachdaten_AttributeGroup _fachdaten_2 = null;
                    if (_lSTPlanung_2 != null) {
                        _fachdaten_2 = _lSTPlanung_2.getFachdaten();
                    }
                    EList _ausgabeFachdaten_2 = null;
                    if (_fachdaten_2 != null) {
                        _ausgabeFachdaten_2 = _fachdaten_2.getAusgabeFachdaten();
                    }
                    Iterable _flatMap_2 = null;
                    if (_ausgabeFachdaten_2 != null) {
                        Functions.Function1 _function_4 = it -> {
                            LST_Zustand _lSTZustandStart = it.getLSTZustandStart();
                            LST_Zustand _lSTZustandZiel = it.getLSTZustandZiel();
                            Functions.Function1 _function_5 = it_1 -> it_1.getContainer();
                            Functions.Function1 _function_6 = it_1 -> it_1.eContents();
                            return IterableExtensions.flatMap((Iterable)IterableExtensions.filterNull((Iterable)ListExtensions.map(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new LST_Zustand[]{_lSTZustandStart, _lSTZustandZiel})), (Functions.Function1)_function_5)), (Functions.Function1)_function_6);
                        };
                        _flatMap_2 = IterableExtensions.flatMap((Iterable)_ausgabeFachdaten_2, (Functions.Function1)_function_4);
                    }
                    Iterable _filter_3 = null;
                    if (_flatMap_2 != null) {
                        _filter_3 = Iterables.filter((Iterable)_flatMap_2, Ur_Objekt.class);
                    }
                    return _filter_3;
                }
                case Layout: {
                    return null;
                }
            }
        }
        return null;
    }

    private Iterable<Ur_Objekt> getCommonObjects(EObject object) {
        if (object instanceof Container_AttributeGroup) {
            return Collections.unmodifiableList(CollectionLiterals.newArrayList());
        }
        if (!(object instanceof Ur_Objekt)) {
            Functions.Function1 _function = it -> this.getCommonObjects((EObject)it);
            return IterableExtensions.flatMap((Iterable)object.eContents(), (Functions.Function1)_function);
        }
        Functions.Function1 _function_1 = it -> this.getCommonObjects((EObject)it);
        Iterable _flatMap = IterableExtensions.flatMap((Iterable)object.eContents(), (Functions.Function1)_function_1);
        return Iterables.concat(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new Ur_Objekt[]{(Ur_Objekt)object})), (Iterable)_flatMap);
    }

    private ContainerType getContainerType(EObject referenceObject) {
        boolean _tripleEquals_1;
        boolean _tripleEquals;
        if (referenceObject == null) {
            return ContainerType.Global;
        }
        if (referenceObject instanceof PlanPro_Layoutinfo) {
            return ContainerType.Layout;
        }
        if (!(referenceObject instanceof Container_AttributeGroup)) {
            return this.getContainerType(referenceObject.eContainer());
        }
        EObject lstState = referenceObject.eContainer();
        EObject lstStateContainer = lstState.eContainer();
        if (!(lstStateContainer instanceof Ausgabe_Fachdaten)) {
            return ContainerType.Single;
        }
        Ausgabe_Fachdaten ausgabeFachdaten = (Ausgabe_Fachdaten)lstStateContainer;
        LST_Zustand _lSTZustandStart = ausgabeFachdaten.getLSTZustandStart();
        boolean bl = _tripleEquals = _lSTZustandStart == lstState;
        if (_tripleEquals) {
            return ContainerType.Initial;
        }
        LST_Zustand _lSTZustandZiel = ausgabeFachdaten.getLSTZustandZiel();
        boolean bl2 = _tripleEquals_1 = _lSTZustandZiel == lstState;
        if (_tripleEquals_1) {
            return ContainerType.Planning;
        }
        return ContainerType.Layout;
    }

    public static enum ContainerType {
        Single,
        Initial,
        Planning,
        Global,
        Layout;

    }
}

