/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.feature.plazmodel.check;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import org.apache.commons.text.StringSubstitutor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.set.feature.plazmodel.check.AbstractPlazContainerCheck;
import org.eclipse.set.feature.plazmodel.check.PlazCheck;
import org.eclipse.set.model.planpro.Basisobjekte.Identitaet_TypeClass;
import org.eclipse.set.model.planpro.Geodaten.GEO_Kante_Allg_AttributeGroup;
import org.eclipse.set.model.planpro.Geodaten.GEO_Laenge_TypeClass;
import org.eclipse.set.model.planpro.Geodaten.TOP_Kante;
import org.eclipse.set.model.planpro.Geodaten.TOP_Kante_Allg_AttributeGroup;
import org.eclipse.set.model.planpro.Geodaten.TOP_Laenge_TypeClass;
import org.eclipse.set.model.plazmodel.PlazError;
import org.eclipse.set.model.plazmodel.PlazFactory;
import org.eclipse.set.ppmodel.extensions.TopKanteExtensions;
import org.eclipse.set.ppmodel.extensions.container.MultiContainer_AttributeGroup;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.osgi.service.component.annotations.Component;

@Component
public class TopGeoCoverage
extends AbstractPlazContainerCheck
implements PlazCheck {
    private double LENGTH_LIMIT = 0.01;

    @Override
    public List<PlazError> run(MultiContainer_AttributeGroup container) {
        Functions.Function1 _function = it -> {
            TOP_Kante_Allg_AttributeGroup _tOPKanteAllg = it.getTOPKanteAllg();
            TOP_Laenge_TypeClass _tOPLaenge = null;
            if (_tOPKanteAllg != null) {
                _tOPLaenge = _tOPKanteAllg.getTOPLaenge();
            }
            BigDecimal _wert = null;
            if (_tOPLaenge != null) {
                _wert = _tOPLaenge.getWert();
            }
            return _wert != null;
        };
        Functions.Function1 _function_1 = it -> {
            Functions.Function1 _function_2 = it_1 -> {
                GEO_Kante_Allg_AttributeGroup _gEOKanteAllg = it_1.getGEOKanteAllg();
                GEO_Laenge_TypeClass _gEOLaenge = null;
                if (_gEOKanteAllg != null) {
                    _gEOLaenge = _gEOKanteAllg.getGEOLaenge();
                }
                BigDecimal _wert = null;
                if (_gEOLaenge != null) {
                    _wert = _gEOLaenge.getWert();
                }
                return _wert;
            };
            Functions.Function2 _function_3 = (a, b) -> a.add((BigDecimal)b);
            BigDecimal geoLength = (BigDecimal)IterableExtensions.reduce((Iterable)IterableExtensions.filterNull((Iterable)ListExtensions.map((List)TopKanteExtensions.getGeoKanten((TOP_Kante)it), (Functions.Function1)_function_2)), (Functions.Function2)_function_3);
            TOP_Kante_Allg_AttributeGroup _tOPKanteAllg = it.getTOPKanteAllg();
            TOP_Laenge_TypeClass _tOPLaenge = null;
            if (_tOPKanteAllg != null) {
                _tOPLaenge = _tOPKanteAllg.getTOPLaenge();
            }
            BigDecimal _wert = null;
            if (_tOPLaenge != null) {
                _wert = _tOPLaenge.getWert();
            }
            BigDecimal topLength = _wert;
            if (geoLength == null || topLength == null) {
                return null;
            }
            double diff = topLength.subtract(geoLength).doubleValue();
            if (diff < -this.LENGTH_LIMIT) {
                return this.createError((TOP_Kante)it, "Die topologische Kante {GUID} (L\u00e4nge: {TOP_LENGTH}) ist k\u00fcrzer als die dazu geh\u00f6rigen geographischen Kanten (L\u00e4nge: {GEO_LENGTH}).", topLength, geoLength);
            }
            if (diff > this.LENGTH_LIMIT) {
                return this.createError((TOP_Kante)it, "Die topologische Kante {GUID} (L\u00e4nge: {TOP_LENGTH}) ist l\u00e4nger als die dazu geh\u00f6rigen geographischen Kanten (L\u00e4nge: {GEO_LENGTH}).", topLength, geoLength);
            }
            return null;
        };
        return IterableExtensions.toList((Iterable)IterableExtensions.filterNull((Iterable)IterableExtensions.map((Iterable)IterableExtensions.filter((Iterable)container.getTOPKante(), (Functions.Function1)_function), (Functions.Function1)_function_1)));
    }

    private PlazError createError(TOP_Kante topEdge, String message, BigDecimal topLength, BigDecimal geoLength) {
        PlazError err = PlazFactory.eINSTANCE.createPlazError();
        Identitaet_TypeClass _identitaet = topEdge.getIdentitaet();
        String _wert = null;
        if (_identitaet != null) {
            _wert = _identitaet.getWert();
        }
        err.setMessage(StringSubstitutor.replace((Object)message, Map.of("GUID", _wert, "TOP_LENGTH", topLength.toString(), "GEO_LENGTH", geoLength.toString()), (String)"{", (String)"}"));
        err.setType(this.checkType());
        TOP_Kante_Allg_AttributeGroup _tOPKanteAllg = null;
        if (topEdge != null) {
            _tOPKanteAllg = topEdge.getTOPKanteAllg();
        }
        TOP_Laenge_TypeClass _tOPLaenge = null;
        if (_tOPKanteAllg != null) {
            _tOPLaenge = _tOPKanteAllg.getTOPLaenge();
        }
        err.setObject((EObject)_tOPLaenge);
        return err;
    }

    @Override
    public String checkType() {
        return "TOP_Kante";
    }

    @Override
    public String getDescription() {
        return "TOP_Kanten und GEO_Kanten haben \u00fcbereinstimmende L\u00e4ngen.";
    }

    @Override
    public String getGeneralErrMsg() {
        return "Es gibt TOP_Kanten/GEO_Kanten mit fehlerhaften L\u00e4ngen.";
    }
}

