/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.gef.core.tools;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.wb.gef.core.EditPart;
import org.eclipse.wb.gef.core.IEditPartViewer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ToolUtilities {
    public static List<EditPart> getSelectionWithoutDependants(IEditPartViewer viewer) {
        ArrayList operationSet = Lists.newArrayList();
        List<EditPart> selectedParts = viewer.getSelectedEditParts();
        for (EditPart part : selectedParts) {
            if (ToolUtilities.isAncestorContainedIn(selectedParts, part)) continue;
            operationSet.add(part);
        }
        EditPart commonParent = null;
        for (EditPart editPart : operationSet) {
            if (commonParent == null) {
                commonParent = editPart.getParent();
                continue;
            }
            if (editPart.getParent() == commonParent) continue;
            return Collections.emptyList();
        }
        return operationSet;
    }

    private static boolean isAncestorContainedIn(List<EditPart> container, EditPart part) {
        EditPart parent = part.getParent();
        while (parent != null) {
            if (container.contains(parent)) {
                return true;
            }
            parent = parent.getParent();
        }
        return false;
    }
}

