/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.xml.editor;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.wb.internal.core.editor.errors.ExceptionComposite;
import org.eclipse.wb.internal.core.editor.errors.report2.IReportEntry;
import org.eclipse.wb.internal.core.editor.errors.report2.StringFileReportEntry;
import org.eclipse.wb.internal.core.editor.errors.report2.ZipFileErrorReport;
import org.eclipse.wb.internal.core.xml.editor.actions.RefreshAction;
import org.eclipse.wb.internal.core.xml.editor.actions.SwitchAction;

public final class XmlExceptionComposite
extends ExceptionComposite {
    private IFile m_file;
    private IDocument m_document;

    public XmlExceptionComposite(Composite parent, int style) {
        super(parent, style);
    }

    protected ZipFileErrorReport getZipFileErrorReport() {
        IProject project = this.m_file.getProject();
        return new ZipFileErrorReport(this.getScreenshotImage(), project, XmlExceptionComposite.getSourceFileReport(this.m_file, this.m_document));
    }

    protected void doShowSource(int sourcePosition) {
        SwitchAction.showSource(sourcePosition);
    }

    protected void doRefresh() {
        new RefreshAction().run();
    }

    private static IReportEntry getSourceFileReport(IFile file, IDocument document) {
        try {
            return new StringFileReportEntry(file.getName(), document.get());
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public void setException(Throwable e, Image screenshot, IFile file, IDocument document) {
        this.m_file = file;
        this.m_document = document;
        this.setException0(e, screenshot);
    }
}

