/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.utils.ast;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ConstructorInvocation;
import org.eclipse.jdt.core.dom.EnumConstantDeclaration;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.Initializer;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NullLiteral;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.TypeParameter;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.wb.internal.core.utils.StringUtilities;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;
import org.eclipse.wb.internal.core.utils.ast.AstNodeUtils;
import org.eclipse.wb.internal.core.utils.ast.DomGenerics;
import org.eclipse.wb.internal.core.utils.ast.binding.BindingContext;
import org.eclipse.wb.internal.core.utils.check.Assert;
import org.eclipse.wb.internal.core.utils.exception.DesignerException;
import org.eclipse.wb.internal.core.utils.jdt.core.CodeUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AstParser {
    public static final String KEY_TYPE_BINDING = "TYPE_BINDING";
    public static final String KEY_METHOD_BINDING = "METHOD_BINDING";
    public static final String KEY_VARIABLE_BINDING = "VARIABLE_BINDING";
    public static final String KEY_IGNORE_THIS_METHOD = "Ignore this method for parsing context";
    private final AstEditor m_editor;
    private final BindingContext m_context;

    AstParser(AstEditor editor) {
        this.m_editor = editor;
        this.m_context = this.m_editor.getBindingContext();
    }

    public Expression parseExpression(int position, String src) throws Exception {
        if ("null".equals(src)) {
            NullLiteral expression = this.getAst().newNullLiteral();
            expression.setSourceRange(position, "null".length());
            return expression;
        }
        String source = "java.lang.System.out.println(" + src + ");";
        ExpressionStatement statement = (ExpressionStatement)this.parseStatement(position, source);
        MethodInvocation invocation = (MethodInvocation)statement.getExpression();
        Expression expression = (Expression)invocation.arguments().get(0);
        SimpleName fakeExpression = this.getAst().newSimpleName("foo");
        DomGenerics.arguments(invocation).set(0, (Expression)fakeExpression);
        AstNodeUtils.moveNode((ASTNode)expression, position);
        return expression;
    }

    public Statement parseStatement(int position, String src) throws Exception {
        String source = "";
        source = String.valueOf(source) + this.getSourceUnitHeader();
        TypeDeclaration typeDeclaration = this.m_editor.getEnclosingType(position);
        source = String.valueOf(source) + this.getClassDeclarationHeader(typeDeclaration);
        source = String.valueOf(source) + this.getOpenConstructorSource(typeDeclaration);
        source = String.valueOf(source) + this.getVisibleVariablesCode(position);
        String anonymousClassSource = this.getAnonymousClassCode(position);
        source = String.valueOf(source) + anonymousClassSource;
        int statementPosition = source.length();
        source = String.valueOf(source) + src;
        if (!StringUtils.isEmpty((String)anonymousClassSource)) {
            source = String.valueOf(source) + "}};\n";
        }
        source = String.valueOf(source) + "}\n";
        source = String.valueOf(source) + "}";
        try {
            return (Statement)this.findNode(source, position, Statement.class, statementPosition);
        }
        catch (DesignerException e) {
            String problems = e.getParameters()[1];
            throw new DesignerException(205, (Throwable)e, new String[]{src, problems});
        }
    }

    public BodyDeclaration parseBodyDeclaration(int position, String src) throws Exception {
        String source = this.m_editor.getSource();
        source = String.valueOf(source.substring(0, position)) + src + source.substring(position);
        try {
            return (BodyDeclaration)this.findNode(source, position, BodyDeclaration.class, position);
        }
        catch (DesignerException e) {
            String problems = e.getParameters()[1];
            throw new DesignerException(205, (Throwable)e, new String[]{src, problems});
        }
    }

    public ImportDeclaration parseImportDeclaration(int position, String qualifiedName) throws Exception {
        String source = "import " + qualifiedName + ";";
        source = String.valueOf(source) + "class Clazz {}";
        return (ImportDeclaration)this.findNode(source, position, ImportDeclaration.class, 0);
    }

    public Type parseQualifiedType(int position, String name) throws Exception {
        VariableDeclarationStatement statement = (VariableDeclarationStatement)this.parseStatement(position, String.valueOf(name) + " __parseName;");
        Type type = statement.getType();
        statement.setType((Type)type.getAST().newPrimitiveType(PrimitiveType.VOID));
        return type;
    }

    public Type parseType(int position, Type sourceType) throws Exception {
        PrimitiveType newType;
        if (sourceType instanceof PrimitiveType) {
            PrimitiveType primitiveSourceType = (PrimitiveType)sourceType;
            newType = this.getAst().newPrimitiveType(primitiveSourceType.getPrimitiveTypeCode());
            newType.setSourceRange(position, newType.toString().length());
        } else {
            String typeString = this.m_editor.getSource((ASTNode)sourceType);
            Object newTypeName = typeString.indexOf(46) == -1 ? this.parseSimpleName(position, typeString) : this.parseQualifiedName(position, typeString);
            newType = this.getAst().newSimpleType((Name)newTypeName);
            AstNodeUtils.copySourceRange((ASTNode)newType, (ASTNode)newTypeName);
        }
        ITypeBinding sourceTypeBinding = AstNodeUtils.getTypeBinding(sourceType);
        ITypeBinding newTypeBinding = this.m_context.get(sourceTypeBinding);
        newType.setProperty(KEY_TYPE_BINDING, (Object)newTypeBinding);
        return newType;
    }

    public SimpleName parseSimpleName(int position, String identifier) {
        SimpleName simpleName = this.getAst().newSimpleName(identifier);
        simpleName.setSourceRange(position, identifier.length());
        return simpleName;
    }

    public QualifiedName parseQualifiedName(int startPosition, String src) {
        String[] parts = StringUtils.split((String)src, (char)'.');
        Assert.isTrue((parts.length >= 2 ? 1 : 0) != 0);
        Object result = null;
        int currentPosition = startPosition;
        int i = 0;
        while (i < parts.length) {
            String part = parts[i];
            result = result == null ? this.parseSimpleName(currentPosition, part) : this.getAst().newQualifiedName((Name)result, this.parseSimpleName(++currentPosition, part));
            result.setSourceRange(startPosition, (currentPosition += part.length()) - startPosition);
            ++i;
        }
        return (QualifiedName)result;
    }

    public SimpleName parseVariable(int position, String identifier, ITypeBinding declaringClass, ITypeBinding type, boolean field, int modifiers) {
        SimpleName simpleName = this.parseSimpleName(position, identifier);
        simpleName.setProperty(KEY_TYPE_BINDING, (Object)this.m_context.get(type));
        simpleName.setProperty(KEY_VARIABLE_BINDING, (Object)this.m_context.get(identifier, declaringClass, type, field, modifiers));
        return simpleName;
    }

    public SimpleType parseSimpleType(int position, String identifier, ITypeBinding binding) {
        SimpleName simpleName = this.parseSimpleName(position, identifier);
        SimpleType simpleType = this.getAst().newSimpleType((Name)simpleName);
        simpleType.setProperty(KEY_TYPE_BINDING, (Object)this.m_context.get(binding));
        AstNodeUtils.copySourceRange((ASTNode)simpleType, (ASTNode)simpleName);
        return simpleType;
    }

    private String getSourceUnitHeader() throws Exception {
        CompilationUnit unit = this.m_editor.getAstUnit();
        String header = "";
        if (unit.getPackage() != null) {
            header = "package " + unit.getPackage().getName().toString() + ";\n";
        }
        for (ImportDeclaration declaration : DomGenerics.imports(unit)) {
            header = String.valueOf(header) + this.m_editor.getSource((ASTNode)declaration) + "\n";
        }
        return header;
    }

    private String getClassDeclarationHeader(TypeDeclaration typeDeclaration) {
        TypeDeclaration[] innerTypes;
        String source = "";
        ITypeBinding binding = AstNodeUtils.getTypeBinding(typeDeclaration);
        if (binding.isInterface()) {
            source = String.valueOf(source) + "interface ";
        } else {
            if (AstNodeUtils.isAbstract(binding)) {
                source = String.valueOf(source) + "abstract ";
            }
            source = String.valueOf(source) + "class ";
        }
        int nameBegin = AstNodeUtils.getSourceBegin((ASTNode)typeDeclaration.getName());
        int openBrace = this.m_editor.indexOf("{", nameBegin);
        source = String.valueOf(source) + this.m_editor.getSourceBeginEnd(nameBegin, openBrace);
        source = source.trim();
        source = String.valueOf(source) + " {\n";
        TypeDeclaration[] typeDeclarationArray = innerTypes = typeDeclaration.getTypes();
        int n = innerTypes.length;
        int n2 = 0;
        while (n2 < n) {
            TypeDeclaration innerType = typeDeclarationArray[n2];
            if (AstNodeUtils.isStatic((BodyDeclaration)innerType)) {
                source = String.valueOf(source) + "static ";
            }
            source = String.valueOf(source) + this.getClassDeclarationHeader(innerType) + "}\n";
            ++n2;
        }
        FieldDeclaration[] fields = typeDeclaration.getFields();
        typeDeclarationArray = fields;
        n = fields.length;
        n2 = 0;
        while (n2 < n) {
            TypeDeclaration field = typeDeclarationArray[n2];
            if (AstParser.isVisibleType(field.getType())) {
                source = String.valueOf(source) + AstParser.getFieldSourceForParsingContext((FieldDeclaration)field) + "\n";
            }
            ++n2;
        }
        source = String.valueOf(source) + this.getEnumsDeclarations(typeDeclaration);
        MethodDeclaration[] methods = typeDeclaration.getMethods();
        typeDeclarationArray = methods;
        n = methods.length;
        n2 = 0;
        while (n2 < n) {
            TypeDeclaration method = typeDeclarationArray[n2];
            source = String.valueOf(source) + this.getMethodDeclarationSource((MethodDeclaration)method);
            ++n2;
        }
        return source;
    }

    private String getMethodDeclarationSource(MethodDeclaration method) {
        IMethodBinding binding = AstNodeUtils.getMethodBinding(method);
        if (binding == null) {
            return "";
        }
        if (method.getProperty(KEY_IGNORE_THIS_METHOD) == Boolean.TRUE) {
            return "";
        }
        if (binding.isConstructor() && AstParser.isMethodOfTopType(method)) {
            return "";
        }
        String source = "";
        int sourceBegin = this.getMethodDeclarationSourceBegin(method);
        int sourceEnd = method.getBody() != null ? AstNodeUtils.getSourceBegin((ASTNode)method.getBody()) : AstNodeUtils.getSourceEnd((ASTNode)method);
        source = String.valueOf(source) + this.m_editor.getSourceBeginEnd(sourceBegin, sourceEnd);
        source = StringUtilities.normalizeWhitespaces((String)source);
        if (AstNodeUtils.isAbstract(binding)) {
            source = String.valueOf(source) + "\n";
        } else {
            String returnTypeName;
            source = String.valueOf(source) + "{";
            if (binding.isConstructor()) {
                source = String.valueOf(source) + AstParser.getConstructorBodySource(method);
            }
            if (!"void".equals(returnTypeName = AstNodeUtils.getFullyQualifiedName(binding.getReturnType(), false))) {
                source = String.valueOf(source) + "return " + AstParser.getDefaultValue(returnTypeName) + ";";
            }
            source = String.valueOf(source) + "}\n";
        }
        return source;
    }

    private static String getConstructorBodySource(MethodDeclaration method) {
        List<Statement> statements = DomGenerics.statements(method);
        if (!statements.isEmpty()) {
            if (statements.get(0) instanceof SuperConstructorInvocation) {
                SuperConstructorInvocation invocation = (SuperConstructorInvocation)statements.get(0);
                IMethodBinding binding = AstNodeUtils.getSuperBinding(invocation);
                return "super" + AstParser.getMethodArgumentsSource(binding);
            }
            if (statements.get(0) instanceof ConstructorInvocation) {
                ConstructorInvocation invocation = (ConstructorInvocation)statements.get(0);
                IMethodBinding binding = AstNodeUtils.getBinding(invocation);
                return "this" + AstParser.getMethodArgumentsSource(binding);
            }
        }
        return "";
    }

    private static boolean isMethodOfTopType(MethodDeclaration method) {
        ASTNode parentType = method.getParent();
        return parentType.getParent() instanceof CompilationUnit;
    }

    private int getMethodDeclarationSourceBegin(MethodDeclaration method) {
        List<ASTNode> modifiers = DomGenerics.modifiersNodes((BodyDeclaration)method);
        if (!modifiers.isEmpty()) {
            return modifiers.get(0).getStartPosition();
        }
        List<TypeParameter> parameters = DomGenerics.typeParameters(method);
        if (!parameters.isEmpty()) {
            int begin = parameters.get(0).getStartPosition();
            begin = this.m_editor.indexOfCharBackward('<', begin);
            return begin;
        }
        Type type = method.getReturnType2();
        if (type != null) {
            return type.getStartPosition();
        }
        return method.getName().getStartPosition();
    }

    private String getEnumsDeclarations(TypeDeclaration typeDeclaration) {
        String source = "";
        List<EnumDeclaration> enums = DomGenerics.getEnums(typeDeclaration);
        for (EnumDeclaration enumDeclaration : enums) {
            source = String.valueOf(source) + "enum " + enumDeclaration.getName().getIdentifier();
            source = String.valueOf(source) + " {";
            List<ASTNode> enumConstants = DomGenerics.getEnumConstants(enumDeclaration);
            int i = 0;
            while (i < enumConstants.size()) {
                EnumConstantDeclaration declaration = (EnumConstantDeclaration)enumConstants.get(i);
                source = String.valueOf(source) + declaration.getName().getIdentifier();
                source = i == enumConstants.size() - 1 ? String.valueOf(source) + ";" : String.valueOf(source) + ", ";
                ++i;
            }
            source = String.valueOf(source) + "}\n";
        }
        return source;
    }

    private static String getFieldSourceForParsingContext(FieldDeclaration field) {
        String fieldSource = "";
        int modifiers = field.getModifiers();
        if ((modifiers & 8) != 0) {
            fieldSource = String.valueOf(fieldSource) + "static ";
        }
        if ((modifiers & 0x10) != 0) {
            fieldSource = String.valueOf(fieldSource) + "final ";
        }
        String typeName = AstNodeUtils.getFullyQualifiedName(field.getType(), false);
        fieldSource = String.valueOf(fieldSource) + typeName + " ";
        for (VariableDeclarationFragment fragment : DomGenerics.fragments(field)) {
            if (!fieldSource.endsWith(" ")) {
                fieldSource = String.valueOf(fieldSource) + ", ";
            }
            fieldSource = String.valueOf(fieldSource) + fragment.getName().getIdentifier() + "=" + AstParser.getDefaultValue(typeName);
        }
        fieldSource = String.valueOf(fieldSource) + ";";
        return fieldSource;
    }

    private String getOpenConstructorSource(TypeDeclaration typeDeclaration) {
        IMethodBinding[] declaredMethods;
        ITypeBinding typeBinding = AstNodeUtils.getTypeBinding(typeDeclaration);
        ITypeBinding superTypeBinding = typeBinding.getSuperclass();
        String constructorCode = String.valueOf(typeDeclaration.getName().getIdentifier()) + "(Object __wbp_param) {\n";
        try {
            declaredMethods = superTypeBinding.getDeclaredMethods();
        }
        catch (Throwable throwable) {
            declaredMethods = new IMethodBinding[]{};
        }
        IMethodBinding[] iMethodBindingArray = declaredMethods;
        int n = declaredMethods.length;
        int n2 = 0;
        while (n2 < n) {
            IMethodBinding methodBinding = iMethodBindingArray[n2];
            int modifiers = methodBinding.getModifiers();
            if (methodBinding.isConstructor() && (Modifier.isProtected((int)modifiers) || Modifier.isPublic((int)modifiers))) {
                constructorCode = String.valueOf(constructorCode) + "super" + AstParser.getMethodArgumentsSource(methodBinding);
                break;
            }
            ++n2;
        }
        return constructorCode;
    }

    private static String getMethodArgumentsSource(IMethodBinding methodBinding) {
        String source = "(";
        ITypeBinding[] parameterTypes = methodBinding.getParameterTypes();
        int i = 0;
        while (i < parameterTypes.length) {
            ITypeBinding parameterType = parameterTypes[i];
            if (i != 0) {
                source = String.valueOf(source) + ", ";
            }
            String parameterTypeName = AstNodeUtils.getFullyQualifiedName(parameterType, false);
            source = String.valueOf(source) + AstParser.getDefaultValue(parameterTypeName);
            ++i;
        }
        source = String.valueOf(source) + ");";
        return source;
    }

    private String getVisibleVariablesCode(int position) {
        StringBuffer sb = new StringBuffer();
        List<VariableDeclaration> declarations = AstNodeUtils.getVariableDeclarationsVisibleAt((ASTNode)this.m_editor.getAstUnit(), position);
        for (VariableDeclaration declaration : declarations) {
            Type type = null;
            if (declaration instanceof SingleVariableDeclaration) {
                SingleVariableDeclaration parameter = (SingleVariableDeclaration)declaration;
                type = parameter.getType();
            } else if (declaration instanceof VariableDeclarationFragment) {
                VariableDeclarationFragment fragment = (VariableDeclarationFragment)declaration;
                if (fragment.getParent() instanceof FieldDeclaration) continue;
                if (fragment.getParent() instanceof VariableDeclarationStatement) {
                    VariableDeclarationStatement statement = (VariableDeclarationStatement)fragment.getParent();
                    type = statement.getType();
                }
            }
            Assert.isNotNull(type);
            if (!AstParser.isVisibleType(type)) continue;
            ITypeBinding typeBinding = AstNodeUtils.getTypeBinding(type);
            String typeName = AstNodeUtils.getFullyQualifiedName(typeBinding, false);
            sb.append(typeName);
            sb.append(' ');
            sb.append(declaration.getName().getIdentifier());
            sb.append(" = ");
            sb.append(AstParser.getDefaultValue(typeName));
            sb.append(";\n");
        }
        return sb.toString();
    }

    private static boolean isVisibleType(Type type) {
        ITypeBinding fieldTypeBinding = AstNodeUtils.getTypeBinding(type);
        return fieldTypeBinding != null;
    }

    public static String getDefaultValue(String className) {
        if ("boolean".equals(className)) {
            return "false";
        }
        if ("byte".equals(className)) {
            return "(byte)0";
        }
        if ("char".equals(className)) {
            return "'0'";
        }
        if ("short".equals(className)) {
            return "(short)0";
        }
        if ("int".equals(className)) {
            return "0";
        }
        if ("long".equals(className)) {
            return "0L";
        }
        if ("float".equals(className)) {
            return "0.0f";
        }
        if ("double".equals(className)) {
            return "0.0";
        }
        return "(" + className + ") null";
    }

    private String getAnonymousClassCode(int position) {
        ITypeBinding typeBinding;
        ASTNode node = this.m_editor.getEnclosingNode(position);
        Initializer initializer = null;
        AnonymousClassDeclaration declaration = null;
        ClassInstanceCreation creation = null;
        while (node != null) {
            if (initializer != null && declaration != null && node instanceof Statement) break;
            if (initializer == null && node instanceof Initializer) {
                initializer = (Initializer)node;
            }
            if (declaration == null && node instanceof AnonymousClassDeclaration) {
                declaration = (AnonymousClassDeclaration)node;
                creation = (ClassInstanceCreation)declaration.getParent();
            }
            node = node.getParent();
        }
        if (initializer != null && declaration != null && (typeBinding = declaration.resolveBinding().getSuperclass()) != null) {
            String typeName = AstNodeUtils.getFullyQualifiedName(typeBinding, false);
            String argumentsSource = "";
            List<Expression> arguments = DomGenerics.arguments(creation);
            for (Expression argument : arguments) {
                if (!StringUtils.isEmpty((String)argumentsSource)) {
                    argumentsSource = String.valueOf(argumentsSource) + ", ";
                }
                argumentsSource = String.valueOf(argumentsSource) + this.m_editor.getSource((ASTNode)argument);
            }
            return "new " + typeName + "(" + argumentsSource + ") { {";
        }
        return "";
    }

    private CompilationUnit parseCompilationUnit(String source) throws Exception {
        return CodeUtils.parseCompilationUnit(source, this.m_editor.getJavaProject(), "Fake");
    }

    private AST getAst() {
        return this.m_editor.getAstUnit().getAST();
    }

    private ASTNode findNode(String source, int targetPosition, Class<? extends ASTNode> nodeClass, int nodePosition) throws Exception {
        CompilationUnit compilationUnit = this.parseCompilationUnit(source);
        try {
            return this.findNode0(compilationUnit, targetPosition, nodeClass, nodePosition);
        }
        catch (Throwable e) {
            String problemsString = AstParser.getProblemsString(compilationUnit);
            throw new DesignerException(205, e, new String[]{source, problemsString});
        }
    }

    private static String getProblemsString(CompilationUnit compilationUnit) throws Exception {
        StringBuilder problemsString = new StringBuilder();
        IProblem[] iProblemArray = compilationUnit.getProblems();
        int n = iProblemArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProblem problem = iProblemArray[n2];
            if (problem.getID() != 16777541) {
                if (problemsString.length() != 0) {
                    problemsString.append("\r\n");
                }
                problemsString.append("line: ");
                problemsString.append(problem.getSourceLineNumber());
                problemsString.append(" ");
                problemsString.append(problem.getMessage());
            }
            ++n2;
        }
        return problemsString.toString();
    }

    private ASTNode findNode0(CompilationUnit compilationUnit, final int targetPosition, final Class<? extends ASTNode> nodeClass, final int nodePosition) throws Exception {
        final ArrayList nodes = Lists.newArrayList();
        compilationUnit.accept(new ASTVisitor(true){

            public void preVisit(ASTNode node) {
                int pos = node.getStartPosition();
                if (nodes.isEmpty() && pos >= nodePosition && nodeClass.isInstance(node)) {
                    nodes.add(node);
                }
                if (pos >= nodePosition) {
                    int length = node.getLength();
                    node.setSourceRange(targetPosition + pos - nodePosition, length);
                }
            }
        });
        Assert.isTrue((nodes.size() == 1 ? 1 : 0) != 0);
        ASTNode externalNode = (ASTNode)nodes.get(0);
        ASTNode internalNode = ASTNode.copySubtree((AST)this.m_editor.getAstUnit().getAST(), (ASTNode)externalNode);
        this.copyBindings(externalNode, internalNode);
        return internalNode;
    }

    private final void copyBindings(ASTNode source, ASTNode target) {
        final TreeMap indexToBinding = Maps.newTreeMap();
        final int[] finalIndex = new int[1];
        source.accept(new ASTVisitor(){

            public void postVisit(ASTNode node) {
                MethodInvocation invocation;
                IBinding binding;
                if (node instanceof SimpleName) {
                    SimpleName simpleName = (SimpleName)node;
                    binding = simpleName.resolveBinding();
                    if (binding instanceof IVariableBinding) {
                        this.saveBinding(binding);
                    } else {
                        this.saveBinding(null);
                    }
                }
                if (node instanceof VariableDeclaration) {
                    VariableDeclaration variableDeclaration = (VariableDeclaration)node;
                    binding = variableDeclaration.resolveBinding();
                    this.saveBinding(binding);
                }
                if (node instanceof FieldAccess) {
                    FieldAccess fieldAccess = (FieldAccess)node;
                    this.saveBinding((IBinding)fieldAccess.resolveFieldBinding());
                }
                if (node instanceof Expression) {
                    Expression expression = (Expression)node;
                    binding = expression.resolveTypeBinding();
                    this.saveBinding(binding);
                }
                if (node instanceof Type) {
                    Type type = (Type)node;
                    binding = type.resolveBinding();
                    this.saveBinding(binding);
                }
                if (node instanceof TypeDeclaration) {
                    TypeDeclaration typeDeclaration = (TypeDeclaration)node;
                    binding = typeDeclaration.resolveBinding();
                    this.saveBinding(binding);
                }
                if (node instanceof AnonymousClassDeclaration) {
                    AnonymousClassDeclaration anonymousClass = (AnonymousClassDeclaration)node;
                    binding = anonymousClass.resolveBinding();
                    this.saveBinding(binding);
                }
                if (node instanceof MethodDeclaration) {
                    MethodDeclaration method = (MethodDeclaration)node;
                    binding = method.resolveBinding();
                    this.saveBinding(binding);
                }
                if (node instanceof MethodInvocation) {
                    invocation = (MethodInvocation)node;
                    binding = invocation.resolveMethodBinding();
                    this.saveBinding(binding);
                }
                if (node instanceof SuperConstructorInvocation) {
                    invocation = (SuperConstructorInvocation)node;
                    binding = invocation.resolveConstructorBinding();
                    this.saveBinding(binding);
                }
                if (node instanceof SuperMethodInvocation) {
                    invocation = (SuperMethodInvocation)node;
                    binding = invocation.resolveMethodBinding();
                    this.saveBinding(binding);
                }
                if (node instanceof ClassInstanceCreation) {
                    ClassInstanceCreation creation = (ClassInstanceCreation)node;
                    binding = creation.resolveConstructorBinding();
                    this.saveBinding(binding);
                }
            }

            public void saveBinding(IBinding binding) {
                int n = finalIndex[0];
                finalIndex[0] = n + 1;
                int index = n;
                if (binding != null) {
                    indexToBinding.put(index, binding);
                }
            }
        });
        finalIndex = new int[1];
        target.accept(new ASTVisitor(){

            public void postVisit(ASTNode node) {
                IVariableBinding binding;
                int index;
                if (node instanceof SimpleName || node instanceof FieldAccess || node instanceof VariableDeclaration) {
                    int n = finalIndex[0];
                    finalIndex[0] = n + 1;
                    index = n;
                    binding = (IVariableBinding)indexToBinding.get(index);
                    if (binding != null) {
                        node.setProperty(AstParser.KEY_VARIABLE_BINDING, (Object)AstParser.this.m_context.get(binding));
                    }
                }
                if (node instanceof Expression || node instanceof Type || node instanceof TypeDeclaration || node instanceof AnonymousClassDeclaration) {
                    int n = finalIndex[0];
                    finalIndex[0] = n + 1;
                    index = n;
                    binding = (ITypeBinding)indexToBinding.get(index);
                    if (binding != null) {
                        node.setProperty(AstParser.KEY_TYPE_BINDING, (Object)AstParser.this.m_context.get((ITypeBinding)binding, true));
                    }
                }
                if (node instanceof MethodDeclaration || node instanceof MethodInvocation || node instanceof SuperConstructorInvocation || node instanceof SuperMethodInvocation || node instanceof ClassInstanceCreation) {
                    int n = finalIndex[0];
                    finalIndex[0] = n + 1;
                    index = n;
                    binding = (IMethodBinding)indexToBinding.get(index);
                    Assert.isNotNull((Object)binding);
                    node.setProperty(AstParser.KEY_METHOD_BINDING, (Object)AstParser.this.m_context.get((IMethodBinding)binding));
                }
            }
        });
    }
}

