/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.matchers.planning.operations;

import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.Set;
import org.eclipse.viatra.query.runtime.matchers.planning.SubPlan;
import org.eclipse.viatra.query.runtime.matchers.planning.operations.POperation;
import org.eclipse.viatra.query.runtime.matchers.psystem.PConstraint;

public class PApply
extends POperation {
    private PConstraint pConstraint;

    public PApply(PConstraint pConstraint) {
        this.pConstraint = pConstraint;
    }

    public PConstraint getPConstraint() {
        return this.pConstraint;
    }

    @Override
    public String getShortName() {
        return String.format("APPLY_%s", this.pConstraint.toString());
    }

    @Override
    public Set<? extends PConstraint> getDeltaConstraints() {
        return Collections.singleton(this.pConstraint);
    }

    @Override
    public int numParentSubPlans() {
        return 1;
    }

    @Override
    public void checkConsistency(SubPlan subPlan) {
        super.checkConsistency(subPlan);
        for (SubPlan subPlan2 : subPlan.getParentPlans()) {
            Preconditions.checkArgument((!subPlan2.getAllEnforcedConstraints().contains(this.pConstraint) ? 1 : 0) != 0, (Object)("Double-checking constraint " + this.pConstraint));
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.pConstraint == null ? 0 : this.pConstraint.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PApply)) {
            return false;
        }
        PApply other = (PApply)obj;
        return !(this.pConstraint == null ? other.pConstraint != null : !this.pConstraint.equals(other.pConstraint));
    }
}

