/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.views.callstack;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.filters.SelectionTimeQueryFilter;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.filters.TimeQueryFilter;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.timegraph.ITimeGraphEntryModel;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.timegraph.ITimeGraphRowModel;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.timegraph.ITimeGraphState;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.timegraph.TimeGraphEntryModel;
import org.eclipse.tracecompass.internal.provisional.tmf.core.response.ITmfResponse;
import org.eclipse.tracecompass.internal.provisional.tmf.core.response.TmfModelResponse;
import org.eclipse.tracecompass.internal.tmf.core.callstack.provider.CallStackDataProvider;
import org.eclipse.tracecompass.internal.tmf.core.callstack.provider.CallStackEntryModel;
import org.eclipse.tracecompass.internal.tmf.ui.Activator;
import org.eclipse.tracecompass.internal.tmf.ui.Messages;
import org.eclipse.tracecompass.statesystem.core.StateSystemUtils;
import org.eclipse.tracecompass.tmf.core.dataprovider.DataProviderManager;
import org.eclipse.tracecompass.tmf.core.signal.TmfSelectionRangeUpdatedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalHandler;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceClosedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceSelectedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfWindowRangeUpdatedSignal;
import org.eclipse.tracecompass.tmf.core.symbols.SymbolProviderManager;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimeRange;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestamp;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestampFormat;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.ui.editors.ITmfTraceEditor;
import org.eclipse.tracecompass.tmf.ui.symbols.ISymbolProvider;
import org.eclipse.tracecompass.tmf.ui.symbols.ISymbolProviderPreferencePage;
import org.eclipse.tracecompass.tmf.ui.symbols.SymbolProviderConfigDialog;
import org.eclipse.tracecompass.tmf.ui.views.callstack.CallStackPresentationProvider;
import org.eclipse.tracecompass.tmf.ui.views.timegraph.AbstractTimeGraphView;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.TimeGraphContentProvider;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.TimeGraphPresentationProvider;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.TimeGraphViewer;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeGraphEntry;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.NamedTimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.NullTimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.TimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.TimeGraphEntry;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.widgets.TimeGraphControl;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.widgets.Utils;
import org.eclipse.ui.IEditorPart;

public class CallStackView
extends AbstractTimeGraphView {
    public static final @NonNull String ID = "org.eclipse.linuxtools.tmf.ui.views.callstack";
    private static final String[] COLUMN_NAMES = new String[]{Messages.CallStackView_FunctionColumn, Messages.CallStackView_PidTidColumn, Messages.CallStackView_DepthColumn, Messages.CallStackView_EntryTimeColumn, Messages.CallStackView_ExitTimeColumn, Messages.CallStackView_DurationColumn};
    private static final Comparator<ITimeGraphEntry> NAME_COMPARATOR = Comparator.comparing(ITimeGraphEntry::getName);
    private static final Comparator<ITimeGraphEntry> THREAD_ID_COMPARATOR = (o1, o2) -> {
        if (o1 instanceof TimeGraphEntry && o2 instanceof TimeGraphEntry) {
            TimeGraphEntry t1 = (TimeGraphEntry)o1;
            TimeGraphEntry t2 = (TimeGraphEntry)o2;
            ITimeGraphEntryModel model1 = t1.getModel();
            ITimeGraphEntryModel model2 = t2.getModel();
            if (model1 instanceof CallStackEntryModel && model2 instanceof CallStackEntryModel) {
                CallStackEntryModel m1 = (CallStackEntryModel)model1;
                CallStackEntryModel m2 = (CallStackEntryModel)model2;
                if (m1.getStackLevel() == 0 && m2.getStackLevel() == 0) {
                    return Long.compare(m1.getPid(), m2.getPid());
                }
            }
        }
        return 0;
    };
    private static final Comparator<ITimeGraphEntry> DEPTH_COMPARATOR = (o1, o2) -> {
        if (o1 instanceof TimeGraphEntry && o2 instanceof TimeGraphEntry) {
            TimeGraphEntry t1 = (TimeGraphEntry)o1;
            TimeGraphEntry t2 = (TimeGraphEntry)o2;
            ITimeGraphEntryModel model1 = t1.getModel();
            ITimeGraphEntryModel model2 = t2.getModel();
            if (model1 instanceof CallStackEntryModel && model2 instanceof CallStackEntryModel) {
                return Integer.compare(((CallStackEntryModel)model1).getStackLevel(), ((CallStackEntryModel)model2).getStackLevel());
            }
        }
        return 0;
    };
    private static final Comparator<ITimeGraphEntry>[] COMPARATORS = new Comparator[]{Comparator.comparing(ITimeGraphEntry::getName), THREAD_ID_COMPARATOR, DEPTH_COMPARATOR, Comparator.comparingLong(ITimeGraphEntry::getStartTime), Comparator.comparingLong(ITimeGraphEntry::getEndTime)};
    private static final String[] FILTER_COLUMN_NAMES = new String[]{Messages.CallStackView_ThreadColumn};
    private static final long BUILD_UPDATE_TIMEOUT = 500L;
    private static final Image PROCESS_IMAGE = Activator.getDefault().getImageFromPath("icons/obj16/process_obj.gif");
    private static final Image THREAD_IMAGE = Activator.getDefault().getImageFromPath("icons/obj16/thread_obj.gif");
    private static final Image STACKFRAME_IMAGE = Activator.getDefault().getImageFromPath("icons/obj16/stckframe_obj.gif");
    private static final String IMPORT_BINARY_ICON_PATH = "icons/obj16/binaries_obj.gif";
    private Action fNextEventAction;
    private Action fPrevEventAction;
    private Action fNextItemAction;
    private Action fPreviousItemAction;
    private Action fConfigureSymbolsAction;
    private boolean fSyncSelection = false;
    private final Map<Long, ITimeGraphState> fFunctions = new HashMap<Long, ITimeGraphState>();
    private final String fDataProviderID;

    public CallStackView() {
        this(ID, new CallStackPresentationProvider(), "org.eclipse.tracecompass.internal.tmf.core.callstack.provider.CallStackDataProvider");
    }

    public CallStackView(String id, TimeGraphPresentationProvider presentationProvider, String dataProviderID) {
        super(id, presentationProvider);
        this.fDataProviderID = dataProviderID;
        this.setTreeColumns(COLUMN_NAMES, COMPARATORS, 0);
        this.setTreeLabelProvider(new CallStackTreeLabelProvider());
        this.setEntryComparator(new CallStackComparator());
        this.setFilterColumns(FILTER_COLUMN_NAMES);
        this.setFilterContentProvider(new CallStackFilterContentProvider());
        this.setFilterLabelProvider(new CallStackTreeLabelProvider());
    }

    @Override
    public void createPartControl(Composite parent) {
        ITmfTrace trace;
        super.createPartControl(parent);
        this.getTimeGraphViewer().addTimeListener(event -> this.synchingToTime(event.getBeginTime()));
        this.getTimeGraphViewer().getTimeGraphControl().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent event) {
                ITimeGraphEntry selection = CallStackView.this.getTimeGraphViewer().getSelection();
                if (!(selection instanceof TimeGraphEntry)) {
                    return;
                }
                ITimeGraphState function = (ITimeGraphState)CallStackView.this.fFunctions.get(((TimeGraphEntry)selection).getModel().getId());
                if (function != null) {
                    long entryTime = function.getStartTime();
                    long exitTime = entryTime + function.getDuration();
                    TmfTimeRange range = new TmfTimeRange(TmfTimestamp.fromNanos((long)entryTime), TmfTimestamp.fromNanos((long)exitTime));
                    CallStackView.this.broadcast((TmfSignal)new TmfWindowRangeUpdatedSignal((Object)CallStackView.this, range, CallStackView.this.getTrace()));
                    CallStackView.this.getTimeGraphViewer().setStartFinishTime(entryTime, exitTime);
                    CallStackView.this.startZoomThread(entryTime, exitTime);
                }
            }
        });
        this.getTimeGraphViewer().getTimeGraphControl().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                TimeGraphControl timeGraphControl = CallStackView.this.getTimeGraphViewer().getTimeGraphControl();
                ISelection selection = timeGraphControl.getSelection();
                if (selection instanceof IStructuredSelection) {
                    for (Object object : ((IStructuredSelection)selection).toList()) {
                        if (!(object instanceof NamedTimeEvent)) continue;
                        NamedTimeEvent event = (NamedTimeEvent)object;
                        long startTime = event.getTime();
                        long endTime = startTime + event.getDuration();
                        TmfTimeRange range = new TmfTimeRange(TmfTimestamp.fromNanos((long)startTime), TmfTimestamp.fromNanos((long)endTime));
                        CallStackView.this.broadcast((TmfSignal)new TmfWindowRangeUpdatedSignal((Object)CallStackView.this, range, CallStackView.this.getTrace()));
                        CallStackView.this.getTimeGraphViewer().setStartFinishTime(startTime, endTime);
                        CallStackView.this.startZoomThread(startTime, endTime);
                        break;
                    }
                }
            }
        });
        IEditorPart editor = this.getSite().getPage().getActiveEditor();
        if (editor instanceof ITmfTraceEditor && (trace = ((ITmfTraceEditor)editor).getTrace()) != null) {
            this.traceSelected(new TmfTraceSelectedSignal((Object)this, trace));
        }
    }

    @Override
    @TmfSignalHandler
    public void selectionRangeUpdated(TmfSelectionRangeUpdatedSignal signal) {
        this.fSyncSelection = true;
        super.selectionRangeUpdated(signal);
    }

    @Override
    @TmfSignalHandler
    public void windowRangeUpdated(TmfWindowRangeUpdatedSignal signal) {
        if (signal.getSource() == this) {
            return;
        }
        super.windowRangeUpdated(signal);
    }

    @Override
    @Deprecated
    protected CallStackPresentationProvider getPresentationProvider() {
        return (CallStackPresentationProvider)super.getPresentationProvider();
    }

    @Override
    protected void refresh() {
        super.refresh();
        this.updateConfigureSymbolsAction();
    }

    @Override
    protected void buildEntryList(ITmfTrace trace, ITmfTrace parentTrace, IProgressMonitor monitor) {
        CallStackDataProvider provider = (CallStackDataProvider)DataProviderManager.getInstance().getDataProvider(trace, this.fDataProviderID, CallStackDataProvider.class);
        if (provider == null) {
            this.addUnavailableEntry(trace, parentTrace);
            return;
        }
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor);
        provider.resetFunctionNames((IProgressMonitor)subMonitor);
        boolean complete = false;
        TimeGraphEntry traceEntry = null;
        HashMap<Long, TimeGraphEntry> map = new HashMap<Long, TimeGraphEntry>();
        while (!complete && !subMonitor.isCanceled()) {
            TmfModelResponse response = provider.fetchTree(new TimeQueryFilter(0L, Long.MAX_VALUE, 2), (IProgressMonitor)subMonitor);
            if (response.getStatus() == ITmfResponse.Status.FAILED) {
                Activator.getDefault().logError("Call Stack Data Provider failed: " + response.getStatusMessage());
                return;
            }
            if (response.getStatus() == ITmfResponse.Status.CANCELLED) {
                return;
            }
            complete = response.getStatus() == ITmfResponse.Status.COMPLETED;
            List model = (List)response.getModel();
            if (model != null) {
                for (CallStackEntryModel entry : model) {
                    if (entry.getStackLevel() != -2) {
                        TimeGraphEntry uiEntry = (TimeGraphEntry)map.get(entry.getId());
                        if (uiEntry != null) {
                            uiEntry.updateModel((TimeGraphEntryModel)entry);
                            continue;
                        }
                        uiEntry = new TimeGraphEntry((TimeGraphEntryModel)entry);
                        map.put(entry.getId(), uiEntry);
                        TimeGraphEntry parent = map.getOrDefault(entry.getParentId(), traceEntry);
                        parent.addChild(uiEntry);
                        continue;
                    }
                    this.setStartTime(Long.min(this.getStartTime(), entry.getStartTime()));
                    this.setEndTime(Long.max(this.getEndTime(), entry.getEndTime() + 1L));
                    if (traceEntry != null) {
                        traceEntry.updateModel((TimeGraphEntryModel)entry);
                        continue;
                    }
                    traceEntry = new TraceEntry(entry, provider);
                    traceEntry.sortChildren(NAME_COMPARATOR);
                    this.addToEntryList(parentTrace, Collections.singletonList(traceEntry));
                }
                Objects.requireNonNull(traceEntry);
                long start = traceEntry.getStartTime();
                long end = traceEntry.getEndTime();
                long resolution = Long.max(1L, (end - start) / (long)this.getDisplayWidth());
                this.zoomEntries(map.values(), start, end, resolution, (IProgressMonitor)subMonitor);
            }
            if (parentTrace.equals(this.getTrace())) {
                this.synchingToTime(this.getTimeGraphViewer().getSelectionBegin());
                this.refresh();
            }
            subMonitor.worked(1);
            if (complete) continue;
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                Activator.getDefault().logError("Failed to wait for data provider", e);
            }
        }
    }

    private void addUnavailableEntry(ITmfTrace trace, ITmfTrace parentTrace) {
        String name = String.valueOf(Messages.CallStackView_StackInfoNotAvailable) + ' ' + '(' + trace.getName() + ')';
        TimeGraphEntry unavailableEntry = new TimeGraphEntry(name, 0L, 0L){

            @Override
            public boolean hasTimeEvents() {
                return false;
            }
        };
        this.addToEntryList(parentTrace, Collections.singletonList(unavailableEntry));
        if (parentTrace == this.getTrace()) {
            this.refresh();
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    protected void zoomEntries(@NonNull Iterable<@NonNull TimeGraphEntry> entries, long zoomStartTime, long zoomEndTime, long resolution, @NonNull IProgressMonitor monitor) {
        if (resolution < 0L) {
            return;
        }
        long start = Long.min(zoomStartTime, zoomEndTime);
        long end = Long.max(zoomStartTime, zoomEndTime);
        @NonNull List times = StateSystemUtils.getTimes((long)start, (long)end, (long)resolution);
        TimeGraphEntry.Sampling sampling = new TimeGraphEntry.Sampling(start, end, resolution);
        Table<CallStackDataProvider, Long, TimeGraphEntry> callStackEntries = CallStackView.filterGroup(entries);
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)"CallStackView#zoomEntries", (int)callStackEntries.rowKeySet().size());
        for (Map.Entry entry : callStackEntries.rowMap().entrySet()) {
            Map map;
            SelectionTimeQueryFilter filter;
            CallStackDataProvider dataProvider = (CallStackDataProvider)entry.getKey();
            TmfModelResponse response = dataProvider.fetchRowModel(filter = new SelectionTimeQueryFilter(times, (map = (Map)entry.getValue()).keySet()), monitor);
            List model = (List)response.getModel();
            if (model != null) {
                this.zoomEntries(map, model, response.getStatus() == ITmfResponse.Status.COMPLETED, sampling, zoomEndTime);
            }
            subMonitor.worked(1);
        }
    }

    private void zoomEntries(Map<Long, TimeGraphEntry> map, List<ITimeGraphRowModel> model, boolean completed, TimeGraphEntry.Sampling sampling, long zoomEndTime) {
        boolean isZoomThread = Thread.currentThread() instanceof AbstractTimeGraphView.ZoomThread;
        for (ITimeGraphRowModel rowModel : model) {
            TimeGraphEntry callStackEntry = map.get(rowModel.getEntryID());
            if (callStackEntry == null) continue;
            List<ITimeEvent> events = CallStackView.createTimeEvents(callStackEntry, rowModel.getStates(), zoomEndTime);
            if (isZoomThread) {
                this.applyResults(() -> {
                    callStackEntry.setZoomedEventList(events);
                    if (completed) {
                        callStackEntry.setSampling(sampling);
                    }
                });
                continue;
            }
            callStackEntry.setEventList(events);
        }
    }

    private static Table<CallStackDataProvider, Long, TimeGraphEntry> filterGroup(@NonNull Iterable<@NonNull TimeGraphEntry> entries) {
        Iterable timeGraphEntries = Iterables.filter(entries, TimeGraphEntry.class);
        Iterable callStackEntries = Iterables.filter((Iterable)timeGraphEntries, tge -> tge.getModel() instanceof CallStackEntryModel);
        Iterable functionEntries = Iterables.filter((Iterable)callStackEntries, e -> ((CallStackEntryModel)e.getModel()).getStackLevel() > 0);
        HashBasedTable table = HashBasedTable.create();
        for (TimeGraphEntry entry : functionEntries) {
            table.put((Object)CallStackView.getProvider(entry), (Object)entry.getModel().getId(), (Object)entry);
        }
        return table;
    }

    public static @NonNull CallStackDataProvider getProvider(TimeGraphEntry entry) {
        ITimeGraphEntry parent = entry;
        while (parent != null) {
            if (parent instanceof TraceEntry) {
                return ((TraceEntry)parent).getProvider();
            }
            parent = parent.getParent();
        }
        throw new IllegalStateException(entry + " should have a TraceEntry parent");
    }

    private static List<ITimeEvent> createTimeEvents(TimeGraphEntry callStackEntry, @NonNull List<@NonNull ITimeGraphState> values, long endTime) {
        ArrayList<ITimeEvent> events = new ArrayList<ITimeEvent>(values.size());
        long lastEndTime = -1L;
        boolean lastIsNull = false;
        boolean isZoomThread = Thread.currentThread() instanceof AbstractTimeGraphView.ZoomThread;
        int modulo = 180;
        for (ITimeGraphState state : values) {
            long time = state.getStartTime();
            long duration = state.getDuration();
            if (state.getValue() != Integer.MIN_VALUE) {
                int value = (int)state.getValue() % 180 + 180;
                String label = state.getLabel();
                if (label != null) {
                    events.add(new NamedTimeEvent(callStackEntry, time, duration, value, label));
                } else {
                    events.add(new TimeEvent(callStackEntry, time, duration, value));
                }
                lastIsNull = false;
            } else {
                if (isZoomThread && (lastEndTime == -1L || time + duration >= endTime)) {
                    events.add(new NullTimeEvent(callStackEntry, time, duration));
                } else if (lastEndTime != time && lastIsNull) {
                    events.add(new TimeEvent(callStackEntry, lastEndTime, time - lastEndTime));
                }
                lastIsNull = true;
            }
            lastEndTime = time + duration;
        }
        return events;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    protected void synchingToTime(long time) {
        List<TimeGraphEntry> traceEntries = this.getEntryList(this.getTrace());
        if (traceEntries != null) {
            for (TraceEntry traceEntry : Iterables.filter(traceEntries, TraceEntry.class)) {
                Iterable unfiltered = Iterables.filter(Utils.flatten(traceEntry), TimeGraphEntry.class);
                ImmutableMap map = Maps.uniqueIndex((Iterable)unfiltered, e -> e.getModel().getId());
                SelectionTimeQueryFilter filter = new SelectionTimeQueryFilter(time - 1L, time, 2, map.keySet());
                @NonNull @NonNull TmfModelResponse response = traceEntry.getProvider().fetchRowModel(filter, null);
                @NonNull List model = (List)response.getModel();
                if (model == null) continue;
                for (ITimeGraphRowModel row : model) {
                    this.syncToRow(row, time, (Map<Long, TimeGraphEntry>)map);
                }
            }
        }
        this.fSyncSelection = false;
        if (Display.getCurrent() != null) {
            this.getTimeGraphViewer().refresh();
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private void syncToRow(ITimeGraphRowModel rowModel, long time, Map<Long, TimeGraphEntry> entryMap) {
        long id = rowModel.getEntryID();
        @NonNull List list = rowModel.getStates();
        if (!list.isEmpty()) {
            TimeGraphEntry entry;
            ITimeGraphState event = (ITimeGraphState)list.get(0);
            if (event.getStartTime() + event.getDuration() <= time && list.size() > 1) {
                event = (ITimeGraphState)list.get(1);
            }
            if (event.getLabel() != null) {
                this.fFunctions.put(id, event);
            } else {
                this.fFunctions.remove(id);
            }
            if (this.fSyncSelection && time == event.getStartTime() && (entry = entryMap.get(id)) != null) {
                this.fSyncSelection = false;
                Display.getDefault().asyncExec(() -> {
                    this.getTimeGraphViewer().setSelection(entry, true);
                    this.getTimeGraphViewer().getTimeGraphControl().fireSelectionChanged();
                });
            }
        } else {
            this.fFunctions.remove(id);
        }
    }

    private void makeActions() {
        this.fPreviousItemAction = this.getTimeGraphViewer().getPreviousItemAction();
        this.fPreviousItemAction.setText(Messages.TmfTimeGraphViewer_PreviousItemActionNameText);
        this.fPreviousItemAction.setToolTipText(Messages.TmfTimeGraphViewer_PreviousItemActionToolTipText);
        this.fNextItemAction = this.getTimeGraphViewer().getNextItemAction();
        this.fNextItemAction.setText(Messages.TmfTimeGraphViewer_NextItemActionNameText);
        this.fNextItemAction.setToolTipText(Messages.TmfTimeGraphViewer_NextItemActionToolTipText);
    }

    @Override
    protected void fillLocalToolBar(IToolBarManager manager) {
        this.makeActions();
        manager.appendToGroup("additions", (IAction)this.getConfigureSymbolsAction());
        manager.appendToGroup("additions", (IContributionItem)new Separator());
        manager.appendToGroup("additions", (IAction)this.getTimeGraphViewer().getShowFilterDialogAction());
        manager.appendToGroup("additions", (IContributionItem)new Separator());
        manager.appendToGroup("additions", (IAction)this.getTimeGraphViewer().getResetScaleAction());
        manager.appendToGroup("additions", (IAction)this.getPreviousEventAction());
        manager.appendToGroup("additions", (IAction)this.getNextEventAction());
        manager.appendToGroup("additions", (IContributionItem)new Separator());
        manager.appendToGroup("additions", (IAction)this.getTimeGraphViewer().getToggleBookmarkAction());
        manager.appendToGroup("additions", (IAction)this.getTimeGraphViewer().getPreviousMarkerAction());
        manager.appendToGroup("additions", (IAction)this.getTimeGraphViewer().getNextMarkerAction());
        manager.appendToGroup("additions", (IContributionItem)new Separator());
        manager.appendToGroup("additions", (IAction)this.fPreviousItemAction);
        manager.appendToGroup("additions", (IAction)this.fNextItemAction);
        manager.appendToGroup("additions", (IAction)this.getTimeGraphViewer().getZoomInAction());
        manager.appendToGroup("additions", (IAction)this.getTimeGraphViewer().getZoomOutAction());
    }

    private Action getNextEventAction() {
        if (this.fNextEventAction == null) {
            this.fNextEventAction = new Action(){

                /*
                 * Issues handling annotations - annotations may be inaccurate
                 */
                public void run() {
                    TimeGraphViewer viewer = CallStackView.this.getTimeGraphViewer();
                    ITimeGraphEntry entry = viewer.getSelection();
                    if (entry instanceof TimeGraphEntry) {
                        long selectionBegin;
                        SelectionTimeQueryFilter filter;
                        TimeGraphEntry callStackEntry = (TimeGraphEntry)entry;
                        CallStackDataProvider provider = CallStackView.getProvider(callStackEntry);
                        @NonNull @NonNull TmfModelResponse response = provider.fetchRowModel(filter = new SelectionTimeQueryFilter(selectionBegin = viewer.getSelectionBegin(), Long.MAX_VALUE, 2, Collections.singleton(callStackEntry.getModel().getId())), null);
                        @NonNull List model = (List)response.getModel();
                        if (model == null || model.size() != 1) {
                            return;
                        }
                        @NonNull List row = ((ITimeGraphRowModel)model.get(0)).getStates();
                        if (row.size() != 1) {
                            return;
                        }
                        ITimeGraphState stackInterval = (ITimeGraphState)row.get(0);
                        if (stackInterval.getStartTime() <= selectionBegin && selectionBegin <= stackInterval.getStartTime() + stackInterval.getDuration()) {
                            viewer.setSelectedTimeNotify(stackInterval.getStartTime() + stackInterval.getDuration() + 1L, true);
                        } else {
                            viewer.setSelectedTimeNotify(stackInterval.getStartTime(), true);
                        }
                        int stackLevel = (int)stackInterval.getValue();
                        ITimeGraphEntry selectedEntry = callStackEntry.getParent().getChildren().get(Integer.max(0, stackLevel - 1));
                        viewer.setSelection(selectedEntry, true);
                        viewer.getTimeGraphControl().fireSelectionChanged();
                        CallStackView.this.startZoomThread(viewer.getTime0(), viewer.getTime1());
                    }
                }
            };
            this.fNextEventAction.setText(Messages.TmfTimeGraphViewer_NextStateChangeActionNameText);
            this.fNextEventAction.setToolTipText(Messages.TmfTimeGraphViewer_NextStateChangeActionToolTipText);
            this.fNextEventAction.setImageDescriptor(Activator.getDefault().getImageDescripterFromPath("icons/elcl16/next_event.gif"));
        }
        return this.fNextEventAction;
    }

    private Action getPreviousEventAction() {
        if (this.fPrevEventAction == null) {
            this.fPrevEventAction = new Action(){

                /*
                 * Issues handling annotations - annotations may be inaccurate
                 */
                public void run() {
                    TimeGraphViewer viewer = CallStackView.this.getTimeGraphViewer();
                    ITimeGraphEntry entry = viewer.getSelection();
                    if (entry instanceof TimeGraphEntry) {
                        TimeGraphEntry callStackEntry = (TimeGraphEntry)entry;
                        CallStackDataProvider provider = CallStackView.getProvider(callStackEntry);
                        long selectionBegin = viewer.getSelectionBegin();
                        SelectionTimeQueryFilter filter = new SelectionTimeQueryFilter((List)Lists.newArrayList((Object[])new Long[]{Long.MIN_VALUE, selectionBegin}), Collections.singleton(callStackEntry.getModel().getId()));
                        @NonNull @NonNull TmfModelResponse response = provider.fetchRowModel(filter, null);
                        @NonNull List model = (List)response.getModel();
                        if (model == null || model.size() != 1) {
                            return;
                        }
                        @NonNull List row = ((ITimeGraphRowModel)model.get(0)).getStates();
                        if (row.size() != 1) {
                            return;
                        }
                        ITimeGraphState stackInterval = (ITimeGraphState)row.get(0);
                        viewer.setSelectedTimeNotify(stackInterval.getStartTime(), true);
                        int stackLevel = (int)stackInterval.getValue();
                        ITimeGraphEntry selectedEntry = callStackEntry.getParent().getChildren().get(Integer.max(0, stackLevel - 1));
                        viewer.setSelection(selectedEntry, true);
                        viewer.getTimeGraphControl().fireSelectionChanged();
                        CallStackView.this.startZoomThread(viewer.getTime0(), viewer.getTime1());
                    }
                }
            };
            this.fPrevEventAction.setText(Messages.TmfTimeGraphViewer_PreviousStateChangeActionNameText);
            this.fPrevEventAction.setToolTipText(Messages.TmfTimeGraphViewer_PreviousStateChangeActionToolTipText);
            this.fPrevEventAction.setImageDescriptor(Activator.getDefault().getImageDescripterFromPath("icons/elcl16/prev_event.gif"));
        }
        return this.fPrevEventAction;
    }

    private Action getConfigureSymbolsAction() {
        if (this.fConfigureSymbolsAction != null) {
            return this.fConfigureSymbolsAction;
        }
        this.fConfigureSymbolsAction = new Action(Messages.CallStackView_ConfigureSymbolProvidersText){

            public void run() {
                SymbolProviderConfigDialog dialog = new SymbolProviderConfigDialog(CallStackView.this.getSite().getShell(), CallStackView.this.getProviderPages());
                if (dialog.open() == 0) {
                    List traceEntries = CallStackView.this.getEntryList(CallStackView.this.getTrace());
                    if (traceEntries != null) {
                        for (TraceEntry traceEntry : Iterables.filter((Iterable)traceEntries, TraceEntry.class)) {
                            traceEntry.getProvider().resetFunctionNames((IProgressMonitor)new NullProgressMonitor());
                            Iterable<TimeGraphEntry> flatten = Utils.flatten(traceEntry);
                            flatten.forEach(e -> e.setSampling(null));
                            long start = traceEntry.getStartTime();
                            long end = traceEntry.getEndTime();
                            long resolution = Long.max(1L, (end - start) / (long)CallStackView.this.getDisplayWidth());
                            CallStackView.this.zoomEntries(flatten, start, end, resolution, (IProgressMonitor)new NullProgressMonitor());
                        }
                        CallStackView.this.refresh();
                    }
                    CallStackView.this.synchingToTime(CallStackView.this.getTimeGraphViewer().getSelectionBegin());
                }
            }
        };
        this.fConfigureSymbolsAction.setToolTipText(Messages.CallStackView_ConfigureSymbolProvidersTooltip);
        this.fConfigureSymbolsAction.setImageDescriptor(Activator.getDefault().getImageDescripterFromPath(IMPORT_BINARY_ICON_PATH));
        this.fConfigureSymbolsAction.setEnabled(false);
        return this.fConfigureSymbolsAction;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private ISymbolProviderPreferencePage[] getProviderPages() {
        ArrayList<ISymbolProviderPreferencePage> pages = new ArrayList<ISymbolProviderPreferencePage>();
        ITmfTrace trace = this.getTrace();
        if (trace != null) {
            for (ITmfTrace subTrace : this.getTracesToBuild(trace)) {
                @NonNull Collection symbolProviders = SymbolProviderManager.getInstance().getSymbolProviders(subTrace);
                for (ISymbolProvider provider : Iterables.filter((Iterable)symbolProviders, ISymbolProvider.class)) {
                    ISymbolProviderPreferencePage page = provider.createPreferencePage();
                    if (page == null) continue;
                    pages.add(page);
                }
            }
        }
        return pages.toArray(new ISymbolProviderPreferencePage[pages.size()]);
    }

    private void updateConfigureSymbolsAction() {
        ISymbolProviderPreferencePage[] providerPages = this.getProviderPages();
        this.getConfigureSymbolsAction().setEnabled(providerPages.length > 0);
    }

    @Override
    @TmfSignalHandler
    public void traceClosed(TmfTraceClosedSignal signal) {
        List<@NonNull TimeGraphEntry> traceEntries = this.getEntryList(signal.getTrace());
        if (traceEntries != null) {
            Iterable all = Iterables.concat((Iterable)Iterables.transform(traceEntries, Utils::flatten));
            all.forEach(entry -> {
                ITimeGraphState iTimeGraphState = this.fFunctions.remove(entry.getModel().getId());
            });
        }
        super.traceClosed(signal);
    }

    private class CallStackComparator
    implements Comparator<ITimeGraphEntry> {
        private CallStackComparator() {
        }

        @Override
        public int compare(ITimeGraphEntry o1, ITimeGraphEntry o2) {
            if (o1 instanceof TimeGraphEntry && o2 instanceof TimeGraphEntry) {
                TimeGraphEntry t1 = (TimeGraphEntry)o1;
                TimeGraphEntry t2 = (TimeGraphEntry)o2;
                ITimeGraphEntryModel model1 = t1.getModel();
                ITimeGraphEntryModel model2 = t2.getModel();
                CallStackEntryModel m1 = (CallStackEntryModel)model1;
                CallStackEntryModel m2 = (CallStackEntryModel)model2;
                if (m1.getStackLevel() == 0 && m2.getStackLevel() == 0) {
                    return NAME_COMPARATOR.compare(t1, t2);
                }
                if (m1.getStackLevel() == -1 && m2.getStackLevel() == -1) {
                    return Integer.compare(m1.getPid(), m2.getPid());
                }
            }
            return 0;
        }
    }

    private class CallStackFilterContentProvider
    extends TimeGraphContentProvider {
        private CallStackFilterContentProvider() {
        }

        @Override
        public boolean hasChildren(Object element) {
            if (element instanceof TraceEntry) {
                return super.hasChildren(element);
            }
            return false;
        }

        @Override
        public ITimeGraphEntry[] getChildren(Object parentElement) {
            if (parentElement instanceof TraceEntry) {
                return super.getChildren(parentElement);
            }
            return new ITimeGraphEntry[0];
        }
    }

    private class CallStackTreeLabelProvider
    extends AbstractTimeGraphView.TreeLabelProvider {
        private CallStackTreeLabelProvider() {
        }

        @Override
        public Image getColumnImage(Object element, int columnIndex) {
            TimeGraphEntry entry;
            ITimeGraphEntryModel entryModel;
            if (columnIndex == 0 && element instanceof TimeGraphEntry && (entryModel = (entry = (TimeGraphEntry)element).getModel()) instanceof CallStackEntryModel) {
                CallStackEntryModel callStackEntryModel = (CallStackEntryModel)entryModel;
                if (callStackEntryModel.getStackLevel() == -1) {
                    return PROCESS_IMAGE;
                }
                if (callStackEntryModel.getStackLevel() == 0) {
                    return THREAD_IMAGE;
                }
                if (CallStackView.this.fFunctions.containsKey(entryModel.getId())) {
                    return STACKFRAME_IMAGE;
                }
            }
            return null;
        }

        @Override
        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof TraceEntry && columnIndex == 0) {
                return ((TraceEntry)element).getName();
            }
            if (element instanceof TimeGraphEntry) {
                TimeGraphEntry entry = (TimeGraphEntry)element;
                ITimeGraphEntryModel model = entry.getModel();
                ITimeGraphState function = (ITimeGraphState)CallStackView.this.fFunctions.get(model.getId());
                if (columnIndex == 0 && (!(model instanceof CallStackEntryModel) || model instanceof CallStackEntryModel && ((CallStackEntryModel)model).getStackLevel() <= 0)) {
                    return entry.getName();
                }
                if (function != null) {
                    if (columnIndex == 0) {
                        return function.getLabel();
                    }
                    if (columnIndex == 2 && model instanceof CallStackEntryModel) {
                        return Integer.toString(((CallStackEntryModel)model).getStackLevel());
                    }
                    if (columnIndex == 3) {
                        return TmfTimestampFormat.getDefaulTimeFormat().format(function.getStartTime());
                    }
                    if (columnIndex == 4) {
                        return TmfTimestampFormat.getDefaulTimeFormat().format(function.getStartTime() + function.getDuration());
                    }
                    if (columnIndex == 5) {
                        return TmfTimestampFormat.getDefaulIntervalFormat().format(function.getDuration());
                    }
                } else if (model instanceof CallStackEntryModel) {
                    CallStackEntryModel callStackEntryModel = (CallStackEntryModel)model;
                    if (columnIndex == 1 && callStackEntryModel.getStackLevel() <= 0 && callStackEntryModel.getPid() >= 0) {
                        return Integer.toString(callStackEntryModel.getPid());
                    }
                    if (columnIndex == 3 && callStackEntryModel.getStackLevel() <= 0) {
                        return TmfTimestampFormat.getDefaulTimeFormat().format(model.getStartTime());
                    }
                    if (columnIndex == 4 && callStackEntryModel.getStackLevel() <= 0) {
                        return TmfTimestampFormat.getDefaulTimeFormat().format(model.getEndTime());
                    }
                }
            }
            return "";
        }
    }

    private static class TraceEntry
    extends TimeGraphEntry {
        private final @NonNull CallStackDataProvider fProvider;

        public TraceEntry(CallStackEntryModel model, @NonNull CallStackDataProvider provider) {
            super((TimeGraphEntryModel)model);
            this.fProvider = provider;
        }

        @Override
        public boolean hasTimeEvents() {
            return false;
        }

        public @NonNull CallStackDataProvider getProvider() {
            return this.fProvider;
        }
    }
}

