/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.analysis.xml.ui.views.latency;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.ui.views.XmlLatencyViewInfo;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.ui.views.latency.Messages;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.ui.views.latency.PatternScatterGraphViewer;
import org.eclipse.tracecompass.tmf.ui.viewers.xycharts.TmfXYChartViewer;
import org.eclipse.tracecompass.tmf.ui.views.TmfChartView;

public class PatternScatterGraphView
extends TmfChartView {
    public static final @NonNull String ID = "org.eclipse.tracecompass.internal.tmf.analysis.xml.ui.views.scattergraph";
    private final XmlLatencyViewInfo fViewInfo = new XmlLatencyViewInfo("org.eclipse.tracecompass.internal.tmf.analysis.xml.ui.views.scattergraph");
    private PatternScatterGraphViewer fViewer;

    public PatternScatterGraphView() {
        super(ID);
        this.addPartPropertyListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                Object newValue;
                if (event.getProperty().equals("xmlLatencyOutputData") && (newValue = event.getNewValue()) instanceof String) {
                    String data = (String)newValue;
                    PatternScatterGraphView.this.fViewInfo.setViewData(data);
                    PatternScatterGraphView.this.setPartName(PatternScatterGraphView.this.fViewInfo.getLabel());
                    PatternScatterGraphView.this.loadLatencyView();
                }
            }
        });
    }

    public void createPartControl(@Nullable Composite parent) {
        String name = this.getViewSite().getSecondaryId();
        if (name != null) {
            this.fViewInfo.setName(name);
        }
        super.createPartControl(parent);
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                PatternScatterGraphView.this.setPartName(PatternScatterGraphView.this.fViewInfo.getLabel());
            }
        });
    }

    private void loadLatencyView() {
        if (this.fViewer != null) {
            this.fViewer.updateViewer(this.fViewInfo.getViewAnalysisId());
        }
    }

    protected TmfXYChartViewer createChartViewer(Composite parent) {
        PatternScatterGraphViewer viewer;
        this.fViewer = viewer = new PatternScatterGraphViewer((Composite)NonNullUtils.checkNotNull((Object)parent), (String)NonNullUtils.checkNotNull((Object)Messages.PatternLatencyViews_ScatterGraphTitle), (String)NonNullUtils.checkNotNull((Object)Messages.PatternLatencyViews_ScatterGraphXLabel), (String)NonNullUtils.checkNotNull((Object)Messages.PatternLatencyViews_ScatterGraphYLabel));
        this.loadLatencyView();
        return viewer;
    }
}

