/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.ImageList;
import org.eclipse.swt.internal.cairo.Cairo;
import org.eclipse.swt.internal.gtk.GdkColor;
import org.eclipse.swt.internal.gtk.GdkEventButton;
import org.eclipse.swt.internal.gtk.GdkEventExpose;
import org.eclipse.swt.internal.gtk.GdkEventKey;
import org.eclipse.swt.internal.gtk.GdkRGBA;
import org.eclipse.swt.internal.gtk.GdkRectangle;
import org.eclipse.swt.internal.gtk.GtkAllocation;
import org.eclipse.swt.internal.gtk.GtkCellRendererClass;
import org.eclipse.swt.internal.gtk.GtkRequisition;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.TypedListener;

public class Table
extends Composite {
    long modelHandle;
    long checkRenderer;
    int itemCount;
    int columnCount;
    int lastIndexOf;
    int sortDirection;
    int selectionCountOnPress;
    int selectionCountOnRelease;
    long ignoreCell;
    TableItem[] items;
    TableColumn[] columns;
    TableItem currentItem;
    TableColumn sortColumn;
    ImageList imageList;
    ImageList headerImageList;
    boolean firstCustomDraw;
    int drawState;
    int drawFlags;
    GdkColor drawForeground;
    GdkRGBA background;
    GdkRGBA foreground;
    Color headerBackground;
    Color headerForeground;
    String headerCSSBackground;
    String headerCSSForeground;
    boolean ownerDraw;
    boolean ignoreSize;
    boolean ignoreAccessibility;
    boolean pixbufSizeSet;
    int maxWidth = 0;
    int topIndex;
    double cachedAdjustment;
    double currentAdjustment;
    int pixbufHeight;
    int pixbufWidth;
    static final int CHECKED_COLUMN = 0;
    static final int GRAYED_COLUMN = 1;
    static final int FOREGROUND_COLUMN = 2;
    static final int BACKGROUND_COLUMN = 3;
    static final int FONT_COLUMN = 4;
    static final int FIRST_COLUMN = 5;
    static final int CELL_PIXBUF = 0;
    static final int CELL_TEXT = 1;
    static final int CELL_FOREGROUND = 2;
    static final int CELL_BACKGROUND = 3;
    static final int CELL_FONT = 4;
    static final int CELL_TYPES = 5;

    public Table(Composite parent, int style) {
        super(parent, Table.checkStyle(style));
    }

    @Override
    void _addListener(int eventType, Listener listener) {
        super._addListener(eventType, listener);
        if (!this.ownerDraw) {
            switch (eventType) {
                case 40: 
                case 41: 
                case 42: {
                    this.ownerDraw = true;
                    this.recreateRenderers();
                }
            }
        }
    }

    TableItem _getItem(int index) {
        if ((this.style & 0x10000000) == 0) {
            return this.items[index];
        }
        if (this.items[index] != null) {
            return this.items[index];
        }
        this.items[index] = new TableItem(this, 0, index, false);
        return this.items[index];
    }

    static int checkStyle(int style) {
        if ((style & 0x10) == 0) {
            style |= 0x300;
        }
        return Table.checkBits(style |= 0x10000, 4, 2, 0, 0, 0, 0);
    }

    @Override
    long cellDataProc(long tree_column, long cell, long tree_model, long iter, long data) {
        if (cell == this.ignoreCell) {
            return 0L;
        }
        long path = OS.gtk_tree_model_get_path(tree_model, iter);
        int[] index = new int[1];
        OS.memmove(index, OS.gtk_tree_path_get_indices(path), 4L);
        TableItem item = this._getItem(index[0]);
        OS.gtk_tree_path_free(path);
        if (item != null) {
            OS.g_object_set_qdata(cell, Display.SWT_OBJECT_INDEX2, item.handle);
        }
        boolean isPixbuf = OS.GTK_IS_CELL_RENDERER_PIXBUF(cell);
        boolean isText = OS.GTK_IS_CELL_RENDERER_TEXT(cell);
        if (isText && OS.GTK3) {
            OS.gtk_cell_renderer_set_fixed_size(cell, -1, -1);
        }
        if (!isPixbuf && !isText) {
            return 0L;
        }
        int modelIndex = -1;
        boolean customDraw = false;
        if (this.columnCount == 0) {
            modelIndex = 5;
            customDraw = this.firstCustomDraw;
        } else {
            TableColumn column = (TableColumn)this.display.getWidget(tree_column);
            if (column != null) {
                modelIndex = column.modelIndex;
                customDraw = column.customDraw;
            }
        }
        if (modelIndex == -1) {
            return 0L;
        }
        boolean setData = false;
        if ((this.style & 0x10000000) != 0 && !item.cached) {
            this.lastIndexOf = index[0];
            setData = this.checkData(item);
        }
        long[] ptr = new long[1];
        if (setData) {
            ptr[0] = 0L;
            if (isPixbuf) {
                OS.gtk_tree_model_get(tree_model, iter, modelIndex + 0, ptr, -1);
                OS.g_object_set(cell, OS.GTK3 ? OS.gicon : OS.pixbuf, ptr[0], 0L);
                if (ptr[0] != 0L) {
                    OS.g_object_unref(ptr[0]);
                }
            } else {
                OS.gtk_tree_model_get(tree_model, iter, modelIndex + 1, ptr, -1);
                if (ptr[0] != 0L) {
                    OS.g_object_set(cell, OS.text, ptr[0], 0L);
                    OS.g_free(ptr[0]);
                }
            }
        }
        if (customDraw) {
            if (!this.ownerDraw) {
                ptr[0] = 0L;
                OS.gtk_tree_model_get(tree_model, iter, modelIndex + 3, ptr, -1);
                if (ptr[0] != 0L) {
                    OS.g_object_set(cell, OS.cell_background_gdk, ptr[0], 0L);
                    OS.gdk_color_free(ptr[0]);
                }
            }
            if (!isPixbuf) {
                ptr[0] = 0L;
                OS.gtk_tree_model_get(tree_model, iter, modelIndex + 2, ptr, -1);
                if (ptr[0] != 0L) {
                    OS.g_object_set(cell, OS.foreground_gdk, ptr[0], 0L);
                    OS.gdk_color_free(ptr[0]);
                }
                ptr[0] = 0L;
                OS.gtk_tree_model_get(tree_model, iter, modelIndex + 4, ptr, -1);
                if (ptr[0] != 0L) {
                    OS.g_object_set(cell, OS.font_desc, ptr[0], 0L);
                    OS.pango_font_description_free(ptr[0]);
                }
            }
        }
        if (setData) {
            this.ignoreCell = cell;
            this.setScrollWidth(tree_column, item);
            this.ignoreCell = 0L;
        }
        return 0L;
    }

    boolean checkData(TableItem item) {
        if (item.cached) {
            return true;
        }
        if ((this.style & 0x10000000) != 0) {
            item.cached = true;
            Event event = new Event();
            event.item = item;
            event.index = this.indexOf(item);
            int mask = 17;
            int signal_id = OS.g_signal_lookup(OS.row_changed, OS.gtk_tree_model_get_type());
            OS.g_signal_handlers_block_matched(this.modelHandle, mask, signal_id, 0, 0L, 0L, this.handle);
            this.currentItem = item;
            this.sendEvent(36, event);
            this.currentItem = null;
            if (this.isDisposed()) {
                return false;
            }
            OS.g_signal_handlers_unblock_matched(this.modelHandle, mask, signal_id, 0, 0L, 0L, this.handle);
            if (item.isDisposed()) {
                return false;
            }
        }
        return true;
    }

    @Override
    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    int calculateWidth(long column, long iter) {
        OS.gtk_tree_view_column_cell_set_cell_data(column, this.modelHandle, iter, false, false);
        if (OS.GTK3) {
            int[] width = new int[1];
            OS.gtk_tree_view_column_cell_get_size(column, null, null, null, width, null);
            return width[0];
        }
        int width = 0;
        int[] w = new int[1];
        OS.gtk_widget_style_get(this.handle, OS.focus_line_width, w, 0L);
        width += 2 * w[0];
        long list = OS.gtk_cell_layout_get_cells(column);
        if (list == 0L) {
            return 0;
        }
        long temp = list;
        while (temp != 0L) {
            long renderer = OS.g_list_data(temp);
            if (renderer != 0L) {
                this.gtk_cell_renderer_get_preferred_size(renderer, this.handle, w, null);
                width += w[0];
            }
            temp = OS.g_list_next(temp);
        }
        OS.g_list_free(list);
        if (OS.gtk_tree_view_get_grid_lines(this.handle) > 0) {
            OS.gtk_widget_style_get(this.handle, OS.grid_line_width, w, 0L);
            width += 2 * w[0];
        }
        return width;
    }

    public void clear(int index) {
        TableItem item;
        this.checkWidget();
        if (index < 0 || index >= this.itemCount) {
            this.error(6);
        }
        if ((item = this.items[index]) != null) {
            item.clear();
        }
    }

    public void clear(int start, int end) {
        this.checkWidget();
        if (start > end) {
            return;
        }
        if (start < 0 || start > end || end >= this.itemCount) {
            this.error(6);
        }
        if (start == 0 && end == this.itemCount - 1) {
            this.clearAll();
        } else {
            int i = start;
            while (i <= end) {
                TableItem item = this.items[i];
                if (item != null) {
                    item.clear();
                }
                ++i;
            }
        }
    }

    public void clear(int[] indices) {
        this.checkWidget();
        if (indices == null) {
            this.error(4);
        }
        if (indices.length == 0) {
            return;
        }
        int i = 0;
        while (i < indices.length) {
            if (indices[i] < 0 || indices[i] >= this.itemCount) {
                this.error(6);
            }
            ++i;
        }
        i = 0;
        while (i < indices.length) {
            TableItem item = this.items[indices[i]];
            if (item != null) {
                item.clear();
            }
            ++i;
        }
    }

    public void clearAll() {
        this.checkWidget();
        int i = 0;
        while (i < this.itemCount) {
            TableItem item = this.items[i];
            if (item != null) {
                item.clear();
            }
            ++i;
        }
    }

    @Override
    Point computeSizeInPixels(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        if (wHint != -1 && wHint < 0) {
            wHint = 0;
        }
        if (hHint != -1 && hHint < 0) {
            hHint = 0;
        }
        Point size = this.computeNativeSize(this.handle, wHint, hHint, changed);
        if (OS.GTK3) {
            if (hHint == -1 && size.y == this.getHeaderHeight()) {
                size.y = this.getItemCount() * this.getItemHeight() + this.getHeaderHeight();
            }
            if (wHint == -1 && size.x == 0 && this.columnCount == 0) {
                size.x = this.maxWidth;
            }
        }
        if (size.y == 0 && hHint == -1) {
            size.y = 64;
        }
        if (size.x == 0 && wHint == -1) {
            size.x = 64;
        }
        Rectangle trim = this.computeTrimInPixels(0, 0, size.x, size.y);
        size.x = trim.width;
        size.y = trim.height;
        return size;
    }

    void createColumn(TableColumn column, int index) {
        long columnHandle;
        int modelIndex = 5;
        if (this.columnCount != 0) {
            int modelLength = OS.gtk_tree_model_get_n_columns(this.modelHandle);
            boolean[] usedColumns = new boolean[modelLength];
            int i = 0;
            while (i < this.columnCount) {
                int columnIndex = this.columns[i].modelIndex;
                int j = 0;
                while (j < 5) {
                    usedColumns[columnIndex + j] = true;
                    ++j;
                }
                ++i;
            }
            while (modelIndex < modelLength) {
                if (!usedColumns[modelIndex]) break;
                ++modelIndex;
            }
            if (modelIndex == modelLength) {
                long oldModel = this.modelHandle;
                long[] types = this.getColumnTypes(this.columnCount + 4);
                long newModel = OS.gtk_list_store_newv(types.length, types);
                if (newModel == 0L) {
                    this.error(2);
                }
                long[] ptr = new long[1];
                int[] ptr1 = new int[1];
                int i2 = 0;
                while (i2 < this.itemCount) {
                    long newItem = OS.g_malloc(OS.GtkTreeIter_sizeof());
                    if (newItem == 0L) {
                        this.error(2);
                    }
                    OS.gtk_list_store_append(newModel, newItem);
                    TableItem item = this.items[i2];
                    if (item != null) {
                        long oldItem = item.handle;
                        int j = 0;
                        while (j < 2) {
                            OS.gtk_tree_model_get(oldModel, oldItem, j, ptr1, -1);
                            OS.gtk_list_store_set(newModel, newItem, j, ptr1[0], -1);
                            ++j;
                        }
                        j = 2;
                        while (j < modelLength) {
                            OS.gtk_tree_model_get(oldModel, oldItem, j, ptr, -1);
                            OS.gtk_list_store_set(newModel, newItem, j, ptr[0], -1);
                            if (ptr[0] != 0L) {
                                if (types[j] == OS.G_TYPE_STRING()) {
                                    OS.g_free(ptr[0]);
                                } else if (types[j] == OS.GDK_TYPE_COLOR()) {
                                    OS.gdk_color_free(ptr[0]);
                                } else if (types[j] == OS.GDK_TYPE_PIXBUF()) {
                                    OS.g_object_unref(ptr[0]);
                                } else if (types[j] == OS.PANGO_TYPE_FONT_DESCRIPTION()) {
                                    OS.pango_font_description_free(ptr[0]);
                                }
                            }
                            ++j;
                        }
                        OS.gtk_list_store_remove(oldModel, oldItem);
                        OS.g_free(oldItem);
                        item.handle = newItem;
                    } else {
                        OS.g_free(newItem);
                    }
                    ++i2;
                }
                OS.gtk_tree_view_set_model(this.handle, newModel);
                this.setModel(newModel);
            }
        }
        if ((columnHandle = OS.gtk_tree_view_column_new()) == 0L) {
            this.error(2);
        }
        if (index == 0 && this.columnCount > 0) {
            TableColumn checkColumn = this.columns[0];
            this.createRenderers(checkColumn.handle, checkColumn.modelIndex, false, checkColumn.style);
        }
        this.createRenderers(columnHandle, modelIndex, index == 0, column == null ? 0 : column.style);
        if ((this.style & 0x10000000) == 0 && this.columnCount == 0) {
            OS.gtk_tree_view_column_set_sizing(columnHandle, 0);
        } else {
            OS.gtk_tree_view_column_set_sizing(columnHandle, 2);
        }
        OS.gtk_tree_view_column_set_resizable(columnHandle, true);
        OS.gtk_tree_view_column_set_clickable(columnHandle, true);
        OS.gtk_tree_view_column_set_min_width(columnHandle, 0);
        OS.gtk_tree_view_insert_column(this.handle, columnHandle, index);
        if (this.columnCount != 0) {
            OS.gtk_tree_view_column_set_visible(columnHandle, false);
        }
        if (column != null) {
            column.handle = columnHandle;
            column.modelIndex = modelIndex;
        }
        if (!this.searchEnabled()) {
            OS.gtk_tree_view_set_search_column(this.handle, -1);
        } else {
            int firstColumn = this.columnCount == 0 ? 5 : this.columns[0].modelIndex;
            OS.gtk_tree_view_set_search_column(this.handle, firstColumn + 1);
        }
    }

    @Override
    void createHandle(int index) {
        this.state |= 8;
        this.fixedHandle = OS.g_object_new(this.display.gtk_fixed_get_type(), 0L);
        if (this.fixedHandle == 0L) {
            this.error(2);
        }
        OS.gtk_widget_set_has_window(this.fixedHandle, true);
        this.scrolledHandle = OS.gtk_scrolled_window_new(0L, 0L);
        if (this.scrolledHandle == 0L) {
            this.error(2);
        }
        long[] types = this.getColumnTypes(1);
        this.modelHandle = OS.gtk_list_store_newv(types.length, types);
        if (this.modelHandle == 0L) {
            this.error(2);
        }
        this.handle = OS.gtk_tree_view_new_with_model(this.modelHandle);
        if (this.handle == 0L) {
            this.error(2);
        }
        if ((this.style & 0x20) != 0) {
            this.checkRenderer = OS.gtk_cell_renderer_toggle_new();
            if (this.checkRenderer == 0L) {
                this.error(2);
            }
            OS.g_object_ref(this.checkRenderer);
        }
        this.createColumn(null, 0);
        OS.gtk_container_add(this.fixedHandle, this.scrolledHandle);
        OS.gtk_container_add(this.scrolledHandle, this.handle);
        int mode = (this.style & 2) != 0 ? 3 : 2;
        long selectionHandle = OS.gtk_tree_view_get_selection(this.handle);
        OS.gtk_tree_selection_set_mode(selectionHandle, mode);
        OS.gtk_tree_view_set_headers_visible(this.handle, false);
        int hsp = (this.style & 0x100) != 0 ? 1 : 2;
        int vsp = (this.style & 0x200) != 0 ? 1 : 2;
        OS.gtk_scrolled_window_set_policy(this.scrolledHandle, hsp, vsp);
        if ((this.style & 0x800) != 0) {
            OS.gtk_scrolled_window_set_shadow_type(this.scrolledHandle, 3);
        }
        if ((this.style & 0x10000000) != 0) {
            OS.g_object_set(this.handle, OS.fixed_height_mode, true, 0L);
        }
        if (!this.searchEnabled()) {
            OS.gtk_tree_view_set_search_column(this.handle, -1);
        }
    }

    void createItem(TableColumn column, int index) {
        long imageHandle;
        long labelHandle;
        if (index < 0 || index > this.columnCount) {
            this.error(6);
        }
        if (this.columnCount == 0) {
            column.handle = OS.gtk_tree_view_get_column(this.handle, 0);
            OS.gtk_tree_view_column_set_sizing(column.handle, 2);
            OS.gtk_tree_view_column_set_visible(column.handle, false);
            column.modelIndex = 5;
            this.createRenderers(column.handle, column.modelIndex, true, column.style);
            column.customDraw = this.firstCustomDraw;
            this.firstCustomDraw = false;
        } else {
            this.createColumn(column, index);
        }
        long boxHandle = this.gtk_box_new(0, false, 3);
        if (boxHandle == 0L) {
            this.error(2);
        }
        if ((labelHandle = OS.gtk_label_new_with_mnemonic(null)) == 0L) {
            this.error(2);
        }
        if ((imageHandle = OS.gtk_image_new()) == 0L) {
            this.error(2);
        }
        OS.gtk_container_add(boxHandle, imageHandle);
        OS.gtk_container_add(boxHandle, labelHandle);
        OS.gtk_widget_show(boxHandle);
        OS.gtk_widget_show(labelHandle);
        column.labelHandle = labelHandle;
        column.imageHandle = imageHandle;
        OS.gtk_tree_view_column_set_widget(column.handle, boxHandle);
        if (OS.GTK3) {
            column.buttonHandle = OS.gtk_tree_view_column_get_button(column.handle);
        } else {
            long widget = OS.gtk_widget_get_parent(boxHandle);
            while (widget != this.handle) {
                if (OS.GTK_IS_BUTTON(widget)) {
                    column.buttonHandle = widget;
                    break;
                }
                widget = OS.gtk_widget_get_parent(widget);
            }
        }
        if (this.columnCount == this.columns.length) {
            TableColumn[] newColumns = new TableColumn[this.columns.length + 4];
            System.arraycopy(this.columns, 0, newColumns, 0, this.columns.length);
            this.columns = newColumns;
        }
        System.arraycopy(this.columns, index, this.columns, index + 1, this.columnCount++ - index);
        this.columns[index] = column;
        if ((this.state & 0x4000) != 0) {
            column.setFontDescription(this.getFontDescription());
        }
        if (this.columnCount >= 1) {
            int i = 0;
            while (i < this.itemCount) {
                Font[] cellFont;
                TableItem item = this.items[i];
                if (item != null && (cellFont = item.cellFont) != null) {
                    Font[] temp = new Font[this.columnCount];
                    System.arraycopy(cellFont, 0, temp, 0, index);
                    System.arraycopy(cellFont, index, temp, index + 1, this.columnCount - index - 1);
                    item.cellFont = temp;
                }
                ++i;
            }
        }
        if (!this.isVisible()) {
            this.forceResize();
        }
    }

    void createItem(TableItem item, int index) {
        if (index < 0 || index > this.itemCount) {
            this.error(6);
        }
        if (this.itemCount == this.items.length) {
            int length = this.drawCount <= 0 ? this.items.length + 4 : Math.max(4, this.items.length * 3 / 2);
            TableItem[] newItems = new TableItem[length];
            System.arraycopy(this.items, 0, newItems, 0, this.items.length);
            this.items = newItems;
        }
        item.handle = OS.g_malloc(OS.GtkTreeIter_sizeof());
        if (item.handle == 0L) {
            this.error(2);
        }
        if (index == this.itemCount) {
            OS.gtk_list_store_append(this.modelHandle, item.handle);
        } else {
            OS.gtk_list_store_insert(this.modelHandle, item.handle, index);
        }
        System.arraycopy(this.items, index, this.items, index + 1, this.itemCount++ - index);
        this.items[index] = item;
    }

    void createRenderers(long columnHandle, int modelIndex, boolean check, int columnStyle) {
        long textRenderer;
        long pixbufRenderer;
        OS.gtk_tree_view_column_clear(columnHandle);
        if ((this.style & 0x20) != 0 && check) {
            OS.gtk_tree_view_column_pack_start(columnHandle, this.checkRenderer, false);
            OS.gtk_tree_view_column_add_attribute(columnHandle, this.checkRenderer, OS.active, 0);
            OS.gtk_tree_view_column_add_attribute(columnHandle, this.checkRenderer, OS.inconsistent, 1);
            if (!this.ownerDraw) {
                OS.gtk_tree_view_column_add_attribute(columnHandle, this.checkRenderer, OS.cell_background_gdk, 3);
            }
            if (this.ownerDraw) {
                OS.gtk_tree_view_column_set_cell_data_func(columnHandle, this.checkRenderer, this.display.cellDataProc, this.handle, 0L);
                OS.g_object_set_qdata(this.checkRenderer, Display.SWT_OBJECT_INDEX1, columnHandle);
            }
        }
        long l = pixbufRenderer = this.ownerDraw ? OS.g_object_new(this.display.gtk_cell_renderer_pixbuf_get_type(), 0L) : OS.gtk_cell_renderer_pixbuf_new();
        if (pixbufRenderer == 0L) {
            this.error(2);
        } else if (!this.ownerDraw && OS.GTK3) {
            OS.gtk_cell_renderer_set_fixed_size(pixbufRenderer, 0, 0);
        }
        long l2 = textRenderer = this.ownerDraw ? OS.g_object_new(this.display.gtk_cell_renderer_text_get_type(), 0L) : OS.gtk_cell_renderer_text_new();
        if (textRenderer == 0L) {
            this.error(2);
        }
        if (this.ownerDraw) {
            OS.g_object_set_qdata(pixbufRenderer, Display.SWT_OBJECT_INDEX1, columnHandle);
            OS.g_object_set_qdata(textRenderer, Display.SWT_OBJECT_INDEX1, columnHandle);
        }
        if ((this.style & 0x20) != 0 && check) {
            OS.g_object_set(pixbufRenderer, OS.mode, 1, 0L);
        }
        if ((columnStyle & 0x20000) != 0) {
            OS.g_object_set(textRenderer, OS.xalign, 1.0f, 0L);
            OS.gtk_tree_view_column_pack_end(columnHandle, textRenderer, true);
            OS.gtk_tree_view_column_pack_end(columnHandle, pixbufRenderer, false);
            OS.gtk_tree_view_column_set_alignment(columnHandle, 1.0f);
        } else if ((columnStyle & 0x1000000) != 0) {
            OS.g_object_set(textRenderer, OS.xalign, 0.5f, 0L);
            OS.gtk_tree_view_column_pack_start(columnHandle, pixbufRenderer, false);
            OS.gtk_tree_view_column_pack_end(columnHandle, textRenderer, true);
            OS.gtk_tree_view_column_set_alignment(columnHandle, 0.5f);
        } else {
            OS.gtk_tree_view_column_pack_start(columnHandle, pixbufRenderer, false);
            OS.gtk_tree_view_column_pack_start(columnHandle, textRenderer, true);
            OS.gtk_tree_view_column_set_alignment(columnHandle, 0.0f);
        }
        OS.gtk_tree_view_column_add_attribute(columnHandle, pixbufRenderer, OS.pixbuf, modelIndex + 0);
        if (!this.ownerDraw) {
            OS.gtk_tree_view_column_add_attribute(columnHandle, pixbufRenderer, OS.cell_background_gdk, 3);
            OS.gtk_tree_view_column_add_attribute(columnHandle, textRenderer, OS.cell_background_gdk, 3);
        }
        OS.gtk_tree_view_column_add_attribute(columnHandle, textRenderer, OS.text, modelIndex + 1);
        OS.gtk_tree_view_column_add_attribute(columnHandle, textRenderer, OS.foreground_gdk, 2);
        OS.gtk_tree_view_column_add_attribute(columnHandle, textRenderer, OS.font_desc, 4);
        boolean customDraw = this.firstCustomDraw;
        if (this.columnCount != 0) {
            int i = 0;
            while (i < this.columnCount) {
                if (this.columns[i].handle == columnHandle) {
                    customDraw = this.columns[i].customDraw;
                    break;
                }
                ++i;
            }
        }
        if ((this.style & 0x10000000) != 0 || customDraw || this.ownerDraw) {
            OS.gtk_tree_view_column_set_cell_data_func(columnHandle, textRenderer, this.display.cellDataProc, this.handle, 0L);
            OS.gtk_tree_view_column_set_cell_data_func(columnHandle, pixbufRenderer, this.display.cellDataProc, this.handle, 0L);
        }
    }

    @Override
    void createWidget(int index) {
        super.createWidget(index);
        this.items = new TableItem[4];
        this.columns = new TableColumn[4];
        this.columnCount = 0;
        this.itemCount = 0;
        if (OS.GTK3) {
            this.setFontDescription(this.defaultFont().handle);
        }
    }

    @Override
    int applyThemeBackground() {
        return -1;
    }

    GdkColor defaultBackground() {
        return this.display.COLOR_LIST_BACKGROUND;
    }

    GdkColor defaultForeground() {
        return this.display.COLOR_LIST_FOREGROUND;
    }

    @Override
    void deregister() {
        super.deregister();
        this.display.removeWidget(OS.gtk_tree_view_get_selection(this.handle));
        if (this.checkRenderer != 0L) {
            this.display.removeWidget(this.checkRenderer);
        }
        this.display.removeWidget(this.modelHandle);
    }

    public void deselect(int index) {
        this.checkWidget();
        if (index < 0 || index >= this.itemCount) {
            return;
        }
        boolean fixColumn = this.showFirstColumn();
        long selection = OS.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(selection, 16, 0, 0, 0L, 0L, 6L);
        OS.gtk_tree_selection_unselect_iter(selection, this._getItem((int)index).handle);
        OS.g_signal_handlers_unblock_matched(selection, 16, 0, 0, 0L, 0L, 6L);
        if (fixColumn) {
            this.hideFirstColumn();
        }
    }

    public void deselect(int start, int end) {
        this.checkWidget();
        boolean fixColumn = this.showFirstColumn();
        long selection = OS.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(selection, 16, 0, 0, 0L, 0L, 6L);
        int index = start;
        while (index <= end) {
            if (index >= 0 && index < this.itemCount) {
                OS.gtk_tree_selection_unselect_iter(selection, this._getItem((int)index).handle);
            }
            ++index;
        }
        OS.g_signal_handlers_unblock_matched(selection, 16, 0, 0, 0L, 0L, 6L);
        if (fixColumn) {
            this.hideFirstColumn();
        }
    }

    public void deselect(int[] indices) {
        this.checkWidget();
        if (indices == null) {
            this.error(4);
        }
        boolean fixColumn = this.showFirstColumn();
        long selection = OS.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(selection, 16, 0, 0, 0L, 0L, 6L);
        int i = 0;
        while (i < indices.length) {
            int index = indices[i];
            if (index >= 0 && index < this.itemCount) {
                OS.gtk_tree_selection_unselect_iter(selection, this._getItem((int)index).handle);
            }
            ++i;
        }
        OS.g_signal_handlers_unblock_matched(selection, 16, 0, 0, 0L, 0L, 6L);
        if (fixColumn) {
            this.hideFirstColumn();
        }
    }

    public void deselectAll() {
        this.checkWidget();
        boolean fixColumn = this.showFirstColumn();
        long selection = OS.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(selection, 16, 0, 0, 0L, 0L, 6L);
        OS.gtk_tree_selection_unselect_all(selection);
        OS.g_signal_handlers_unblock_matched(selection, 16, 0, 0, 0L, 0L, 6L);
        if (fixColumn) {
            this.hideFirstColumn();
        }
    }

    void destroyItem(TableColumn column) {
        int index = 0;
        while (index < this.columnCount) {
            if (this.columns[index] == column) break;
            ++index;
        }
        if (index == this.columnCount) {
            return;
        }
        long columnHandle = column.handle;
        if (this.columnCount == 1) {
            this.firstCustomDraw = column.customDraw;
        }
        System.arraycopy(this.columns, index + 1, this.columns, index, --this.columnCount - index);
        this.columns[this.columnCount] = null;
        OS.gtk_tree_view_remove_column(this.handle, columnHandle);
        if (this.columnCount == 0) {
            long oldModel = this.modelHandle;
            long[] types = this.getColumnTypes(1);
            long newModel = OS.gtk_list_store_newv(types.length, types);
            if (newModel == 0L) {
                this.error(2);
            }
            long[] ptr = new long[1];
            int[] ptr1 = new int[1];
            int i = 0;
            while (i < this.itemCount) {
                long newItem = OS.g_malloc(OS.GtkTreeIter_sizeof());
                if (newItem == 0L) {
                    this.error(2);
                }
                OS.gtk_list_store_append(newModel, newItem);
                TableItem item = this.items[i];
                if (item != null) {
                    long oldItem = item.handle;
                    int j = 0;
                    while (j < 2) {
                        OS.gtk_tree_model_get(oldModel, oldItem, j, ptr1, -1);
                        OS.gtk_list_store_set(newModel, newItem, j, ptr1[0], -1);
                        ++j;
                    }
                    j = 2;
                    while (j < 5) {
                        OS.gtk_tree_model_get(oldModel, oldItem, j, ptr, -1);
                        OS.gtk_list_store_set(newModel, newItem, j, ptr[0], -1);
                        if (ptr[0] != 0L) {
                            if (j == 2 || j == 3) {
                                OS.gdk_color_free(ptr[0]);
                            } else if (j == 4) {
                                OS.pango_font_description_free(ptr[0]);
                            }
                        }
                        ++j;
                    }
                    OS.gtk_tree_model_get(oldModel, oldItem, column.modelIndex + 0, ptr, -1);
                    OS.gtk_list_store_set(newModel, newItem, 5, ptr[0], -1);
                    if (ptr[0] != 0L) {
                        OS.g_object_unref(ptr[0]);
                    }
                    OS.gtk_tree_model_get(oldModel, oldItem, column.modelIndex + 1, ptr, -1);
                    OS.gtk_list_store_set(newModel, newItem, 6, ptr[0], -1);
                    OS.g_free(ptr[0]);
                    OS.gtk_tree_model_get(oldModel, oldItem, column.modelIndex + 2, ptr, -1);
                    OS.gtk_list_store_set(newModel, newItem, 7, ptr[0], -1);
                    if (ptr[0] != 0L) {
                        OS.gdk_color_free(ptr[0]);
                    }
                    OS.gtk_tree_model_get(oldModel, oldItem, column.modelIndex + 3, ptr, -1);
                    OS.gtk_list_store_set(newModel, newItem, 8, ptr[0], -1);
                    if (ptr[0] != 0L) {
                        OS.gdk_color_free(ptr[0]);
                    }
                    OS.gtk_tree_model_get(oldModel, oldItem, column.modelIndex + 4, ptr, -1);
                    OS.gtk_list_store_set(newModel, newItem, 9, ptr[0], -1);
                    if (ptr[0] != 0L) {
                        OS.pango_font_description_free(ptr[0]);
                    }
                    OS.gtk_list_store_remove(oldModel, oldItem);
                    OS.g_free(oldItem);
                    item.handle = newItem;
                } else {
                    OS.g_free(newItem);
                }
                ++i;
            }
            OS.gtk_tree_view_set_model(this.handle, newModel);
            this.setModel(newModel);
            this.createColumn(null, 0);
        } else {
            int i = 0;
            while (i < this.itemCount) {
                TableItem item = this.items[i];
                if (item != null) {
                    long iter = item.handle;
                    int modelIndex = column.modelIndex;
                    OS.gtk_list_store_set(this.modelHandle, iter, modelIndex + 0, 0L, -1);
                    OS.gtk_list_store_set(this.modelHandle, iter, modelIndex + 1, 0L, -1);
                    OS.gtk_list_store_set(this.modelHandle, iter, modelIndex + 2, 0L, -1);
                    OS.gtk_list_store_set(this.modelHandle, iter, modelIndex + 3, 0L, -1);
                    OS.gtk_list_store_set(this.modelHandle, iter, modelIndex + 4, 0L, -1);
                    Font[] cellFont = item.cellFont;
                    if (cellFont != null) {
                        if (this.columnCount == 0) {
                            item.cellFont = null;
                        } else {
                            Font[] temp = new Font[this.columnCount];
                            System.arraycopy(cellFont, 0, temp, 0, index);
                            System.arraycopy(cellFont, index + 1, temp, index, this.columnCount - index);
                            item.cellFont = temp;
                        }
                    }
                }
                ++i;
            }
            if (index == 0) {
                TableColumn checkColumn = this.columns[0];
                this.createRenderers(checkColumn.handle, checkColumn.modelIndex, true, checkColumn.style);
            }
        }
        if (!this.searchEnabled()) {
            OS.gtk_tree_view_set_search_column(this.handle, -1);
        } else {
            int firstColumn = this.columnCount == 0 ? 5 : this.columns[0].modelIndex;
            OS.gtk_tree_view_set_search_column(this.handle, firstColumn + 1);
        }
    }

    void destroyItem(TableItem item) {
        int index = 0;
        while (index < this.itemCount) {
            if (this.items[index] == item) break;
            ++index;
        }
        if (index == this.itemCount) {
            return;
        }
        long selection = OS.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(selection, 16, 0, 0, 0L, 0L, 6L);
        OS.gtk_list_store_remove(this.modelHandle, item.handle);
        OS.g_signal_handlers_unblock_matched(selection, 16, 0, 0, 0L, 0L, 6L);
        System.arraycopy(this.items, index + 1, this.items, index, --this.itemCount - index);
        this.items[this.itemCount] = null;
        if (this.itemCount == 0) {
            this.resetCustomDraw();
        }
    }

    @Override
    boolean dragDetect(int x, int y, boolean filter, boolean dragOnTimeout, boolean[] consume) {
        boolean selected = false;
        if (OS.isX11()) {
            boolean dragDetect;
            if (filter) {
                long[] path = new long[1];
                if (OS.gtk_tree_view_get_path_at_pos(this.handle, x, y, path, null, null, null)) {
                    if (path[0] != 0L) {
                        long selection = OS.gtk_tree_view_get_selection(this.handle);
                        if (OS.gtk_tree_selection_path_is_selected(selection, path[0])) {
                            selected = true;
                        }
                        OS.gtk_tree_path_free(path[0]);
                    }
                } else {
                    return false;
                }
            }
            if ((dragDetect = super.dragDetect(x, y, filter, false, consume)) && selected && consume != null) {
                consume[0] = true;
            }
            return dragDetect;
        }
        double[] startX = new double[1];
        double[] startY = new double[1];
        long[] path = new long[1];
        if (OS.gtk_gesture_drag_get_start_point(this.dragGesture, startX, startY)) {
            if (this.getHeaderVisible()) {
                startY[0] = startY[0] - (double)this.getHeaderHeightInPixels();
            }
            if (OS.gtk_tree_view_get_path_at_pos(this.handle, (int)startX[0], (int)startY[0], path, null, null, null)) {
                if (path[0] != 0L) {
                    boolean dragDetect = super.dragDetect(x, y, filter, false, consume);
                    if (dragDetect && selected && consume != null) {
                        consume[0] = true;
                    }
                    return dragDetect;
                }
            } else {
                return false;
            }
        }
        return false;
    }

    @Override
    long eventWindow() {
        return this.paintWindow();
    }

    boolean fixAccessibility() {
        return true;
    }

    @Override
    void fixChildren(Shell newShell, Shell oldShell, Decorations newDecorations, Decorations oldDecorations, Menu[] menus) {
        super.fixChildren(newShell, oldShell, newDecorations, oldDecorations, menus);
        int i = 0;
        while (i < this.columnCount) {
            TableColumn column = this.columns[i];
            if (column.toolTipText != null) {
                column.setToolTipText(oldShell, null);
                column.setToolTipText(newShell, column.toolTipText);
            }
            ++i;
        }
    }

    @Override
    GdkColor getBackgroundColor() {
        return this.getBaseColor();
    }

    @Override
    Rectangle getClientAreaInPixels() {
        this.checkWidget();
        this.forceResize();
        OS.gtk_widget_realize(this.handle);
        long fixedWindow = this.gtk_widget_get_window(this.fixedHandle);
        long binWindow = OS.gtk_tree_view_get_bin_window(this.handle);
        int[] binX = new int[1];
        int[] binY = new int[1];
        OS.gdk_window_get_origin(binWindow, binX, binY);
        int[] fixedX = new int[1];
        int[] fixedY = new int[1];
        OS.gdk_window_get_origin(fixedWindow, fixedX, fixedY);
        long clientHandle = this.clientHandle();
        GtkAllocation allocation = new GtkAllocation();
        OS.gtk_widget_get_allocation(clientHandle, allocation);
        int width = (this.state & 0x200) != 0 ? 0 : allocation.width;
        int height = (this.state & 0x400) != 0 ? 0 : allocation.height;
        Rectangle rect = new Rectangle(fixedX[0] - binX[0], fixedY[0] - binY[0], width, height);
        if (this.getHeaderVisible() && OS.GTK_VERSION > OS.VERSION(3, 9, 0)) {
            rect.y += this.getHeaderHeightInPixels();
        }
        return rect;
    }

    @Override
    int getClientWidth() {
        int[] w = new int[1];
        int[] h = new int[1];
        OS.gtk_widget_realize(this.handle);
        this.gdk_window_get_size(OS.gtk_tree_view_get_bin_window(this.handle), w, h);
        return w[0];
    }

    public TableColumn getColumn(int index) {
        this.checkWidget();
        if (index < 0 || index >= this.columnCount) {
            this.error(6);
        }
        return this.columns[index];
    }

    public int getColumnCount() {
        this.checkWidget();
        return this.columnCount;
    }

    long[] getColumnTypes(int columnCount) {
        long[] types = new long[5 + columnCount * 5];
        types[0] = OS.G_TYPE_BOOLEAN();
        types[1] = OS.G_TYPE_BOOLEAN();
        types[2] = OS.GDK_TYPE_COLOR();
        types[3] = OS.GDK_TYPE_COLOR();
        types[4] = OS.PANGO_TYPE_FONT_DESCRIPTION();
        int i = 5;
        while (i < types.length) {
            types[i + 0] = OS.GDK_TYPE_PIXBUF();
            types[i + 1] = OS.G_TYPE_STRING();
            types[i + 2] = OS.GDK_TYPE_COLOR();
            types[i + 3] = OS.GDK_TYPE_COLOR();
            types[i + 4] = OS.PANGO_TYPE_FONT_DESCRIPTION();
            i += 5;
        }
        return types;
    }

    public int[] getColumnOrder() {
        this.checkWidget();
        if (this.columnCount == 0) {
            return new int[0];
        }
        long list = OS.gtk_tree_view_get_columns(this.handle);
        if (list == 0L) {
            return new int[0];
        }
        int i = 0;
        int count = OS.g_list_length(list);
        int[] order = new int[count];
        long temp = list;
        while (temp != 0L) {
            long column = OS.g_list_data(temp);
            if (column != 0L) {
                int j = 0;
                while (j < this.columnCount) {
                    if (this.columns[j].handle == column) {
                        order[i++] = j;
                        break;
                    }
                    ++j;
                }
            }
            temp = OS.g_list_next(temp);
        }
        OS.g_list_free(list);
        return order;
    }

    public TableColumn[] getColumns() {
        this.checkWidget();
        TableColumn[] result = new TableColumn[this.columnCount];
        System.arraycopy(this.columns, 0, result, 0, this.columnCount);
        return result;
    }

    @Override
    GdkColor getContextBackground() {
        if (OS.GTK_VERSION >= OS.VERSION(3, 16, 0)) {
            if (this.background != null) {
                return this.display.toGdkColor(this.background);
            }
            return this.display.COLOR_LIST_BACKGROUND;
        }
        return super.getContextBackground();
    }

    @Override
    GdkColor getContextColor() {
        if (OS.GTK_VERSION >= OS.VERSION(3, 16, 0)) {
            if (this.foreground != null) {
                return this.display.toGdkColor(this.foreground);
            }
            return this.display.COLOR_LIST_FOREGROUND;
        }
        return super.getContextColor();
    }

    TableItem getFocusItem() {
        long[] path = new long[1];
        OS.gtk_tree_view_get_cursor(this.handle, path, null);
        if (path[0] == 0L) {
            return null;
        }
        TableItem item = null;
        long indices = OS.gtk_tree_path_get_indices(path[0]);
        if (indices != 0L) {
            int[] index = new int[]{-1};
            OS.memmove(index, indices, 4L);
            item = this._getItem(index[0]);
        }
        OS.gtk_tree_path_free(path[0]);
        return item;
    }

    @Override
    GdkColor getForegroundColor() {
        return this.getTextColor();
    }

    public int getGridLineWidth() {
        this.checkWidget();
        return DPIUtil.autoScaleDown(this.getGridLineWidthInPixels());
    }

    int getGridLineWidthInPixels() {
        this.checkWidget();
        return 0;
    }

    public Color getHeaderBackground() {
        this.checkWidget();
        return this.headerBackground != null ? this.headerBackground : this.display.getSystemColor(25);
    }

    public Color getHeaderForeground() {
        this.checkWidget();
        return this.headerForeground != null ? this.headerForeground : this.display.getSystemColor(24);
    }

    public int getHeaderHeight() {
        this.checkWidget();
        return DPIUtil.autoScaleDown(this.getHeaderHeightInPixels());
    }

    int getHeaderHeightInPixels() {
        this.checkWidget();
        if (!OS.gtk_tree_view_get_headers_visible(this.handle)) {
            return 0;
        }
        if (this.columnCount > 0) {
            GtkRequisition requisition = new GtkRequisition();
            int height = 0;
            int i = 0;
            while (i < this.columnCount) {
                long buttonHandle = this.columns[i].buttonHandle;
                if (buttonHandle != 0L) {
                    if (OS.GTK_VERSION >= OS.VERSION(3, 8, 0) && !OS.gtk_widget_get_visible(buttonHandle)) {
                        OS.gtk_widget_show(buttonHandle);
                        this.gtk_widget_get_preferred_size(buttonHandle, requisition);
                        OS.gtk_widget_hide(buttonHandle);
                    } else {
                        this.gtk_widget_get_preferred_size(buttonHandle, requisition);
                    }
                    height = Math.max(height, requisition.height);
                }
                ++i;
            }
            return height;
        }
        OS.gtk_widget_realize(this.handle);
        long fixedWindow = this.gtk_widget_get_window(this.fixedHandle);
        long binWindow = OS.gtk_tree_view_get_bin_window(this.handle);
        int[] binY = new int[1];
        OS.gdk_window_get_origin(binWindow, null, binY);
        int[] fixedY = new int[1];
        OS.gdk_window_get_origin(fixedWindow, null, fixedY);
        return binY[0] - fixedY[0];
    }

    public boolean getHeaderVisible() {
        this.checkWidget();
        return OS.gtk_tree_view_get_headers_visible(this.handle);
    }

    public TableItem getItem(int index) {
        this.checkWidget();
        if (index < 0 || index >= this.itemCount) {
            this.error(6);
        }
        return this._getItem(index);
    }

    public TableItem getItem(Point point) {
        this.checkWidget();
        return this.getItemInPixels(DPIUtil.autoScaleUp(point));
    }

    TableItem getItemInPixels(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        long[] path = new long[1];
        OS.gtk_widget_realize(this.handle);
        int y = point.y;
        if (this.getHeaderVisible() && OS.GTK_VERSION > OS.VERSION(3, 9, 0)) {
            y -= this.getHeaderHeightInPixels();
        }
        if (!OS.gtk_tree_view_get_path_at_pos(this.handle, point.x, y, path, null, null, null)) {
            return null;
        }
        if (path[0] == 0L) {
            return null;
        }
        long indices = OS.gtk_tree_path_get_indices(path[0]);
        TableItem item = null;
        if (indices != 0L) {
            int[] index = new int[1];
            OS.memmove(index, indices, 4L);
            item = this._getItem(index[0]);
        }
        OS.gtk_tree_path_free(path[0]);
        return item;
    }

    public int getItemCount() {
        this.checkWidget();
        return this.itemCount;
    }

    public int getItemHeight() {
        this.checkWidget();
        return DPIUtil.autoScaleDown(this.getItemHeightInPixels());
    }

    int getItemHeightInPixels() {
        this.checkWidget();
        if (this.itemCount == 0) {
            long column = OS.gtk_tree_view_get_column(this.handle, 0);
            int[] w = new int[1];
            int[] h = new int[1];
            this.ignoreSize = true;
            OS.gtk_tree_view_column_cell_get_size(column, null, null, null, w, h);
            int height = h[0];
            if (OS.GTK3) {
                long textRenderer = this.getTextRenderer(column);
                OS.gtk_cell_renderer_get_preferred_height_for_width(textRenderer, this.handle, 0, h, null);
                height += h[0];
            }
            this.ignoreSize = false;
            return height;
        }
        int height = 0;
        long iter = OS.g_malloc(OS.GtkTreeIter_sizeof());
        OS.gtk_tree_model_get_iter_first(this.modelHandle, iter);
        int columnCount = Math.max(1, this.columnCount);
        int i = 0;
        while (i < columnCount) {
            long column = OS.gtk_tree_view_get_column(this.handle, i);
            OS.gtk_tree_view_column_cell_set_cell_data(column, this.modelHandle, iter, false, false);
            int[] w = new int[1];
            int[] h = new int[1];
            OS.gtk_tree_view_column_cell_get_size(column, null, null, null, w, h);
            height = Math.max(height, h[0]);
            ++i;
        }
        OS.g_free(iter);
        return height;
    }

    public TableItem[] getItems() {
        this.checkWidget();
        TableItem[] result = new TableItem[this.itemCount];
        if ((this.style & 0x10000000) != 0) {
            int i = 0;
            while (i < this.itemCount) {
                result[i] = this._getItem(i);
                ++i;
            }
        } else {
            System.arraycopy(this.items, 0, result, 0, this.itemCount);
        }
        return result;
    }

    public boolean getLinesVisible() {
        this.checkWidget();
        if (OS.GTK3) {
            return OS.gtk_tree_view_get_grid_lines(this.handle) > 0;
        }
        return OS.gtk_tree_view_get_rules_hint(this.handle);
    }

    long getPixbufRenderer(long column) {
        long list = OS.gtk_cell_layout_get_cells(column);
        if (list == 0L) {
            return 0L;
        }
        long originalList = list;
        long pixbufRenderer = 0L;
        while (list != 0L) {
            long renderer = OS.g_list_data(list);
            if (OS.GTK_IS_CELL_RENDERER_PIXBUF(renderer)) {
                pixbufRenderer = renderer;
                break;
            }
            list = OS.g_list_next(list);
        }
        OS.g_list_free(originalList);
        return pixbufRenderer;
    }

    public TableItem[] getSelection() {
        long list;
        this.checkWidget();
        long selection = OS.gtk_tree_view_get_selection(this.handle);
        long originalList = list = OS.gtk_tree_selection_get_selected_rows(selection, null);
        if (list != 0L) {
            int count = OS.g_list_length(list);
            int[] treeSelection = new int[count];
            int length = 0;
            int i = 0;
            while (i < count) {
                long data = OS.g_list_data(list);
                long indices = OS.gtk_tree_path_get_indices(data);
                if (indices != 0L) {
                    int[] index = new int[1];
                    OS.memmove(index, indices, 4L);
                    treeSelection[length] = index[0];
                    ++length;
                }
                OS.gtk_tree_path_free(data);
                list = OS.g_list_next(list);
                ++i;
            }
            OS.g_list_free(originalList);
            TableItem[] result = new TableItem[length];
            int i2 = 0;
            while (i2 < result.length) {
                result[i2] = this._getItem(treeSelection[i2]);
                ++i2;
            }
            return result;
        }
        return new TableItem[0];
    }

    public int getSelectionCount() {
        this.checkWidget();
        long selection = OS.gtk_tree_view_get_selection(this.handle);
        return OS.gtk_tree_selection_count_selected_rows(selection);
    }

    public int getSelectionIndex() {
        long list;
        this.checkWidget();
        long selection = OS.gtk_tree_view_get_selection(this.handle);
        long originalList = list = OS.gtk_tree_selection_get_selected_rows(selection, null);
        if (list != 0L) {
            int[] index = new int[1];
            boolean foundIndex = false;
            while (list != 0L) {
                long indices;
                long data = OS.g_list_data(list);
                if (!foundIndex && (indices = OS.gtk_tree_path_get_indices(data)) != 0L) {
                    OS.memmove(index, indices, 4L);
                    foundIndex = true;
                }
                list = OS.g_list_next(list);
                OS.gtk_tree_path_free(data);
            }
            OS.g_list_free(originalList);
            return index[0];
        }
        return -1;
    }

    public int[] getSelectionIndices() {
        long list;
        this.checkWidget();
        long selection = OS.gtk_tree_view_get_selection(this.handle);
        long originalList = list = OS.gtk_tree_selection_get_selected_rows(selection, null);
        if (list != 0L) {
            int count = OS.g_list_length(list);
            int[] treeSelection = new int[count];
            int length = 0;
            int i = 0;
            while (i < count) {
                long data = OS.g_list_data(list);
                long indices = OS.gtk_tree_path_get_indices(data);
                if (indices != 0L) {
                    int[] index = new int[1];
                    OS.memmove(index, indices, 4L);
                    treeSelection[length] = index[0];
                    ++length;
                }
                list = OS.g_list_next(list);
                OS.gtk_tree_path_free(data);
                ++i;
            }
            OS.g_list_free(originalList);
            int[] result = new int[length];
            System.arraycopy(treeSelection, 0, result, 0, length);
            return result;
        }
        return new int[0];
    }

    public TableColumn getSortColumn() {
        this.checkWidget();
        return this.sortColumn;
    }

    public int getSortDirection() {
        this.checkWidget();
        return this.sortDirection;
    }

    long getTextRenderer(long column) {
        long list = OS.gtk_cell_layout_get_cells(column);
        if (list == 0L) {
            return 0L;
        }
        long originalList = list;
        long textRenderer = 0L;
        while (list != 0L) {
            long renderer = OS.g_list_data(list);
            if (OS.GTK_IS_CELL_RENDERER_TEXT(renderer)) {
                textRenderer = renderer;
                break;
            }
            list = OS.g_list_next(list);
        }
        OS.g_list_free(originalList);
        return textRenderer;
    }

    public int getTopIndex() {
        this.checkWidget();
        long vAdjustment = OS.GTK3 ? OS.gtk_scrollable_get_vadjustment(this.handle) : OS.gtk_tree_view_get_vadjustment(this.handle);
        this.currentAdjustment = OS.gtk_adjustment_get_value(vAdjustment);
        if (this.cachedAdjustment == this.currentAdjustment) {
            return this.topIndex;
        }
        long[] path = new long[1];
        OS.gtk_widget_realize(this.handle);
        if (!OS.gtk_tree_view_get_path_at_pos(this.handle, 1, 1, path, null, null, null)) {
            return 0;
        }
        if (path[0] == 0L) {
            return 0;
        }
        long indices = OS.gtk_tree_path_get_indices(path[0]);
        int[] index = new int[1];
        if (indices != 0L) {
            OS.memmove(index, indices, 4L);
        }
        OS.gtk_tree_path_free(path[0]);
        return index[0];
    }

    @Override
    long gtk_button_press_event(long widget, long event) {
        long[] path;
        int button;
        GdkEventButton gdkEvent = new GdkEventButton();
        OS.memmove(gdkEvent, event, (long)GdkEventButton.sizeof);
        if (gdkEvent.window != OS.gtk_tree_view_get_bin_window(this.handle)) {
            return 0L;
        }
        long result = super.gtk_button_press_event(widget, event);
        if (result != 0L) {
            return result;
        }
        if ((this.state & 0x800000) != 0 && this.hooks(29) && !OS.isX11() && gdkEvent.type == 4) {
            long nextEvent = OS.gdk_event_peek();
            if (nextEvent == 0L) {
                long[] path2 = new long[1];
                long selection = OS.gtk_tree_view_get_selection(this.handle);
                if (OS.gtk_tree_view_get_path_at_pos(this.handle, (int)gdkEvent.x, (int)gdkEvent.y, path2, null, null, null) && path2[0] != 0L) {
                    this.selectionCountOnPress = this.getSelectionCount();
                    if (OS.gtk_tree_selection_path_is_selected(selection, path2[0]) && ((gdkEvent.state & 5) == 0 || (gdkEvent.state & 4) != 0)) {
                        long gtk_false_funcPtr = OS.GET_FUNCTION_POINTER_gtk_false();
                        OS.gtk_tree_selection_set_select_function(selection, gtk_false_funcPtr, 0L, 0L);
                    }
                }
            } else {
                OS.gdk_event_free(nextEvent);
            }
        }
        if ((button = gdkEvent.button) == 3 && gdkEvent.type == 4 && OS.gtk_tree_view_get_path_at_pos(this.handle, (int)gdkEvent.x, (int)gdkEvent.y, path = new long[1], null, null, null) && path[0] != 0L) {
            long selection = OS.gtk_tree_view_get_selection(this.handle);
            if (OS.gtk_tree_selection_path_is_selected(selection, path[0])) {
                result = 1L;
            }
            OS.gtk_tree_path_free(path[0]);
        }
        if ((this.style & 4) != 0 && this.getSelectionCount() == 0 && OS.gtk_tree_view_get_path_at_pos(this.handle, (int)gdkEvent.x, (int)gdkEvent.y, path = new long[1], null, null, null) && path[0] != 0L) {
            long selection = OS.gtk_tree_view_get_selection(this.handle);
            OS.g_signal_handlers_block_matched(selection, 16, 0, 0, 0L, 0L, 6L);
            OS.gtk_tree_view_set_cursor(this.handle, path[0], 0L, false);
            OS.g_signal_handlers_unblock_matched(selection, 16, 0, 0, 0L, 0L, 6L);
            OS.gtk_tree_path_free(path[0]);
        }
        if (gdkEvent.type == 5) {
            this.sendTreeDefaultSelection();
        }
        return result;
    }

    @Override
    long gtk_key_press_event(long widget, long event) {
        GdkEventKey keyEvent = new GdkEventKey();
        OS.memmove(keyEvent, event, (long)GdkEventKey.sizeof);
        int key = keyEvent.keyval;
        this.keyPressDefaultSelectionHandler(event, key);
        return super.gtk_key_press_event(widget, event);
    }

    void keyPressDefaultSelectionHandler(long event, int key) {
        int keymask = this.gdk_event_get_state(event);
        switch (key) {
            case 65293: {
                if ((keymask & 0x1C000000) != 0) break;
                this.sendTreeDefaultSelection();
            }
        }
    }

    void sendTreeDefaultSelection() {
        TableItem tableItem = this.getFocusItem();
        if (tableItem == null) {
            return;
        }
        Event event = new Event();
        event.item = tableItem;
        this.sendSelectionEvent(14, event, false);
    }

    @Override
    long gtk_button_release_event(long widget, long event) {
        GdkEventButton gdkEvent = new GdkEventButton();
        OS.memmove(gdkEvent, event, (long)GdkEventButton.sizeof);
        if (gdkEvent.window != OS.gtk_tree_view_get_bin_window(this.handle)) {
            return 0L;
        }
        if ((this.state & 0x800000) != 0 && this.hooks(29) && !OS.isX11()) {
            long[] path = new long[1];
            long selection = OS.gtk_tree_view_get_selection(this.handle);
            OS.gtk_tree_selection_set_select_function(selection, 0L, 0L, 0L);
            if (OS.gtk_tree_view_get_path_at_pos(this.handle, (int)gdkEvent.x, (int)gdkEvent.y, path, null, null, null) && path[0] != 0L && OS.gtk_tree_selection_path_is_selected(selection, path[0])) {
                this.selectionCountOnRelease = this.getSelectionCount();
                if ((gdkEvent.state & 5) == 0) {
                    OS.gtk_tree_view_set_cursor(this.handle, path[0], 0L, false);
                }
                if ((gdkEvent.state & 4) != 0 && this.selectionCountOnRelease == this.selectionCountOnPress) {
                    OS.gtk_tree_selection_unselect_path(selection, path[0]);
                }
            }
        }
        return super.gtk_button_release_event(widget, event);
    }

    @Override
    long gtk_changed(long widget) {
        TableItem item = this.getFocusItem();
        if (item != null) {
            Event event = new Event();
            event.item = item;
            this.sendSelectionEvent(13, event, false);
        }
        return 0L;
    }

    @Override
    long gtk_event_after(long widget, long gdkEvent) {
        switch (OS.GDK_EVENT_TYPE(gdkEvent)) {
            case 2: {
                if (OS.gtk_tree_model_iter_n_children(this.modelHandle, 0L) != 0) break;
                this.gtk_expose_event(widget, gdkEvent);
            }
        }
        return super.gtk_event_after(widget, gdkEvent);
    }

    void drawInheritedBackground(long eventPtr, long cairo) {
        Control control;
        if (((this.state & 0x8000) != 0 || this.backgroundImage != null) && (control = this.findBackgroundControl()) != null) {
            long window = OS.gtk_tree_view_get_bin_window(this.handle);
            long rgn = 0L;
            if (eventPtr != 0L) {
                GdkEventExpose gdkEvent = new GdkEventExpose();
                OS.memmove(gdkEvent, eventPtr, (long)GdkEventExpose.sizeof);
                if (window != gdkEvent.window) {
                    return;
                }
                rgn = gdkEvent.region;
            }
            int[] width = new int[1];
            int[] height = new int[1];
            this.gdk_window_get_size(window, width, height);
            int bottom = 0;
            if (this.itemCount != 0) {
                long iter = OS.g_malloc(OS.GtkTreeIter_sizeof());
                OS.gtk_tree_model_iter_nth_child(this.modelHandle, iter, 0L, this.itemCount - 1);
                long path = OS.gtk_tree_model_get_path(this.modelHandle, iter);
                GdkRectangle rect = new GdkRectangle();
                OS.gtk_tree_view_get_cell_area(this.handle, path, 0L, rect);
                bottom = rect.y + rect.height;
                OS.gtk_tree_path_free(path);
                OS.g_free(iter);
            }
            if (height[0] > bottom) {
                this.drawBackground(control, window, cairo, rgn, 0, bottom, width[0], height[0] - bottom);
            }
        }
    }

    @Override
    long gtk_draw(long widget, long cairo) {
        if ((this.state & 0x40) != 0) {
            return 0L;
        }
        this.drawInheritedBackground(0L, cairo);
        return super.gtk_draw(widget, cairo);
    }

    @Override
    long gtk_expose_event(long widget, long eventPtr) {
        if ((this.state & 0x40) != 0) {
            return 0L;
        }
        this.drawInheritedBackground(eventPtr, 0L);
        return super.gtk_expose_event(widget, eventPtr);
    }

    @Override
    long gtk_motion_notify_event(long widget, long event) {
        long window = OS.GDK_EVENT_WINDOW(event);
        if (window != OS.gtk_tree_view_get_bin_window(this.handle)) {
            return 0L;
        }
        return super.gtk_motion_notify_event(widget, event);
    }

    @Override
    long gtk_row_deleted(long model, long path) {
        if (this.ignoreAccessibility) {
            OS.g_signal_stop_emission_by_name(model, OS.row_deleted);
        }
        return 0L;
    }

    @Override
    long gtk_row_inserted(long model, long path, long iter) {
        if (this.ignoreAccessibility) {
            OS.g_signal_stop_emission_by_name(model, OS.row_inserted);
        }
        return 0L;
    }

    @Override
    long gtk_start_interactive_search(long widget) {
        if (!this.searchEnabled()) {
            OS.g_signal_stop_emission_by_name(widget, OS.start_interactive_search);
            return 1L;
        }
        return 0L;
    }

    @Override
    long gtk_toggled(long renderer, long pathStr) {
        long path = OS.gtk_tree_path_new_from_string(pathStr);
        if (path == 0L) {
            return 0L;
        }
        long indices = OS.gtk_tree_path_get_indices(path);
        if (indices != 0L) {
            int[] index = new int[1];
            OS.memmove(index, indices, 4L);
            TableItem item = this._getItem(index[0]);
            item.setChecked(!item.getChecked());
            Event event = new Event();
            event.detail = 32;
            event.item = item;
            this.sendSelectionEvent(13, event, false);
        }
        OS.gtk_tree_path_free(path);
        return 0L;
    }

    @Override
    void gtk_widget_size_request(long widget, GtkRequisition requisition) {
        long columns;
        if (this.columnCount == 0) {
            super.gtk_widget_size_request(widget, requisition);
            return;
        }
        long list = columns = OS.gtk_tree_view_get_columns(this.handle);
        boolean fixVisible = columns != 0L;
        while (list != 0L) {
            long column = OS.g_list_data(list);
            if (OS.gtk_tree_view_column_get_visible(column)) {
                fixVisible = false;
                break;
            }
            list = OS.g_list_next(list);
        }
        long columnHandle = 0L;
        if (fixVisible) {
            columnHandle = OS.g_list_data(columns);
            OS.gtk_tree_view_column_set_visible(columnHandle, true);
        }
        super.gtk_widget_size_request(widget, requisition);
        if (fixVisible) {
            OS.gtk_tree_view_column_set_visible(columnHandle, false);
        }
        if (columns != 0L) {
            OS.g_list_free(columns);
        }
    }

    void hideFirstColumn() {
        long firstColumn = OS.gtk_tree_view_get_column(this.handle, 0);
        OS.gtk_tree_view_column_set_visible(firstColumn, false);
    }

    @Override
    void hookEvents() {
        super.hookEvents();
        long selection = OS.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_connect_closure(selection, OS.changed, this.display.getClosure(6), false);
        OS.g_signal_connect_closure(this.handle, OS.row_activated, this.display.getClosure(41), false);
        if (this.checkRenderer != 0L) {
            OS.g_signal_connect_closure(this.checkRenderer, OS.toggled, this.display.getClosure(53), false);
        }
        OS.g_signal_connect_closure(this.handle, OS.start_interactive_search, this.display.getClosure(69), false);
        if (this.fixAccessibility()) {
            OS.g_signal_connect_closure(this.modelHandle, OS.row_inserted, this.display.getClosure(64), true);
            OS.g_signal_connect_closure(this.modelHandle, OS.row_deleted, this.display.getClosure(65), true);
        }
    }

    public int indexOf(TableColumn column) {
        this.checkWidget();
        if (column == null) {
            this.error(4);
        }
        int i = 0;
        while (i < this.columnCount) {
            if (this.columns[i] == column) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int indexOf(TableItem item) {
        this.checkWidget();
        if (item == null) {
            this.error(4);
        }
        if (1 <= this.lastIndexOf && this.lastIndexOf < this.itemCount - 1) {
            if (this.items[this.lastIndexOf] == item) {
                return this.lastIndexOf;
            }
            if (this.items[this.lastIndexOf + 1] == item) {
                return ++this.lastIndexOf;
            }
            if (this.items[this.lastIndexOf - 1] == item) {
                return --this.lastIndexOf;
            }
        }
        if (this.lastIndexOf < this.itemCount / 2) {
            int i = 0;
            while (i < this.itemCount) {
                if (this.items[i] == item) {
                    this.lastIndexOf = i;
                    return this.lastIndexOf;
                }
                ++i;
            }
        } else {
            int i = this.itemCount - 1;
            while (i >= 0) {
                if (this.items[i] == item) {
                    this.lastIndexOf = i;
                    return this.lastIndexOf;
                }
                --i;
            }
        }
        return -1;
    }

    public boolean isSelected(int index) {
        this.checkWidget();
        long selection = OS.gtk_tree_view_get_selection(this.handle);
        byte[] buffer = Converter.wcsToMbcs(Integer.toString(index), true);
        long path = OS.gtk_tree_path_new_from_string(buffer);
        boolean answer = OS.gtk_tree_selection_path_is_selected(selection, path);
        OS.gtk_tree_path_free(path);
        return answer;
    }

    @Override
    boolean mnemonicHit(char key) {
        int i = 0;
        while (i < this.columnCount) {
            long labelHandle = this.columns[i].labelHandle;
            if (labelHandle != 0L && this.mnemonicHit(labelHandle, key)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    boolean mnemonicMatch(char key) {
        int i = 0;
        while (i < this.columnCount) {
            long labelHandle = this.columns[i].labelHandle;
            if (labelHandle != 0L && this.mnemonicMatch(labelHandle, key)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    long paintWindow() {
        OS.gtk_widget_realize(this.handle);
        if (this.fixedHandle != 0L && OS.GTK_VERSION > OS.VERSION(3, 9, 0)) {
            OS.gtk_widget_realize(this.fixedHandle);
            return OS.gtk_widget_get_window(this.fixedHandle);
        }
        return OS.gtk_tree_view_get_bin_window(this.handle);
    }

    void recreateRenderers() {
        if (this.checkRenderer != 0L) {
            this.display.removeWidget(this.checkRenderer);
            OS.g_object_unref(this.checkRenderer);
            long l = this.checkRenderer = this.ownerDraw ? OS.g_object_new(this.display.gtk_cell_renderer_toggle_get_type(), 0L) : OS.gtk_cell_renderer_toggle_new();
            if (this.checkRenderer == 0L) {
                this.error(2);
            }
            OS.g_object_ref(this.checkRenderer);
            this.display.addWidget(this.checkRenderer, this);
            OS.g_signal_connect_closure(this.checkRenderer, OS.toggled, this.display.getClosure(53), false);
        }
        if (this.columnCount == 0) {
            this.createRenderers(OS.gtk_tree_view_get_column(this.handle, 0), 5, true, 0);
        } else {
            int i = 0;
            while (i < this.columnCount) {
                TableColumn column = this.columns[i];
                this.createRenderers(column.handle, column.modelIndex, i == 0, column.style);
                ++i;
            }
        }
    }

    @Override
    void redrawBackgroundImage() {
        Control control = this.findBackgroundControl();
        if (control != null && control.backgroundImage != null) {
            this.redrawWidget(0, 0, 0, 0, true, false, false);
        }
    }

    @Override
    void register() {
        super.register();
        this.display.addWidget(OS.gtk_tree_view_get_selection(this.handle), this);
        if (this.checkRenderer != 0L) {
            this.display.addWidget(this.checkRenderer, this);
        }
        this.display.addWidget(this.modelHandle, this);
    }

    @Override
    void releaseChildren(boolean destroy) {
        int i;
        if (this.items != null) {
            i = 0;
            while (i < this.itemCount) {
                TableItem item = this.items[i];
                if (item != null && !item.isDisposed()) {
                    item.release(false);
                }
                ++i;
            }
            this.items = null;
        }
        if (this.columns != null) {
            i = 0;
            while (i < this.columnCount) {
                TableColumn column = this.columns[i];
                if (column != null && !column.isDisposed()) {
                    column.release(false);
                }
                ++i;
            }
            this.columns = null;
        }
        super.releaseChildren(destroy);
    }

    @Override
    void releaseWidget() {
        super.releaseWidget();
        if (this.modelHandle != 0L) {
            OS.g_object_unref(this.modelHandle);
        }
        this.modelHandle = 0L;
        if (this.checkRenderer != 0L) {
            OS.g_object_unref(this.checkRenderer);
        }
        this.checkRenderer = 0L;
        if (this.imageList != null) {
            this.imageList.dispose();
        }
        if (this.headerImageList != null) {
            this.headerImageList.dispose();
        }
        this.headerImageList = null;
        this.imageList = null;
        this.currentItem = null;
    }

    public void remove(int index) {
        this.checkWidget();
        if (index < 0 || index >= this.itemCount) {
            this.error(15);
        }
        long iter = OS.g_malloc(OS.GtkTreeIter_sizeof());
        TableItem item = this.items[index];
        boolean disposed = false;
        if (item != null) {
            disposed = item.isDisposed();
            if (!disposed) {
                OS.memmove(iter, item.handle, (long)OS.GtkTreeIter_sizeof());
                item.release(false);
            }
        } else {
            OS.gtk_tree_model_iter_nth_child(this.modelHandle, iter, 0L, index);
        }
        if (!disposed) {
            long selection = OS.gtk_tree_view_get_selection(this.handle);
            OS.g_signal_handlers_block_matched(selection, 16, 0, 0, 0L, 0L, 6L);
            OS.gtk_list_store_remove(this.modelHandle, iter);
            OS.g_signal_handlers_unblock_matched(selection, 16, 0, 0, 0L, 0L, 6L);
            System.arraycopy(this.items, index + 1, this.items, index, --this.itemCount - index);
            this.items[this.itemCount] = null;
        }
        OS.g_free(iter);
    }

    public void remove(int start, int end) {
        this.checkWidget();
        if (start > end) {
            return;
        }
        if (start < 0 || start > end || end >= this.itemCount) {
            this.error(6);
        }
        long selection = OS.gtk_tree_view_get_selection(this.handle);
        long iter = OS.g_malloc(OS.GtkTreeIter_sizeof());
        if (iter == 0L) {
            this.error(2);
        }
        if (this.fixAccessibility()) {
            this.ignoreAccessibility = true;
        }
        int index = end;
        while (index >= start) {
            OS.gtk_tree_model_iter_nth_child(this.modelHandle, iter, 0L, index);
            TableItem item = this.items[index];
            if (item != null && !item.isDisposed()) {
                item.release(false);
            }
            OS.g_signal_handlers_block_matched(selection, 16, 0, 0, 0L, 0L, 6L);
            OS.gtk_list_store_remove(this.modelHandle, iter);
            OS.g_signal_handlers_unblock_matched(selection, 16, 0, 0, 0L, 0L, 6L);
            --index;
        }
        if (this.fixAccessibility()) {
            this.ignoreAccessibility = false;
            OS.g_object_notify(this.handle, OS.model);
        }
        OS.g_free(iter);
        index = end + 1;
        System.arraycopy(this.items, index, this.items, start, this.itemCount - index);
        int i = this.itemCount - (index - start);
        while (i < this.itemCount) {
            this.items[i] = null;
            ++i;
        }
        this.itemCount -= index - start;
    }

    public void remove(int[] indices) {
        this.checkWidget();
        if (indices == null) {
            this.error(4);
        }
        if (indices.length == 0) {
            return;
        }
        int[] newIndices = new int[indices.length];
        System.arraycopy(indices, 0, newIndices, 0, indices.length);
        this.sort(newIndices);
        int start = newIndices[newIndices.length - 1];
        int end = newIndices[0];
        if (start < 0 || start > end || end >= this.itemCount) {
            this.error(6);
        }
        long selection = OS.gtk_tree_view_get_selection(this.handle);
        int last = -1;
        long iter = OS.g_malloc(OS.GtkTreeIter_sizeof());
        if (iter == 0L) {
            this.error(2);
        }
        if (this.fixAccessibility()) {
            this.ignoreAccessibility = true;
        }
        int i = 0;
        while (i < newIndices.length) {
            int index = newIndices[i];
            if (index != last) {
                TableItem item = this.items[index];
                boolean disposed = false;
                if (item != null) {
                    disposed = item.isDisposed();
                    if (!disposed) {
                        OS.memmove(iter, item.handle, (long)OS.GtkTreeIter_sizeof());
                        item.release(false);
                    }
                } else {
                    OS.gtk_tree_model_iter_nth_child(this.modelHandle, iter, 0L, index);
                }
                if (!disposed) {
                    OS.g_signal_handlers_block_matched(selection, 16, 0, 0, 0L, 0L, 6L);
                    OS.gtk_list_store_remove(this.modelHandle, iter);
                    OS.g_signal_handlers_unblock_matched(selection, 16, 0, 0, 0L, 0L, 6L);
                    System.arraycopy(this.items, index + 1, this.items, index, --this.itemCount - index);
                    this.items[this.itemCount] = null;
                }
                last = index;
            }
            ++i;
        }
        if (this.fixAccessibility()) {
            this.ignoreAccessibility = false;
            OS.g_object_notify(this.handle, OS.model);
        }
        OS.g_free(iter);
    }

    public void removeAll() {
        this.checkWidget();
        int index = this.itemCount - 1;
        while (index >= 0) {
            TableItem item = this.items[index];
            if (item != null && !item.isDisposed()) {
                item.release(false);
            }
            --index;
        }
        this.items = new TableItem[4];
        this.itemCount = 0;
        long selection = OS.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(selection, 16, 0, 0, 0L, 0L, 6L);
        if (this.fixAccessibility()) {
            this.ignoreAccessibility = true;
        }
        OS.gtk_list_store_clear(this.modelHandle);
        if (this.fixAccessibility()) {
            this.ignoreAccessibility = false;
            OS.g_object_notify(this.handle, OS.model);
        }
        OS.g_signal_handlers_unblock_matched(selection, 16, 0, 0, 0L, 0L, 6L);
        this.resetCustomDraw();
        if (!this.searchEnabled()) {
            OS.gtk_tree_view_set_search_column(this.handle, -1);
        } else {
            int firstColumn = this.columnCount == 0 ? 5 : this.columns[0].modelIndex;
            OS.gtk_tree_view_set_search_column(this.handle, firstColumn + 1);
        }
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    void sendMeasureEvent(long cell, long width, long height) {
        if (!this.ignoreSize && OS.GTK_IS_CELL_RENDERER_TEXT(cell) && this.hooks(41)) {
            long iter = OS.g_object_get_qdata(cell, Display.SWT_OBJECT_INDEX2);
            TableItem item = null;
            boolean isSelected = false;
            if (iter != 0L) {
                long path = OS.gtk_tree_model_get_path(this.modelHandle, iter);
                int[] buffer = new int[1];
                OS.memmove(buffer, OS.gtk_tree_path_get_indices(path), 4L);
                int index = buffer[0];
                item = this._getItem(index);
                long selection = OS.gtk_tree_view_get_selection(this.handle);
                isSelected = OS.gtk_tree_selection_path_is_selected(selection, path);
                OS.gtk_tree_path_free(path);
            }
            if (item != null) {
                int columnIndex = 0;
                if (this.columnCount > 0) {
                    long columnHandle = OS.g_object_get_qdata(cell, Display.SWT_OBJECT_INDEX1);
                    int i = 0;
                    while (i < this.columnCount) {
                        if (this.columns[i].handle == columnHandle) {
                            columnIndex = i;
                            break;
                        }
                        ++i;
                    }
                }
                int[] contentWidth = new int[1];
                int[] contentHeight = new int[1];
                if (width != 0L) {
                    OS.memmove(contentWidth, width, 4L);
                }
                if (height != 0L) {
                    OS.memmove(contentHeight, height, 4L);
                }
                if (OS.GTK3) {
                    OS.gtk_cell_renderer_get_preferred_height_for_width(cell, this.handle, contentWidth[0], contentHeight, null);
                }
                Image image = item.getImage(columnIndex);
                int imageWidth = 0;
                if (image != null) {
                    Rectangle bounds = image.getBoundsInPixels();
                    imageWidth = bounds.width;
                }
                contentWidth[0] = contentWidth[0] + imageWidth;
                GC gc = new GC(this);
                gc.setFont(item.getFont(columnIndex));
                Event event = new Event();
                event.item = item;
                event.index = columnIndex;
                event.gc = gc;
                Rectangle eventRect = new Rectangle(0, 0, contentWidth[0], contentHeight[0]);
                event.setBounds(DPIUtil.autoScaleDown(eventRect));
                if (isSelected) {
                    event.detail = 2;
                }
                this.sendEvent(41, event);
                gc.dispose();
                Rectangle rect = DPIUtil.autoScaleUp(event.getBounds());
                contentWidth[0] = rect.width - imageWidth;
                if (contentHeight[0] < rect.height) {
                    contentHeight[0] = rect.height;
                }
                if (width != 0L) {
                    OS.memmove(width, contentWidth, 4L);
                }
                if (height != 0L) {
                    OS.memmove(height, contentHeight, 4L);
                }
                if (OS.GTK3) {
                    OS.gtk_cell_renderer_set_fixed_size(cell, contentWidth[0], contentHeight[0]);
                }
            }
        }
    }

    @Override
    long rendererGetPreferredWidthProc(long cell, long handle, long minimun_size, long natural_size) {
        long g_class = OS.g_type_class_peek_parent(OS.G_OBJECT_GET_CLASS(cell));
        GtkCellRendererClass klass = new GtkCellRendererClass();
        OS.memmove(klass, g_class);
        OS.call(klass.get_preferred_width, cell, handle, minimun_size, natural_size);
        this.sendMeasureEvent(cell, minimun_size, 0L);
        return 0L;
    }

    @Override
    long rendererGetSizeProc(long cell, long widget, long cell_area, long x_offset, long y_offset, long width, long height) {
        long g_class = OS.g_type_class_peek_parent(OS.G_OBJECT_GET_CLASS(cell));
        GtkCellRendererClass klass = new GtkCellRendererClass();
        OS.memmove(klass, g_class);
        OS.call_get_size(klass.get_size, cell, this.handle, cell_area, x_offset, y_offset, width, height);
        this.sendMeasureEvent(cell, width, height);
        return 0L;
    }

    @Override
    long rendererRenderProc(long cell, long cr, long widget, long background_area, long cell_area, long flags) {
        this.rendererRender(cell, cr, 0L, widget, background_area, cell_area, 0L, flags);
        return 0L;
    }

    @Override
    long rendererRenderProc(long cell, long window, long widget, long background_area, long cell_area, long expose_area, long flags) {
        this.rendererRender(cell, 0L, window, widget, background_area, cell_area, expose_area, flags);
        return 0L;
    }

    void rendererRender(long cell, long cr, long window, long widget, long background_area, long cell_area, long expose_area, long flags) {
        Rectangle rect2;
        GdkRectangle rect;
        TableItem item = null;
        boolean wasSelected = false;
        long iter = OS.g_object_get_qdata(cell, Display.SWT_OBJECT_INDEX2);
        if (iter != 0L) {
            long path = OS.gtk_tree_model_get_path(this.modelHandle, iter);
            int[] buffer = new int[1];
            OS.memmove(buffer, OS.gtk_tree_path_get_indices(path), 4L);
            int index = buffer[0];
            item = this._getItem(index);
            OS.gtk_tree_path_free(path);
        }
        long columnHandle = OS.g_object_get_qdata(cell, Display.SWT_OBJECT_INDEX1);
        int columnIndex = 0;
        if (this.columnCount > 0) {
            int i = 0;
            while (i < this.columnCount) {
                if (this.columns[i].handle == columnHandle) {
                    columnIndex = i;
                    break;
                }
                ++i;
            }
        }
        if (item != null && (OS.GTK_IS_CELL_RENDERER_TOGGLE(cell) || (OS.GTK_IS_CELL_RENDERER_PIXBUF(cell) || OS.GTK_VERSION > OS.VERSION(3, 13, 0)) && (columnIndex != 0 || (this.style & 0x20) == 0))) {
            long textRenderer;
            Control control;
            this.drawFlags = (int)flags;
            this.drawState = 16;
            long[] ptr = new long[1];
            OS.gtk_tree_model_get(this.modelHandle, item.handle, 3, ptr, -1);
            if (ptr[0] == 0L) {
                int modelIndex = this.columnCount == 0 ? 5 : this.columns[columnIndex].modelIndex;
                OS.gtk_tree_model_get(this.modelHandle, item.handle, modelIndex + 3, ptr, -1);
            }
            if (ptr[0] != 0L) {
                this.drawState |= 8;
                OS.gdk_color_free(ptr[0]);
            }
            if ((flags & 1L) != 0L) {
                this.drawState |= 2;
            }
            if (!(OS.GTK3 && (flags & 1L) != 0L || (flags & 0x10L) == 0L)) {
                this.drawState |= 4;
            }
            rect = new GdkRectangle();
            long path = OS.gtk_tree_model_get_path(this.modelHandle, iter);
            OS.gtk_tree_view_get_background_area(this.handle, path, columnHandle, rect);
            OS.gtk_tree_path_free(path);
            if (cr != 0L && OS.GTK_VERSION > OS.VERSION(3, 9, 0) && OS.GTK_VERSION <= OS.VERSION(3, 14, 8)) {
                GdkRectangle r2 = new GdkRectangle();
                OS.gdk_cairo_get_clip_rectangle(cr, r2);
                rect.x = r2.x;
                rect.width = r2.width;
            }
            if ((this.drawState & 2) == 0 && ((this.state & 0x8000) != 0 || this.backgroundImage != null) && (control = this.findBackgroundControl()) != null) {
                if (cr != 0L) {
                    Cairo.cairo_save(cr);
                    if (!OS.GTK3) {
                        Cairo.cairo_reset_clip(cr);
                    }
                }
                this.drawBackground(control, window, cr, 0L, rect.x, rect.y, rect.width, rect.height);
                if (cr != 0L) {
                    Cairo.cairo_restore(cr);
                }
            }
            if ((textRenderer = this.getTextRenderer(columnHandle)) != 0L) {
                this.gtk_cell_renderer_get_preferred_size(textRenderer, this.handle, null, null);
            }
            if (this.hooks(40)) {
                boolean bl = wasSelected = (this.drawState & 2) != 0;
                if (wasSelected) {
                    Control control2 = this.findBackgroundControl();
                    if (control2 == null) {
                        control2 = this;
                    }
                    if (!OS.GTK3) {
                        if (cr != 0L) {
                            Cairo.cairo_save(cr);
                            Cairo.cairo_reset_clip(cr);
                        }
                        this.drawBackground(control2, window, cr, 0L, rect.x, rect.y, rect.width, rect.height);
                        if (cr != 0L) {
                            Cairo.cairo_restore(cr);
                        }
                    }
                }
                GC gc = this.getGC(cr);
                if ((this.drawState & 2) != 0) {
                    gc.setBackground(this.display.getSystemColor(26));
                    gc.setForeground(this.display.getSystemColor(27));
                } else {
                    gc.setBackground(item.getBackground(columnIndex));
                    gc.setForeground(item.getForeground(columnIndex));
                }
                gc.setFont(item.getFont(columnIndex));
                if ((this.style & 0x8000000) != 0) {
                    rect.x = this.getClientWidth() - rect.width - rect.x;
                }
                if (OS.GTK_VERSION >= OS.VERSION(3, 9, 0) && cr != 0L) {
                    GdkRectangle r = new GdkRectangle();
                    OS.gdk_cairo_get_clip_rectangle(cr, r);
                    rect2 = DPIUtil.autoScaleDown(new Rectangle(rect.x, r.y, r.width, r.height));
                    gc.setClipping(rect2.x, rect2.y, rect2.width, rect2.height);
                    if (OS.GTK_VERSION <= OS.VERSION(3, 14, 8)) {
                        rect.width = r.width;
                    }
                } else {
                    Rectangle rect22 = DPIUtil.autoScaleDown(new Rectangle(rect.x, rect.y, rect.width, rect.height));
                    gc.setClipping(rect22.x, rect22.y, rect22.width, rect22.height);
                }
                Event event = new Event();
                event.item = item;
                event.index = columnIndex;
                event.gc = gc;
                event.detail = this.drawState;
                Rectangle eventRect = new Rectangle(rect.x, rect.y, rect.width, rect.height);
                event.setBounds(DPIUtil.autoScaleDown(eventRect));
                this.sendEvent(40, event);
                this.drawForeground = null;
                this.drawState = event.doit ? event.detail : 0;
                this.drawFlags &= 0xFFFFFFEE;
                if ((this.drawState & 2) != 0) {
                    this.drawFlags |= 1;
                }
                if ((this.drawState & 4) != 0) {
                    this.drawFlags |= 0x10;
                }
                if ((this.drawState & 2) != 0) {
                    if (OS.GTK3) {
                        Cairo.cairo_save(cr);
                        Cairo.cairo_reset_clip(cr);
                        long context = OS.gtk_widget_get_style_context(widget);
                        OS.gtk_style_context_save(context);
                        OS.gtk_style_context_add_class(context, OS.GTK_STYLE_CLASS_CELL);
                        OS.gtk_style_context_set_state(context, 4L);
                        OS.gtk_render_background(context, cr, rect.x, rect.y, rect.width, rect.height);
                        OS.gtk_style_context_restore(context);
                        Cairo.cairo_restore(cr);
                    } else {
                        long style = OS.gtk_widget_get_style(widget);
                        byte[] detail = Converter.wcsToMbcs("cell_odd", true);
                        OS.gtk_paint_flat_box(style, window, 3, 0, rect, widget, detail, rect.x, rect.y, rect.width, rect.height);
                    }
                } else if (wasSelected) {
                    this.drawForeground = gc.getForeground().handle;
                }
                gc.dispose();
            }
        }
        if ((this.drawState & 8) != 0 && (this.drawState & 2) == 0) {
            GC gc = this.getGC(cr);
            gc.setBackground(item.getBackground(columnIndex));
            rect = new GdkRectangle();
            OS.memmove(rect, background_area, (long)GdkRectangle.sizeof);
            gc.fillRectangle(DPIUtil.autoScaleDown(new Rectangle(rect.x, rect.y, rect.width, rect.height)));
            gc.dispose();
        }
        if ((this.drawState & 0x10) != 0 || OS.GTK_IS_CELL_RENDERER_TOGGLE(cell)) {
            long g_class = OS.g_type_class_peek_parent(OS.G_OBJECT_GET_CLASS(cell));
            GtkCellRendererClass klass = new GtkCellRendererClass();
            OS.memmove(klass, g_class);
            if (this.drawForeground != null && OS.GTK_IS_CELL_RENDERER_TEXT(cell)) {
                OS.g_object_set(cell, OS.foreground_gdk, this.drawForeground, 0L);
            }
            if (OS.GTK3) {
                OS.call(klass.render, cell, cr, widget, background_area, cell_area, this.drawFlags);
            } else {
                OS.call(klass.render, cell, window, widget, background_area, cell_area, expose_area, this.drawFlags);
            }
        }
        if (item != null && OS.GTK_IS_CELL_RENDERER_TEXT(cell) && this.hooks(42)) {
            if (wasSelected) {
                this.drawState |= 2;
            }
            GdkRectangle rect3 = new GdkRectangle();
            long path = OS.gtk_tree_model_get_path(this.modelHandle, iter);
            OS.gtk_tree_view_get_background_area(this.handle, path, columnHandle, rect3);
            OS.gtk_tree_path_free(path);
            if (cr != 0L && OS.GTK_VERSION > OS.VERSION(3, 9, 0) && OS.GTK_VERSION <= OS.VERSION(3, 14, 8)) {
                GdkRectangle r2 = new GdkRectangle();
                OS.gdk_cairo_get_clip_rectangle(cr, r2);
                rect3.x = r2.x;
                rect3.width = r2.width;
            }
            this.ignoreSize = true;
            int[] contentX = new int[1];
            int[] contentWidth = new int[1];
            this.gtk_cell_renderer_get_preferred_size(cell, this.handle, contentWidth, null);
            this.gtk_tree_view_column_cell_get_position(columnHandle, cell, contentX, null);
            this.ignoreSize = false;
            Image image = item.getImage(columnIndex);
            int imageWidth = 0;
            if (image != null) {
                Rectangle bounds = image.getBoundsInPixels();
                imageWidth = bounds.width;
            }
            if (cr != 0L && OS.GTK_VERSION > OS.VERSION(3, 9, 0) && OS.GTK_VERSION <= OS.VERSION(3, 14, 8)) {
                rect3.x -= imageWidth;
                rect3.width += imageWidth;
            }
            contentX[0] = contentX[0] - imageWidth;
            contentWidth[0] = contentWidth[0] + imageWidth;
            GC gc = this.getGC(cr);
            if ((this.drawState & 2) != 0) {
                Color foreground;
                Color background;
                if (OS.gtk_widget_has_focus(this.handle) || OS.GTK3) {
                    background = this.display.getSystemColor(26);
                    foreground = this.display.getSystemColor(27);
                } else {
                    background = Color.gtk_new(this.display, this.display.COLOR_LIST_SELECTION_INACTIVE);
                    foreground = Color.gtk_new(this.display, this.display.COLOR_LIST_SELECTION_TEXT_INACTIVE);
                }
                gc.setBackground(background);
                gc.setForeground(foreground);
            } else {
                gc.setBackground(item.getBackground(columnIndex));
                Color foreground = this.drawForeground != null ? Color.gtk_new(this.display, this.drawForeground) : item.getForeground(columnIndex);
                gc.setForeground(foreground);
            }
            gc.setFont(item.getFont(columnIndex));
            if ((this.style & 0x8000000) != 0) {
                rect3.x = this.getClientWidth() - rect3.width - rect3.x;
            }
            rect2 = DPIUtil.autoScaleDown(new Rectangle(rect3.x, rect3.y, rect3.width, rect3.height));
            gc.setClipping(rect2.x, rect2.y, rect2.width, rect2.height);
            Event event = new Event();
            event.item = item;
            event.index = columnIndex;
            event.gc = gc;
            Rectangle eventRect = new Rectangle(rect3.x + contentX[0], rect3.y, contentWidth[0], rect3.height);
            event.setBounds(DPIUtil.autoScaleDown(eventRect));
            event.detail = this.drawState;
            this.sendEvent(42, event);
            gc.dispose();
        }
    }

    private GC getGC(long cr) {
        GC gc;
        if (OS.GTK3) {
            GCData gcData = new GCData();
            gcData.cairo = cr;
            gc = GC.gtk_new(this, gcData);
        } else {
            gc = new GC(this);
        }
        return gc;
    }

    void resetCustomDraw() {
        if ((this.style & 0x10000000) != 0 || this.ownerDraw) {
            return;
        }
        int end = Math.max(1, this.columnCount);
        int i = 0;
        while (i < end) {
            boolean customDraw;
            boolean bl = customDraw = this.columnCount != 0 ? this.columns[i].customDraw : this.firstCustomDraw;
            if (customDraw) {
                long column = OS.gtk_tree_view_get_column(this.handle, i);
                long textRenderer = this.getTextRenderer(column);
                OS.gtk_tree_view_column_set_cell_data_func(column, textRenderer, 0L, 0L, 0L);
                if (this.columnCount != 0) {
                    this.columns[i].customDraw = false;
                }
            }
            ++i;
        }
        this.firstCustomDraw = false;
    }

    @Override
    void reskinChildren(int flags) {
        int i;
        if (this.items != null) {
            i = 0;
            while (i < this.itemCount) {
                TableItem item = this.items[i];
                if (item != null) {
                    item.reskin(flags);
                }
                ++i;
            }
        }
        if (this.columns != null) {
            i = 0;
            while (i < this.columnCount) {
                TableColumn column = this.columns[i];
                if (!column.isDisposed()) {
                    column.reskin(flags);
                }
                ++i;
            }
        }
        super.reskinChildren(flags);
    }

    boolean searchEnabled() {
        return (this.style & 0x10000000) == 0;
    }

    public void select(int index) {
        this.checkWidget();
        if (index < 0 || index >= this.itemCount) {
            return;
        }
        boolean fixColumn = this.showFirstColumn();
        long selection = OS.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(selection, 16, 0, 0, 0L, 0L, 6L);
        TableItem item = this._getItem(index);
        OS.gtk_tree_selection_select_iter(selection, item.handle);
        OS.g_signal_handlers_unblock_matched(selection, 16, 0, 0, 0L, 0L, 6L);
        if (fixColumn) {
            this.hideFirstColumn();
        }
    }

    public void select(int start, int end) {
        this.checkWidget();
        if (end < 0 || start > end || (this.style & 4) != 0 && start != end) {
            return;
        }
        if (this.itemCount == 0 || start >= this.itemCount) {
            return;
        }
        start = Math.max(0, start);
        end = Math.min(end, this.itemCount - 1);
        boolean fixColumn = this.showFirstColumn();
        long selection = OS.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(selection, 16, 0, 0, 0L, 0L, 6L);
        int index = start;
        while (index <= end) {
            TableItem item = this._getItem(index);
            OS.gtk_tree_selection_select_iter(selection, item.handle);
            ++index;
        }
        OS.g_signal_handlers_unblock_matched(selection, 16, 0, 0, 0L, 0L, 6L);
        if (fixColumn) {
            this.hideFirstColumn();
        }
    }

    public void select(int[] indices) {
        int length;
        this.checkWidget();
        if (indices == null) {
            this.error(4);
        }
        if ((length = indices.length) == 0 || (this.style & 4) != 0 && length > 1) {
            return;
        }
        boolean fixColumn = this.showFirstColumn();
        long selection = OS.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(selection, 16, 0, 0, 0L, 0L, 6L);
        int i = 0;
        while (i < length) {
            int index = indices[i];
            if (index >= 0 && index < this.itemCount) {
                TableItem item = this._getItem(index);
                OS.gtk_tree_selection_select_iter(selection, item.handle);
            }
            ++i;
        }
        OS.g_signal_handlers_unblock_matched(selection, 16, 0, 0, 0L, 0L, 6L);
        if (fixColumn) {
            this.hideFirstColumn();
        }
    }

    public void selectAll() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return;
        }
        boolean fixColumn = this.showFirstColumn();
        long selection = OS.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(selection, 16, 0, 0, 0L, 0L, 6L);
        OS.gtk_tree_selection_select_all(selection);
        OS.g_signal_handlers_unblock_matched(selection, 16, 0, 0, 0L, 0L, 6L);
        if (fixColumn) {
            this.hideFirstColumn();
        }
    }

    void selectFocusIndex(int index) {
        if (index < 0 || index >= this.itemCount) {
            return;
        }
        TableItem item = this._getItem(index);
        long path = OS.gtk_tree_model_get_path(this.modelHandle, item.handle);
        long selection = OS.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(selection, 16, 0, 0, 0L, 0L, 6L);
        OS.gtk_tree_view_set_cursor(this.handle, path, 0L, false);
        OS.g_signal_handlers_unblock_matched(selection, 16, 0, 0, 0L, 0L, 6L);
        OS.gtk_tree_path_free(path);
    }

    @Override
    void setBackgroundColor(GdkColor color) {
        super.setBackgroundColor(color);
        if (!OS.GTK3) {
            OS.gtk_widget_modify_base(this.handle, 0, color);
        }
    }

    @Override
    void setBackgroundColor(long context, long handle, GdkRGBA rgba) {
        if (rgba == null) {
            GdkColor temp = this.getDisplay().COLOR_LIST_BACKGROUND;
            this.background = this.display.toGdkRGBA(temp);
        } else {
            this.background = rgba;
        }
        GdkColor defaultColor = this.getDisplay().COLOR_LIST_SELECTION;
        GdkRGBA selectedBackground = this.display.toGdkRGBA(defaultColor);
        if (OS.GTK_VERSION >= OS.VERSION(3, 16, 0)) {
            String css;
            String name = OS.GTK_VERSION >= OS.VERSION(3, 20, 0) ? "treeview" : "GtkTreeView";
            this.cssBackground = css = String.valueOf(name) + " {background-color: " + this.display.gtk_rgba_to_css_string(this.background) + ";}\n" + name + ":selected {background-color: " + this.display.gtk_rgba_to_css_string(selectedBackground) + ";}";
            String finalCss = this.display.gtk_css_create_css_color_string(this.cssBackground, this.cssForeground, 8);
            this.gtk_css_provider_load_from_css(context, finalCss);
        } else {
            super.setBackgroundColor(context, handle, rgba);
            OS.gtk_widget_override_background_color(handle, 4, selectedBackground);
        }
    }

    @Override
    void setBackgroundPixmap(Image image) {
        this.ownerDraw = true;
        this.recreateRenderers();
    }

    @Override
    int setBounds(int x, int y, int width, int height, boolean move, boolean resize) {
        int result = super.setBounds(x, y, width, height, move, resize);
        OS.gtk_widget_realize(this.handle);
        return result;
    }

    public void setColumnOrder(int[] order) {
        this.checkWidget();
        if (order == null) {
            this.error(4);
        }
        if (this.columnCount == 0) {
            if (order.length > 0) {
                this.error(5);
            }
            return;
        }
        if (order.length != this.columnCount) {
            this.error(5);
        }
        boolean[] seen = new boolean[this.columnCount];
        int i = 0;
        while (i < order.length) {
            int index = order[i];
            if (index < 0 || index >= this.columnCount) {
                this.error(6);
            }
            if (seen[index]) {
                this.error(5);
            }
            seen[index] = true;
            ++i;
        }
        i = 0;
        while (i < order.length) {
            long column = this.columns[order[i]].handle;
            long baseColumn = i == 0 ? 0L : this.columns[order[i - 1]].handle;
            OS.gtk_tree_view_move_column_after(this.handle, column, baseColumn);
            ++i;
        }
    }

    @Override
    void setFontDescription(long font) {
        super.setFontDescription(font);
        TableColumn[] columns = this.getColumns();
        int i = 0;
        while (i < columns.length) {
            if (columns[i] != null) {
                columns[i].setFontDescription(font);
            }
            ++i;
        }
    }

    @Override
    void setForegroundColor(GdkColor color) {
        if (OS.GTK_VERSION >= OS.VERSION(3, 16, 0)) {
            GdkRGBA rgba = null;
            if (color != null) {
                rgba = this.display.toGdkRGBA(color);
            }
            this.foreground = rgba;
            this.setForegroundColor(this.handle, rgba);
        } else {
            this.setForegroundColor(this.handle, color, false);
        }
    }

    public void setHeaderBackground(Color color) {
        this.checkWidget();
        if (color != null) {
            if (color.isDisposed()) {
                this.error(5);
            }
            if (color.equals(this.headerBackground)) {
                return;
            }
        }
        this.headerBackground = color;
        if (OS.GTK3) {
            String css;
            GdkRGBA background = this.headerBackground != null ? this.display.toGdkRGBA(this.headerBackground.handle) : this.display.toGdkRGBA(this.display.COLOR_LIST_BACKGROUND);
            String name = OS.GTK_VERSION >= OS.VERSION(3, 20, 0) ? "button" : "GtkButton";
            this.headerCSSBackground = css = String.valueOf(name) + " {background: " + this.display.gtk_rgba_to_css_string(background) + ";}\n";
            String finalCss = this.display.gtk_css_create_css_color_string(this.headerCSSBackground, this.headerCSSForeground, 8);
            TableColumn[] tableColumnArray = this.columns;
            int n = this.columns.length;
            int n2 = 0;
            while (n2 < n) {
                TableColumn column = tableColumnArray[n2];
                if (column != null) {
                    long context = OS.gtk_widget_get_style_context(column.buttonHandle);
                    long provider = OS.gtk_css_provider_new();
                    OS.gtk_style_context_add_provider(context, provider, 600);
                    OS.g_object_unref(provider);
                    OS.gtk_css_provider_load_from_data(provider, Converter.wcsToMbcs(finalCss, true), -1L, null);
                    OS.gtk_style_context_invalidate(context);
                }
                ++n2;
            }
        }
    }

    public void setHeaderForeground(Color color) {
        this.checkWidget();
        if (color != null) {
            if (color.isDisposed()) {
                this.error(5);
            }
            if (color.equals(this.headerForeground)) {
                return;
            }
        }
        this.headerForeground = color;
        if (OS.GTK3) {
            String css;
            GdkRGBA foreground = this.headerForeground != null ? this.display.toGdkRGBA(this.headerForeground.handle) : this.display.toGdkRGBA(this.display.COLOR_LIST_FOREGROUND);
            String name = OS.GTK_VERSION >= OS.VERSION(3, 20, 0) ? "button" : "GtkButton";
            this.headerCSSForeground = css = String.valueOf(name) + " {color: " + this.display.gtk_rgba_to_css_string(foreground) + ";}";
            String finalCss = this.display.gtk_css_create_css_color_string(this.headerCSSBackground, this.headerCSSForeground, 16);
            TableColumn[] tableColumnArray = this.columns;
            int n = this.columns.length;
            int n2 = 0;
            while (n2 < n) {
                TableColumn column = tableColumnArray[n2];
                if (column != null) {
                    long context = OS.gtk_widget_get_style_context(column.buttonHandle);
                    long provider = OS.gtk_css_provider_new();
                    OS.gtk_style_context_add_provider(context, provider, 600);
                    OS.g_object_unref(provider);
                    OS.gtk_css_provider_load_from_data(provider, Converter.wcsToMbcs(finalCss, true), -1L, null);
                    OS.gtk_style_context_invalidate(context);
                }
                ++n2;
            }
        }
    }

    public void setHeaderVisible(boolean show) {
        this.checkWidget();
        OS.gtk_tree_view_set_headers_visible(this.handle, show);
    }

    public void setItemCount(int count) {
        boolean isVirtual;
        this.checkWidget();
        count = Math.max(0, count);
        if (count == this.itemCount) {
            return;
        }
        boolean bl = isVirtual = (this.style & 0x10000000) != 0;
        if (!isVirtual) {
            this.setRedraw(false);
        }
        this.remove(count, this.itemCount - 1);
        int length = Math.max(4, (count + 3) / 4 * 4);
        TableItem[] newItems = new TableItem[length];
        System.arraycopy(this.items, 0, newItems, 0, this.itemCount);
        this.items = newItems;
        if (isVirtual) {
            long iter = OS.g_malloc(OS.GtkTreeIter_sizeof());
            if (iter == 0L) {
                this.error(2);
            }
            if (this.fixAccessibility()) {
                this.ignoreAccessibility = true;
            }
            int i = this.itemCount;
            while (i < count) {
                OS.gtk_list_store_append(this.modelHandle, iter);
                ++i;
            }
            if (this.fixAccessibility()) {
                this.ignoreAccessibility = false;
                OS.g_object_notify(this.handle, OS.model);
            }
            OS.g_free(iter);
            this.itemCount = count;
        } else {
            int i = this.itemCount;
            while (i < count) {
                new TableItem(this, 0, i, true);
                ++i;
            }
        }
        if (!isVirtual) {
            this.setRedraw(true);
        }
    }

    public void setLinesVisible(boolean show) {
        this.checkWidget();
        if (!OS.GTK3) {
            OS.gtk_tree_view_set_rules_hint(this.handle, show);
        }
        OS.gtk_tree_view_set_grid_lines(this.handle, show ? 2 : 0);
    }

    void setModel(long newModel) {
        this.display.removeWidget(this.modelHandle);
        OS.g_object_unref(this.modelHandle);
        this.modelHandle = newModel;
        this.display.addWidget(this.modelHandle, this);
        if (this.fixAccessibility()) {
            OS.g_signal_connect_closure(this.modelHandle, OS.row_inserted, this.display.getClosure(64), true);
            OS.g_signal_connect_closure(this.modelHandle, OS.row_deleted, this.display.getClosure(65), true);
        }
    }

    @Override
    void setOrientation(boolean create) {
        super.setOrientation(create);
        int i = 0;
        while (i < this.itemCount) {
            if (this.items[i] != null) {
                this.items[i].setOrientation(create);
            }
            ++i;
        }
        i = 0;
        while (i < this.columnCount) {
            if (this.columns[i] != null) {
                this.columns[i].setOrientation(create);
            }
            ++i;
        }
    }

    @Override
    void setParentBackground() {
        this.ownerDraw = true;
        this.recreateRenderers();
    }

    @Override
    void setParentWindow(long widget) {
        long window = this.eventWindow();
        OS.gtk_widget_set_parent_window(widget, window);
    }

    @Override
    public void setRedraw(boolean redraw) {
        this.checkWidget();
        super.setRedraw(redraw);
        if (redraw && this.drawCount == 0 && this.items.length > 4 && this.items.length - this.itemCount > 3) {
            int length = Math.max(4, (this.itemCount + 3) / 4 * 4);
            TableItem[] newItems = new TableItem[length];
            System.arraycopy(this.items, 0, newItems, 0, this.itemCount);
            this.items = newItems;
        }
    }

    void setScrollWidth(long column, TableItem item) {
        int itemWidth;
        if (this.columnCount != 0 || this.currentItem == item) {
            return;
        }
        int width = OS.gtk_tree_view_column_get_fixed_width(column);
        if (width < (itemWidth = this.calculateWidth(column, item.handle))) {
            OS.gtk_tree_view_column_set_fixed_width(column, itemWidth);
        }
    }

    public void setSortColumn(TableColumn column) {
        this.checkWidget();
        if (column != null && column.isDisposed()) {
            this.error(5);
        }
        if (this.sortColumn != null && !this.sortColumn.isDisposed()) {
            OS.gtk_tree_view_column_set_sort_indicator(this.sortColumn.handle, false);
        }
        this.sortColumn = column;
        if (this.sortColumn != null && this.sortDirection != 0) {
            OS.gtk_tree_view_column_set_sort_indicator(this.sortColumn.handle, true);
            OS.gtk_tree_view_column_set_sort_order(this.sortColumn.handle, this.sortDirection == 1024 ? 0 : 1);
        }
    }

    public void setSortDirection(int direction) {
        this.checkWidget();
        if (direction != 128 && direction != 1024 && direction != 0) {
            return;
        }
        this.sortDirection = direction;
        if (this.sortColumn == null || this.sortColumn.isDisposed()) {
            return;
        }
        if (this.sortDirection == 0) {
            OS.gtk_tree_view_column_set_sort_indicator(this.sortColumn.handle, false);
        } else {
            OS.gtk_tree_view_column_set_sort_indicator(this.sortColumn.handle, true);
            OS.gtk_tree_view_column_set_sort_order(this.sortColumn.handle, this.sortDirection == 1024 ? 0 : 1);
        }
    }

    public void setSelection(int index) {
        this.checkWidget();
        boolean fixColumn = this.showFirstColumn();
        this.deselectAll();
        this.selectFocusIndex(index);
        this.showSelection();
        if (fixColumn) {
            this.hideFirstColumn();
        }
    }

    public void setSelection(int start, int end) {
        this.checkWidget();
        this.deselectAll();
        if (end < 0 || start > end || (this.style & 4) != 0 && start != end) {
            return;
        }
        if (this.itemCount == 0 || start >= this.itemCount) {
            return;
        }
        boolean fixColumn = this.showFirstColumn();
        start = Math.max(0, start);
        end = Math.min(end, this.itemCount - 1);
        this.selectFocusIndex(start);
        if ((this.style & 2) != 0) {
            this.select(start, end);
        }
        this.showSelection();
        if (fixColumn) {
            this.hideFirstColumn();
        }
    }

    public void setSelection(int[] indices) {
        this.checkWidget();
        if (indices == null) {
            this.error(4);
        }
        this.deselectAll();
        int length = indices.length;
        if (length == 0 || (this.style & 4) != 0 && length > 1) {
            return;
        }
        boolean fixColumn = this.showFirstColumn();
        this.selectFocusIndex(indices[0]);
        if ((this.style & 2) != 0) {
            this.select(indices);
        }
        this.showSelection();
        if (fixColumn) {
            this.hideFirstColumn();
        }
    }

    public void setSelection(TableItem item) {
        if (item == null) {
            this.error(4);
        }
        this.setSelection(new TableItem[]{item});
    }

    public void setSelection(TableItem[] items) {
        this.checkWidget();
        if (items == null) {
            this.error(4);
        }
        boolean fixColumn = this.showFirstColumn();
        this.deselectAll();
        int length = items.length;
        if (length != 0 && ((this.style & 4) == 0 || length <= 1)) {
            boolean first = true;
            int i = 0;
            while (i < length) {
                int index = this.indexOf(items[i]);
                if (index != -1) {
                    if (first) {
                        first = false;
                        this.selectFocusIndex(index);
                    } else {
                        this.select(index);
                    }
                }
                ++i;
            }
            this.showSelection();
        }
        if (fixColumn) {
            this.hideFirstColumn();
        }
    }

    public void setTopIndex(int index) {
        this.checkWidget();
        if (index < 0 || index >= this.itemCount) {
            return;
        }
        long vAdjustment = OS.GTK3 ? OS.gtk_scrollable_get_vadjustment(this.handle) : OS.gtk_tree_view_get_vadjustment(this.handle);
        this.cachedAdjustment = OS.gtk_adjustment_get_value(vAdjustment);
        this.topIndex = index;
        long path = OS.gtk_tree_model_get_path(this.modelHandle, this._getItem((int)index).handle);
        OS.gtk_tree_view_scroll_to_cell(this.handle, path, 0L, true, 0.0f, 0.0f);
        OS.gtk_tree_path_free(path);
    }

    public void showColumn(TableColumn column) {
        this.checkWidget();
        if (column == null) {
            this.error(4);
        }
        if (column.isDisposed()) {
            this.error(5);
        }
        if (column.parent != this) {
            return;
        }
        OS.gtk_tree_view_scroll_to_cell(this.handle, 0L, column.handle, false, 0.0f, 0.0f);
    }

    boolean showFirstColumn() {
        int columnCount = Math.max(1, this.columnCount);
        int i = 0;
        while (i < columnCount) {
            long column = OS.gtk_tree_view_get_column(this.handle, i);
            if (OS.gtk_tree_view_column_get_visible(column)) {
                return false;
            }
            ++i;
        }
        long firstColumn = OS.gtk_tree_view_get_column(this.handle, 0);
        OS.gtk_tree_view_column_set_visible(firstColumn, true);
        return true;
    }

    public void showItem(TableItem item) {
        this.checkWidget();
        if (item == null) {
            this.error(4);
        }
        if (item.isDisposed()) {
            this.error(5);
        }
        if (item.parent != this) {
            return;
        }
        this.showItem(item.handle);
    }

    void showItem(long iter) {
        long path = OS.gtk_tree_model_get_path(this.modelHandle, iter);
        OS.gtk_tree_view_scroll_to_cell(this.handle, path, 0L, false, 0.0f, 0.0f);
        OS.gtk_tree_path_free(path);
    }

    public void showSelection() {
        this.checkWidget();
        TableItem[] selection = this.getSelection();
        if (selection.length == 0) {
            return;
        }
        TableItem item = selection[0];
        this.showItem(item.handle);
    }

    @Override
    void updateScrollBarValue(ScrollBar bar) {
        super.updateScrollBarValue(bar);
        long parentHandle = this.parentingHandle();
        long list = OS.gtk_container_get_children(parentHandle);
        if (list == 0L) {
            return;
        }
        long temp = list;
        while (temp != 0L) {
            long widget = OS.g_list_data(temp);
            if (widget != 0L) {
                OS.gtk_widget_queue_resize(widget);
            }
            temp = OS.g_list_next(temp);
        }
        OS.g_list_free(list);
    }

    @Override
    long windowProc(long handle, long arg0, long user_data) {
        switch ((int)user_data) {
            case 19: {
                Control control;
                if (this.itemCount != 0 || (this.state & 0x40) != 0 || (this.state & 0x8000) == 0 && this.backgroundImage == null || (control = this.findBackgroundControl()) == null) break;
                GdkEventExpose gdkEvent = new GdkEventExpose();
                OS.memmove(gdkEvent, arg0, (long)GdkEventExpose.sizeof);
                long window = OS.gtk_tree_view_get_bin_window(handle);
                if (window != gdkEvent.window) break;
                this.drawBackground(control, window, gdkEvent.region, gdkEvent.area_x, gdkEvent.area_y, gdkEvent.area_width, gdkEvent.area_height);
            }
        }
        return super.windowProc(handle, arg0, user_data);
    }
}

