/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.actions.repair;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.diagram.AbstractDNode;
import org.eclipse.sirius.diagram.ArrangeConstraint;
import org.eclipse.sirius.diagram.description.DiagramElementMapping;
import org.eclipse.sirius.diagram.ui.tools.api.migration.DiagramCrossReferencer;
import org.eclipse.sirius.diagram.ui.tools.internal.actions.repair.AbstractDiagramElementState;
import org.eclipse.sirius.diagram.ui.tools.internal.actions.repair.Identifier;

public abstract class AbstractAbstractDNodeDiagramElementState<D extends AbstractDNode>
extends AbstractDiagramElementState<D> {
    private List<ArrangeConstraint> arrangeConstraints = Lists.newArrayList();

    public AbstractAbstractDNodeDiagramElementState(Identifier id, DiagramCrossReferencer crossReferencer) {
        super(id, crossReferencer);
    }

    @Override
    public void storeElementState(EObject target, DiagramElementMapping mapping, D element) {
        super.storeElementState(target, mapping, element);
        Iterable existingArrangeConstraints = Iterables.filter((Iterable)element.getArrangeConstraints(), ArrangeConstraint.class);
        if (!Iterables.isEmpty((Iterable)existingArrangeConstraints)) {
            Iterables.addAll(this.arrangeConstraints, (Iterable)existingArrangeConstraints);
        }
    }

    @Override
    public void restoreElementState(D element) {
        super.restoreElementState(element);
        if (!this.arrangeConstraints.isEmpty()) {
            element.getArrangeConstraints().addAll(this.arrangeConstraints);
        }
    }
}

