/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.swt.gef.tools;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.util.EditPartUtilities;
import org.eclipse.sapphire.ui.swt.gef.model.DiagramNodeModel;
import org.eclipse.sapphire.ui.swt.gef.model.ShapeModel;
import org.eclipse.sapphire.ui.swt.gef.tools.SapphireNodeDragEditPartsTracker;
import org.eclipse.swt.SWT;

public class SapphireDragEditPartsTracker
extends SapphireNodeDragEditPartsTracker {
    public SapphireDragEditPartsTracker(EditPart sourceEditPart) {
        super(sourceEditPart);
    }

    @Override
    protected void performSelection() {
        if (this.hasSelectionOccurred()) {
            return;
        }
        this.setFlag(64, true);
        EditPartViewer viewer = this.getCurrentViewer();
        List selectedObjects = viewer.getSelectedEditParts();
        if (this.getCurrentInput().isModKeyDown(SWT.MOD1)) {
            EditPart deselectPart = this.getDeselectPart(selectedObjects, this.getSourceEditPart());
            if (deselectPart != null) {
                viewer.deselect(deselectPart);
            } else if (!this.isParentSelected(this.getSourceEditPart())) {
                viewer.appendSelection(this.getSourceEditPart());
                this.removeChildrenDuplicates(this.getSourceEditPart());
            }
            viewer.setProperty("LAST_EDIT_PART", (Object)this.getSourceEditPart());
        } else if (this.getCurrentInput().isShiftKeyDown()) {
            EditPart fromEditPart = (EditPart)viewer.getProperty("LAST_EDIT_PART");
            if (this.sameNodeModel(fromEditPart, this.getSourceEditPart())) {
                viewer.deselectAll();
                EditPart toEditPart = this.getSourceEditPart();
                Rectangle fromRect = this.getRectangle(fromEditPart);
                Rectangle toRect = this.getRectangle(toEditPart);
                Rectangle rect = fromRect.getUnion(toRect);
                HashSet editPartsToProcess = new HashSet();
                editPartsToProcess.addAll(EditPartUtilities.getAllChildren((GraphicalEditPart)this.getNodeEditPart(fromEditPart)));
                ArrayList<EditPart> selectedEditParts = new ArrayList<EditPart>();
                for (GraphicalEditPart editPart : editPartsToProcess) {
                    if (!editPart.isSelectable() || !FigureUtilities.isNotFullyClipped((IFigure)editPart.getFigure()) || !this.isEditPartInRect((EditPart)editPart, rect)) continue;
                    selectedEditParts.add((EditPart)editPart);
                }
                this.filterEditParts(selectedEditParts, fromEditPart, this.getSourceEditPart());
                for (EditPart editPart : selectedEditParts) {
                    viewer.appendSelection(editPart);
                }
            } else {
                viewer.appendSelection(this.getSourceEditPart());
                viewer.setProperty("LAST_EDIT_PART", (Object)this.getSourceEditPart());
            }
        } else {
            viewer.select(this.getSourceEditPart());
            viewer.setProperty("LAST_EDIT_PART", (Object)this.getSourceEditPart());
        }
    }

    private boolean isParentSelected(EditPart sourceEditPart) {
        EditPartViewer viewer = this.getCurrentViewer();
        List selectedParts = viewer.getSelectedEditParts();
        EditPart parent = sourceEditPart.getParent();
        while (parent != null) {
            if (selectedParts.contains(parent)) {
                return true;
            }
            parent = parent.getParent();
        }
        return false;
    }

    private void filterEditParts(List<EditPart> list, EditPart part1, EditPart part2) {
        this.removeParent(list, part1);
        this.removeParent(list, part2);
        ArrayList<EditPart> toRemove = new ArrayList<EditPart>(list.size());
        for (EditPart part : list) {
            if (!this.hasParentInList(list, part)) continue;
            toRemove.add(part);
        }
        list.removeAll(toRemove);
    }

    private void removeParent(List<EditPart> list, EditPart part) {
        EditPart parent = part.getParent();
        while (parent != null) {
            list.remove(parent);
            parent = parent.getParent();
        }
    }

    private boolean hasParentInList(List<EditPart> list, EditPart part) {
        EditPart parent = part.getParent();
        while (parent != null) {
            if (list.contains(parent)) {
                return true;
            }
            parent = parent.getParent();
        }
        return false;
    }

    private boolean isEditPartInRect(EditPart editPart, Rectangle selectionRect) {
        boolean included = false;
        if (!(editPart instanceof ConnectionEditPart)) {
            Rectangle rect = this.getRectangle(editPart);
            included = selectionRect.intersects(rect);
        }
        return included;
    }

    private Rectangle getRectangle(EditPart editPart) {
        if (editPart instanceof GraphicalEditPart) {
            IFigure figure = ((GraphicalEditPart)editPart).getFigure();
            Rectangle r = figure.getBounds().getCopy();
            figure.translateToAbsolute((Translatable)r);
            return r;
        }
        return null;
    }

    private boolean sameNodeModel(EditPart part1, EditPart part2) {
        if (part1 != null && part2 != null) {
            ShapeModel model1 = (ShapeModel)part1.getModel();
            ShapeModel model2 = (ShapeModel)part2.getModel();
            return model1.getNodeModel().equals(model2.getNodeModel());
        }
        return false;
    }

    private GraphicalEditPart getNodeEditPart(EditPart part) {
        DiagramNodeModel nodeModel = ((ShapeModel)part.getModel()).getNodeModel();
        EditPart parentEditPart = part;
        while (parentEditPart != null) {
            if (nodeModel.equals(parentEditPart.getModel())) {
                return (GraphicalEditPart)parentEditPart;
            }
            parentEditPart = parentEditPart.getParent();
        }
        return (GraphicalEditPart)this.getCurrentViewer().getRootEditPart();
    }
}

